package pickewanalysis.ewpicker;

import pickewanalysis.ewmessages.EWMessage;

public class PickEWDebugMsg extends EWMessage {
    //Variables
    protected long msgTime;
    protected int msgType;
    //Message Types
    public static final int EVENT_OVER = 0;
    public static final int PICK_REJECTED_CODA_TOO_SHORT = -1;
    public static final int PICK_REJECTED_NO_RECENT_ZERO_CROSSINGS = -2;
    public static final int PICK_REJECTED_NOISE_PICK = -3;
    //Construct
    protected PickEWDebugMsg(long time, int type) {
        this.msgTime = time;
        this.msgType = type;
    }
    //Utilities
    public int getType() {
        return msgType;
    }
    
    public long getTime() {
        return msgTime;
    }

    public String toString() {
        switch (msgType) {
            case EVENT_OVER:
                return "Event Over";
            case PICK_REJECTED_CODA_TOO_SHORT:
                return "Coda too short";
            case PICK_REJECTED_NO_RECENT_ZERO_CROSSINGS:
                return "No recent zero crossings";
            case PICK_REJECTED_NOISE_PICK:
                return "Noise pick";
        }
        return "";
    }
}
