/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.inspector;

import java.io.File;
import java.io.IOException;
import org.rrd4j.core.ArcDef;
import org.rrd4j.core.DsDef;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;

class RrdNode {
    private int dsIndex = -1;
    private int arcIndex = -1;
    private String label;

    RrdNode(RrdDb rrd) {
        String path = rrd.getRrdBackend().getPath();
        this.label = new File(path).getName();
    }

    RrdNode(RrdDb rrd, int dsIndex) throws IOException {
        this.dsIndex = dsIndex;
        RrdDef def = rrd.getRrdDef();
        DsDef[] dsDefs = def.getDsDefs();
        this.label = dsDefs[dsIndex].dump();
    }

    RrdNode(RrdDb rrd, int dsIndex, int arcIndex) throws IOException {
        this.dsIndex = dsIndex;
        this.arcIndex = arcIndex;
        ArcDef[] arcDefs = rrd.getRrdDef().getArcDefs();
        this.label = arcDefs[arcIndex].dump();
    }

    int getDsIndex() {
        return this.dsIndex;
    }

    int getArcIndex() {
        return this.arcIndex;
    }

    public String toString() {
        return this.label;
    }
}

