/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.OB.Assert;
import org.omg.CORBA.Any;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueMember;

public final class TypeCodeFactory {
    private static TypeCode[] primitives_ = new TypeCode[33];

    private TypeCodeFactory() {
    }

    public static TypeCode createPrimitiveTC(TCKind tCKind) {
        Assert.assert(tCKind.value() < primitives_.length);
        if (primitives_[tCKind.value()] != null) {
            return primitives_[tCKind.value()];
        }
        TypeCode typeCode = null;
        if (tCKind == TCKind.tk_null || tCKind == TCKind.tk_void || tCKind == TCKind.tk_short || tCKind == TCKind.tk_long || tCKind == TCKind.tk_ushort || tCKind == TCKind.tk_ulong || tCKind == TCKind.tk_float || tCKind == TCKind.tk_double || tCKind == TCKind.tk_boolean || tCKind == TCKind.tk_char || tCKind == TCKind.tk_octet || tCKind == TCKind.tk_any || tCKind == TCKind.tk_TypeCode || tCKind == TCKind.tk_Principal || tCKind == TCKind.tk_string || tCKind == TCKind.tk_longlong || tCKind == TCKind.tk_ulonglong || tCKind == TCKind.tk_longdouble || tCKind == TCKind.tk_wchar || tCKind == TCKind.tk_wstring || tCKind == TCKind.tk_fixed) {
            com.ooc.CORBA.TypeCode typeCode2 = new com.ooc.CORBA.TypeCode();
            typeCode2.kind_ = tCKind;
            typeCode2.length_ = 0;
            typeCode = typeCode2;
        } else if (tCKind == TCKind.tk_objref) {
            typeCode = TypeCodeFactory.createInterfaceTC("IDL:omg.org/CORBA/Object:1.0", "Object");
        } else if (tCKind == TCKind.tk_value) {
            typeCode = TypeCodeFactory.createValueTC("IDL:omg.org/CORBA/ValueBase:1.0", "ValueBase", (short)2, null, new ValueMember[0]);
        } else {
            Assert.assert(false);
        }
        TypeCodeFactory.primitives_[tCKind.value()] = typeCode;
        return typeCode;
    }

    public static TypeCode createStructTC(String string, String string2, StructMember[] structMemberArray) {
        Assert.assert(string != null && string2 != null);
        com.ooc.CORBA.TypeCode typeCode = new com.ooc.CORBA.TypeCode();
        typeCode.kind_ = TCKind.tk_struct;
        typeCode.id_ = string;
        typeCode.name_ = string2;
        typeCode.memberNames_ = new String[structMemberArray.length];
        typeCode.memberTypes_ = new com.ooc.CORBA.TypeCode[structMemberArray.length];
        int n = 0;
        while (n < structMemberArray.length) {
            typeCode.memberNames_[n] = structMemberArray[n].name;
            typeCode.memberTypes_[n] = (com.ooc.CORBA.TypeCode)structMemberArray[n].type;
            ++n;
        }
        com.ooc.CORBA.TypeCode._OB_embedRecTC(typeCode);
        return typeCode;
    }

    public static TypeCode createUnionTC(String string, String string2, TypeCode typeCode, UnionMember[] unionMemberArray) {
        Assert.assert(string != null && string2 != null);
        com.ooc.CORBA.TypeCode typeCode2 = new com.ooc.CORBA.TypeCode();
        typeCode2.kind_ = TCKind.tk_union;
        typeCode2.id_ = string;
        typeCode2.name_ = string2;
        typeCode2.discriminatorType_ = (com.ooc.CORBA.TypeCode)typeCode;
        typeCode2.labels_ = new Any[unionMemberArray.length];
        typeCode2.memberNames_ = new String[unionMemberArray.length];
        typeCode2.memberTypes_ = new com.ooc.CORBA.TypeCode[unionMemberArray.length];
        int n = 0;
        while (n < unionMemberArray.length) {
            typeCode2.labels_[n] = unionMemberArray[n].label;
            typeCode2.memberNames_[n] = unionMemberArray[n].name;
            typeCode2.memberTypes_[n] = (com.ooc.CORBA.TypeCode)unionMemberArray[n].type;
            ++n;
        }
        com.ooc.CORBA.TypeCode._OB_embedRecTC(typeCode2);
        return typeCode2;
    }

    public static TypeCode createEnumTC(String string, String string2, String[] stringArray) {
        Assert.assert(string != null && string2 != null);
        com.ooc.CORBA.TypeCode typeCode = new com.ooc.CORBA.TypeCode();
        typeCode.kind_ = TCKind.tk_enum;
        typeCode.id_ = string;
        typeCode.name_ = string2;
        typeCode.memberNames_ = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            typeCode.memberNames_[n] = stringArray[n];
            ++n;
        }
        return typeCode;
    }

    public static TypeCode createAliasTC(String string, String string2, TypeCode typeCode) {
        Assert.assert(string != null && string2 != null);
        com.ooc.CORBA.TypeCode typeCode2 = new com.ooc.CORBA.TypeCode();
        typeCode2.kind_ = TCKind.tk_alias;
        typeCode2.id_ = string;
        typeCode2.name_ = string2;
        typeCode2.contentType_ = (com.ooc.CORBA.TypeCode)typeCode;
        return typeCode2;
    }

    public static TypeCode createExceptionTC(String string, String string2, StructMember[] structMemberArray) {
        Assert.assert(string != null && string2 != null);
        com.ooc.CORBA.TypeCode typeCode = new com.ooc.CORBA.TypeCode();
        typeCode.kind_ = TCKind.tk_except;
        typeCode.id_ = string;
        typeCode.name_ = string2;
        typeCode.memberNames_ = new String[structMemberArray.length];
        typeCode.memberTypes_ = new com.ooc.CORBA.TypeCode[structMemberArray.length];
        int n = 0;
        while (n < structMemberArray.length) {
            typeCode.memberNames_[n] = structMemberArray[n].name;
            typeCode.memberTypes_[n] = (com.ooc.CORBA.TypeCode)structMemberArray[n].type;
            ++n;
        }
        com.ooc.CORBA.TypeCode._OB_embedRecTC(typeCode);
        return typeCode;
    }

    public static TypeCode createInterfaceTC(String string, String string2) {
        Assert.assert(string != null && string2 != null);
        com.ooc.CORBA.TypeCode typeCode = new com.ooc.CORBA.TypeCode();
        typeCode.kind_ = TCKind.tk_objref;
        typeCode.id_ = string;
        typeCode.name_ = string2;
        return typeCode;
    }

    public static TypeCode createStringTC(int n) {
        Assert.assert(n >= 0);
        com.ooc.CORBA.TypeCode typeCode = new com.ooc.CORBA.TypeCode();
        typeCode.kind_ = TCKind.tk_string;
        typeCode.length_ = n;
        return typeCode;
    }

    public static TypeCode createWStringTC(int n) {
        Assert.assert(n >= 0);
        com.ooc.CORBA.TypeCode typeCode = new com.ooc.CORBA.TypeCode();
        typeCode.kind_ = TCKind.tk_wstring;
        typeCode.length_ = n;
        return typeCode;
    }

    public static TypeCode createFixedTC(short s, short s2) {
        Assert.assert(s >= 0);
        com.ooc.CORBA.TypeCode typeCode = new com.ooc.CORBA.TypeCode();
        typeCode.kind_ = TCKind.tk_fixed;
        typeCode.fixedDigits_ = s;
        typeCode.fixedScale_ = s2;
        return typeCode;
    }

    public static TypeCode createSequenceTC(int n, TypeCode typeCode) {
        Assert.assert(n >= 0);
        com.ooc.CORBA.TypeCode typeCode2 = new com.ooc.CORBA.TypeCode();
        typeCode2.kind_ = TCKind.tk_sequence;
        typeCode2.length_ = n;
        typeCode2.contentType_ = (com.ooc.CORBA.TypeCode)typeCode;
        return typeCode2;
    }

    public static TypeCode createRecursiveSequenceTC(int n, int n2) {
        throw new NO_IMPLEMENT();
    }

    public static TypeCode createArrayTC(int n, TypeCode typeCode) {
        Assert.assert(n >= 0);
        com.ooc.CORBA.TypeCode typeCode2 = new com.ooc.CORBA.TypeCode();
        typeCode2.kind_ = TCKind.tk_array;
        typeCode2.length_ = n;
        typeCode2.contentType_ = (com.ooc.CORBA.TypeCode)typeCode;
        return typeCode2;
    }

    public static TypeCode createValueTC(String string, String string2, short s, TypeCode typeCode, ValueMember[] valueMemberArray) {
        Assert.assert(string != null && string2 != null);
        com.ooc.CORBA.TypeCode typeCode2 = new com.ooc.CORBA.TypeCode();
        typeCode2.kind_ = TCKind.tk_value;
        typeCode2.id_ = string;
        typeCode2.name_ = string2;
        typeCode2.typeModifier_ = s;
        typeCode2.concreteBaseType_ = (com.ooc.CORBA.TypeCode)typeCode;
        typeCode2.memberNames_ = new String[valueMemberArray.length];
        typeCode2.memberTypes_ = new com.ooc.CORBA.TypeCode[valueMemberArray.length];
        typeCode2.memberVisibility_ = new short[valueMemberArray.length];
        int n = 0;
        while (n < valueMemberArray.length) {
            typeCode2.memberNames_[n] = valueMemberArray[n].name;
            typeCode2.memberTypes_[n] = (com.ooc.CORBA.TypeCode)valueMemberArray[n].type;
            typeCode2.memberVisibility_[n] = valueMemberArray[n].access;
            ++n;
        }
        com.ooc.CORBA.TypeCode._OB_embedRecTC(typeCode2);
        return typeCode2;
    }

    public static TypeCode createValueBoxTC(String string, String string2, TypeCode typeCode) {
        Assert.assert(string != null && string2 != null);
        com.ooc.CORBA.TypeCode typeCode2 = new com.ooc.CORBA.TypeCode();
        typeCode2.kind_ = TCKind.tk_value_box;
        typeCode2.id_ = string;
        typeCode2.name_ = string2;
        typeCode2.contentType_ = (com.ooc.CORBA.TypeCode)typeCode;
        return typeCode2;
    }

    public static TypeCode createNativeTC(String string, String string2) {
        Assert.assert(string != null && string2 != null);
        com.ooc.CORBA.TypeCode typeCode = new com.ooc.CORBA.TypeCode();
        typeCode.kind_ = TCKind.tk_native;
        typeCode.id_ = string;
        typeCode.name_ = string2;
        return typeCode;
    }

    public static TypeCode createRecursiveTC(String string) {
        Assert.assert(string != null);
        com.ooc.CORBA.TypeCode typeCode = new com.ooc.CORBA.TypeCode();
        typeCode.recId_ = string;
        return typeCode;
    }

    public static TypeCode createAbstractInterfaceTC(String string, String string2) {
        Assert.assert(string != null && string2 != null);
        com.ooc.CORBA.TypeCode typeCode = new com.ooc.CORBA.TypeCode();
        typeCode.kind_ = TCKind.tk_abstract_interface;
        typeCode.id_ = string;
        typeCode.name_ = string2;
        return typeCode;
    }
}

