/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.tools.pannel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import gov.usgs.util.Util;
import gov.usgs.winston.tools.WinstonToolsPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTextField;

public class TimePanel
extends WinstonToolsPanel {
    private static final long serialVersionUID = 1L;
    private static final Color RED = new Color(16752762);
    private static final Color WHITE = new Color(0xFFFFFF);
    private static final NumberFormat timeFormatter = new DecimalFormat("#0.000");
    private JTextField standardF;
    private JTextField inputF;
    private JTextField ewF;
    private JTextField j2kF;
    private JButton nowB;
    private Time time;

    public TimePanel() {
        super("Time");
    }

    @Override
    protected void createUI() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Time Conversion"));
        FormLayout layout = new FormLayout("right:max(40dlu;p), 4dlu, left:p", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("Time Formats");
        builder.append("Standard", (Component)this.standardF);
        builder.nextLine();
        builder.append("Input", (Component)this.inputF);
        builder.nextLine();
        builder.append("J2K", (Component)this.j2kF);
        builder.nextLine();
        builder.append("EW", (Component)this.ewF);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append("", (Component)this.nowB);
        this.add((Component)builder.getPanel(), "Center");
    }

    @Override
    protected void createFields() {
        this.time = new Time();
        this.standardF = new StandardTimeBox();
        this.inputF = new InputTimeBox();
        this.ewF = new EwBox();
        this.j2kF = new J2kBox();
        this.time.setDate();
        this.nowB = new JButton("Now");
        this.nowB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimePanel.this.time.setDate();
            }
        });
    }

    @Override
    public boolean needsWinston() {
        return false;
    }

    public class Time
    extends Observable {
        Date date;

        public Time() {
            this.setDate();
        }

        public void setDate() {
            this.setDate(new Date());
        }

        public void setDate(Date d) {
            this.date = d;
            this.setChanged();
            this.notifyObservers();
        }

        public double getJ2k() {
            return Util.dateToJ2K(this.date);
        }

        public double getEW() {
            return Util.j2KToEW(Util.dateToJ2K(this.date));
        }

        public String getInputTime() {
            return gov.usgs.util.Time.format("yyyyMMddHHmmss", this.date);
        }

        public String getStandardTime() {
            return gov.usgs.util.Time.format("yyyy-MM-dd HH:mm:ss", this.date);
        }
    }

    public class J2kBox
    extends JTextField
    implements Observer {
        private static final long serialVersionUID = 1L;

        public J2kBox() {
            super(20);
            TimePanel.this.time.addObserver(this);
            this.setToolTipText("seconds past 2000-01-01 12:00:00 UTC");
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    J2kBox.this.updateTime(J2kBox.this.getText());
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    J2kBox.this.updateTime(J2kBox.this.getText());
                }
            });
        }

        public final void updateTime(String s) {
            try {
                TimePanel.this.time.setDate(Util.j2KToDate(Double.parseDouble(s)));
            }
            catch (NumberFormatException ex) {
                this.setBackground(RED);
            }
        }

        @Override
        public void update(Observable o, Object arg) {
            double d = ((Time)o).getJ2k();
            this.setText(timeFormatter.format(d));
            this.setBackground(WHITE);
        }
    }

    public class EwBox
    extends JTextField
    implements Observer {
        private static final long serialVersionUID = 1L;

        public EwBox() {
            super(20);
            TimePanel.this.time.addObserver(this);
            this.setToolTipText("seconds past 1970-01-01 00:00:00 UTC");
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EwBox.this.updateTime(EwBox.this.getText());
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    EwBox.this.updateTime(EwBox.this.getText());
                }
            });
        }

        public final void updateTime(String s) {
            try {
                TimePanel.this.time.setDate(Util.j2KToDate(Util.ewToJ2K(Double.parseDouble(s))));
            }
            catch (NumberFormatException ex) {
                this.setBackground(RED);
            }
        }

        @Override
        public void update(Observable o, Object arg) {
            double d = ((Time)o).getEW();
            this.setText(timeFormatter.format(d));
            this.setBackground(WHITE);
        }
    }

    public class InputTimeBox
    extends JTextField
    implements Observer {
        private static final long serialVersionUID = 1L;

        public InputTimeBox() {
            super(20);
            TimePanel.this.time.addObserver(this);
            this.setToolTipText("yyyyMMddHHmmss");
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    InputTimeBox.this.updateTime(InputTimeBox.this.getText());
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    InputTimeBox.this.updateTime(InputTimeBox.this.getText());
                }
            });
        }

        public final void updateTime(String s) {
            double d = gov.usgs.util.Time.parse("yyyyMMddHHmmss", this.getText());
            if (d != 0.0) {
                TimePanel.this.time.setDate(Util.j2KToDate(d));
            } else {
                this.setBackground(RED);
            }
        }

        @Override
        public void update(Observable o, Object arg) {
            this.setText("" + ((Time)o).getInputTime());
            this.setBackground(WHITE);
        }
    }

    public class StandardTimeBox
    extends JTextField
    implements Observer {
        private static final long serialVersionUID = 1L;

        public StandardTimeBox() {
            super(20);
            TimePanel.this.time.addObserver(this);
            this.setToolTipText("yyyy-MM-dd HH:mm:ss");
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    StandardTimeBox.this.updateTime(StandardTimeBox.this.getText());
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    StandardTimeBox.this.updateTime(StandardTimeBox.this.getText());
                }
            });
        }

        public final void updateTime(String s) {
            double d = gov.usgs.util.Time.parse("yyyy-MM-dd HH:mm:ss", this.getText());
            if (d != 0.0) {
                TimePanel.this.time.setDate(Util.j2KToDate(d));
            } else {
                this.setBackground(RED);
            }
        }

        @Override
        public void update(Observable o, Object arg) {
            this.setText("" + ((Time)o).getStandardTime());
            this.setBackground(WHITE);
        }
    }
}

