/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.plot.data.GenericDataMatrix;
import gov.usgs.util.Arguments;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.Channel;
import gov.usgs.vdx.data.Column;
import gov.usgs.vdx.data.Rank;
import gov.usgs.vdx.data.SQLDataSource;
import gov.usgs.vdx.data.SQLDataSourceHandler;
import gov.usgs.vdx.in.ColumnValue;
import gov.usgs.vdx.in.Import;
import gov.usgs.vdx.in.Importer;
import gov.usgs.vdx.in.conn.Connection;
import gov.usgs.vdx.in.hw.Device;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class ImportPoll
extends Import
implements Importer {
    public ConfigFile stationParams;
    public ConfigFile deviceParams;
    public ConfigFile connectionParams;
    public String stationCode;
    public List<String> stationList;
    public Map<String, String> stationChannelMap;
    public Map<String, Device> stationDeviceMap;
    public Map<String, ConfigFile> stationConnectionParamsMap;
    public Map<String, String> stationTimesourceMap;
    public Map<String, Date> stationLastDataTimeMap;
    public String timesource;
    public Date lastDataTime;
    public int postConnectDelay;
    public int betweenPollDelay;
    public int betweenCycleDelay;
    public Connection connection;
    public Device device;

    @Override
    public void initialize(String importerClass, String configFile, boolean verbose) {
        this.logger = Logger.getLogger(importerClass);
        this.processConfigFile(configFile);
    }

    @Override
    public void deinitialize() {
        this.sqlDataSource.disconnect();
    }

    @Override
    public void processConfigFile(String configFile) {
        int i;
        this.logger.log(Level.INFO, "Reading config file " + configFile);
        this.params = new ConfigFile(configFile);
        if (!this.params.wasSuccessfullyRead()) {
            this.logger.log(Level.SEVERE, configFile + " was not successfully read");
            System.exit(-1);
        }
        this.vdxConfig = Util.stringToString(this.params.getString("vdx.config"), "VDX.config");
        if (this.vdxConfig == null) {
            this.logger.log(Level.SEVERE, "vdx.config parameter missing from config file");
            System.exit(-1);
        }
        this.vdxParams = new ConfigFile(this.vdxConfig);
        this.driver = this.vdxParams.getString("vdx.driver");
        this.url = this.vdxParams.getString("vdx.url");
        this.prefix = this.vdxParams.getString("vdx.prefix");
        this.dateOut = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.dateOut.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.postConnectDelay = Util.stringToInt(this.params.getString("postConnectDelay"), 1000);
        this.betweenPollDelay = Util.stringToInt(this.params.getString("betweenPollDelay"), 1000);
        this.betweenCycleDelay = Util.stringToInt(this.params.getString("betweenCycleDelay"), 1000);
        this.rankParams = this.params.getSubConfig("rank");
        this.rankName = Util.stringToString(this.rankParams.getString("name"), "Raw Data");
        this.rankValue = Util.stringToInt(this.rankParams.getString("value"), 1);
        this.rankDefault = Util.stringToInt(this.rankParams.getString("default"), 0);
        this.rank = new Rank(0, this.rankName, this.rankValue, this.rankDefault);
        this.logger.log(Level.INFO, "[Rank] " + this.rankName);
        this.logger.log(Level.INFO, "");
        this.channelMap = new HashMap();
        this.stringList = this.params.getList("channel");
        for (i = 0; i < this.stringList.size(); ++i) {
            this.channelCode = (String)this.stringList.get(i);
            this.channelParams = this.params.getSubConfig(this.channelCode);
            this.channelName = Util.stringToString(this.channelParams.getString("name"), this.channelCode);
            this.channelLon = Util.stringToDouble(this.channelParams.getString("longitude"), Double.NaN);
            this.channelLat = Util.stringToDouble(this.channelParams.getString("latitude"), Double.NaN);
            this.channelHeight = Util.stringToDouble(this.channelParams.getString("height"), Double.NaN);
            this.channelActive = Util.stringToInt(this.channelParams.getString("active"), 1);
            this.channel = new Channel(0, this.channelCode, this.channelName, this.channelLon, this.channelLat, this.channelHeight, this.channelActive);
            this.channelMap.put(this.channelCode, this.channel);
        }
        this.stationList = new ArrayList<String>();
        this.channelList = new ArrayList();
        this.stationChannelMap = new HashMap<String, String>();
        this.stationDeviceMap = new HashMap<String, Device>();
        this.stationConnectionParamsMap = new HashMap<String, ConfigFile>();
        this.stationTimesourceMap = new HashMap<String, String>();
        this.stationLastDataTimeMap = new HashMap<String, Date>();
        this.stringList = this.params.getList("station");
        if (this.stringList == null) {
            this.logger.log(Level.SEVERE, "station parameter(s) missing from config file");
            System.exit(-1);
        }
        for (i = 0; i < this.stringList.size(); ++i) {
            this.stationCode = (String)this.stringList.get(i);
            this.stationParams = this.params.getSubConfig(this.stationCode);
            this.deviceParams = this.stationParams.getSubConfig("device");
            this.connectionParams = this.stationParams.getSubConfig("connection");
            this.channelCode = Util.stringToString(this.stationParams.getString("channel"), this.stationCode);
            this.timesource = this.stationParams.getString("timesource");
            if (this.timesource == null) {
                this.logger.log(Level.SEVERE, "timesource parameter for " + this.stationCode + " missing from config file");
                System.exit(-1);
            }
            try {
                Class<?> connClass = Class.forName(this.connectionParams.getString("driver"));
                Constructor<?> cnst = connClass.getConstructor(String.class);
                this.connection = (Connection)cnst.newInstance(this.stationCode);
                this.connection.initialize(this.connectionParams);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Connection initialization failed");
                continue;
            }
            try {
                this.device = (Device)Class.forName(this.deviceParams.getString("driver")).newInstance();
                this.device.initialize(this.deviceParams);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Device driver initialization failed");
                System.exit(-1);
            }
            this.stationList.add(this.stationCode);
            this.channelList.add(this.channelCode);
            this.stationChannelMap.put(this.stationCode, this.channelCode);
            this.stationDeviceMap.put(this.stationCode, this.device);
            this.stationConnectionParamsMap.put(this.stationCode, this.connectionParams);
            this.stationTimesourceMap.put(this.stationCode, this.timesource);
            this.stationLastDataTimeMap.put(this.stationCode, null);
            this.logger.log(Level.INFO, "[Station] " + this.stationCode);
            this.logger.log(Level.INFO, "[Connection] " + this.connection.toString());
            this.logger.log(Level.INFO, "[ConnDriver] " + this.connectionParams.getString("driver"));
            this.logger.log(Level.INFO, "[Device] " + this.device.toString());
            this.logger.log(Level.INFO, "[DevDriver] " + this.deviceParams.getString("driver"));
            this.logger.log(Level.INFO, "[Fields] " + this.device.getFields());
            this.logger.log(Level.INFO, "[Channel] " + this.channelCode);
            this.logger.log(Level.INFO, "[Timesource] " + this.timesource);
            this.logger.log(Level.INFO, "");
            this.connection = null;
        }
        this.channelList = new ArrayList(new HashSet(this.channelList));
        this.defaultChannels = "";
        for (i = 0; i < this.channelList.size(); ++i) {
            this.defaultChannels = this.defaultChannels + (String)this.channelList.get(i) + ",";
        }
        this.defaultChannels = this.defaultChannels.substring(0, this.defaultChannels.length() - 1);
        this.logger.log(Level.INFO, "[defaultChannels] " + this.defaultChannels);
        this.dataSourceList = this.params.getList("dataSource");
        if (this.dataSourceList == null) {
            this.logger.log(Level.SEVERE, "dataSource parameter(s) missing from config file");
            System.exit(-1);
        }
        this.sqlDataSourceHandler = new SQLDataSourceHandler(this.driver, this.url, this.prefix);
        this.sqlDataSourceMap = new HashMap();
        this.dataSourceChannelMap = new HashMap();
        this.dataSourceColumnMap = new HashMap();
        this.dataSourceRIDMap = new HashMap();
        for (i = 0; i < this.dataSourceList.size(); ++i) {
            this.dataSource = (String)this.dataSourceList.get(i);
            this.logger.log(Level.INFO, "[DataSource] " + this.dataSource);
            this.sqlDataSourceDescriptor = this.sqlDataSourceHandler.getDataSourceDescriptor(this.dataSource);
            if (this.sqlDataSourceDescriptor == null) {
                this.logger.log(Level.SEVERE, this.dataSource + " not in vdxSources.config - Skipping");
                continue;
            }
            this.sqlDataSource = this.sqlDataSourceDescriptor.getSQLDataSource();
            this.sqlDataSourceMap.put(this.dataSource, this.sqlDataSource);
            this.dataSourceParams = this.params.getSubConfig(this.dataSource);
            if (this.sqlDataSource.getRanksFlag()) {
                Rank tempRank = this.sqlDataSource.defaultGetRank(this.rank);
                if (tempRank == null) {
                    tempRank = this.sqlDataSource.defaultInsertRank(this.rank);
                }
                if (tempRank == null) {
                    this.logger.log(Level.SEVERE, this.dataSource + " " + this.rank.getName() + " rank creation failed");
                    System.exit(-1);
                }
                this.dataSourceRIDMap.put(this.dataSource, tempRank.getId());
            }
            if (this.sqlDataSource.getColumnsFlag()) {
                this.stringList = this.dataSourceParams.getList("column");
                if (this.stringList != null) {
                    for (int j = 0; j < this.stringList.size(); ++j) {
                        this.columnName = (String)this.stringList.get(j);
                        this.columnParams = this.dataSourceParams.getSubConfig(this.columnName);
                        this.columnIdx = Util.stringToInt(this.columnParams.getString("idx"), i);
                        this.columnDescription = Util.stringToString(this.columnParams.getString("description"), this.columnName);
                        this.columnUnit = Util.stringToString(this.columnParams.getString("unit"), this.columnName);
                        this.columnChecked = Util.stringToBoolean(this.columnParams.getString("checked"), false);
                        this.columnActive = Util.stringToBoolean(this.columnParams.getString("active"), true);
                        this.columnBypass = Util.stringToBoolean(this.columnParams.getString("bypass"), false);
                        this.columnAccumulate = Util.stringToBoolean(this.columnParams.getString("accumulate"), false);
                        this.column = new Column(this.columnIdx, this.columnName, this.columnDescription, this.columnUnit, this.columnChecked, this.columnActive, this.columnBypass, this.columnAccumulate);
                        if (this.sqlDataSource.defaultGetColumn(this.columnName) != null) continue;
                        this.sqlDataSource.defaultInsertColumn(this.column);
                    }
                }
                this.columns = "";
                this.columnList = this.sqlDataSource.defaultGetColumns(true, false);
                for (int j = 0; j < this.columnList.size(); ++j) {
                    this.columns = this.columns + ((Column)this.columnList.get((int)j)).name + ",";
                }
                this.columns = this.columns.substring(0, this.columns.length() - 1);
                this.columns = Util.stringToString(this.dataSourceParams.getString("columns"), this.columns);
                this.dataSourceColumnMap.put(this.dataSource, this.columns);
                this.logger.log(Level.INFO, "[Columns] " + this.columns);
            }
            if (this.sqlDataSource.getTranslationsFlag()) {
                this.sqlDataSource.defaultCreateTranslation();
            }
            this.channels = Util.stringToString(this.dataSourceParams.getString("channels"), this.defaultChannels);
            this.dataSourceChannelMap.put(this.dataSource, this.channels);
            this.logger.log(Level.INFO, "[Channels]" + this.channels);
            if (!this.sqlDataSource.getChannelsFlag()) continue;
            this.channelArray = this.channels.split(",");
            for (int j = 0; j < this.channelArray.length; ++j) {
                this.channelCode = this.channelArray[j];
                this.channel = (Channel)this.channelMap.get(this.channelCode);
                this.channelParams = this.params.getSubConfig(this.channelCode);
                if (this.channel == null) continue;
                if (this.sqlDataSource.defaultGetChannel(this.channel.getCode(), this.sqlDataSource.getChannelTypesFlag()) == null) {
                    if (this.sqlDataSource.getType().equals("tilt")) {
                        this.azimuthNom = Util.stringToDouble(this.channelParams.getString("azimuth"), 0.0);
                        this.sqlDataSource.defaultCreateTiltChannel(this.channel, 1, this.azimuthNom, this.sqlDataSource.getChannelsFlag(), this.sqlDataSource.getTranslationsFlag(), this.sqlDataSource.getRanksFlag(), this.sqlDataSource.getColumnsFlag());
                    } else {
                        this.sqlDataSource.defaultCreateChannel(this.channel, 1, this.sqlDataSource.getChannelsFlag(), this.sqlDataSource.getTranslationsFlag(), this.sqlDataSource.getRanksFlag(), this.sqlDataSource.getColumnsFlag());
                    }
                    this.channel = this.sqlDataSource.defaultGetChannel(this.channel.getCode(), this.sqlDataSource.getChannelTypesFlag());
                    this.channelMap.put(this.channelCode, this.channel);
                }
                if (!this.sqlDataSource.getTranslationsFlag()) continue;
                int tid = 1;
                int extraColumn = 0;
                this.translationParams = this.channelParams.getSubConfig("translation");
                if (this.sqlDataSource.getType().equals("tilt")) {
                    extraColumn = 1;
                }
                DoubleMatrix2D dm = DoubleFactory2D.dense.make(1, this.columnList.size() * 2 + extraColumn);
                String[] columnNames = new String[this.columnList.size() * 2 + extraColumn];
                if (this.sqlDataSource.getType().equals("tilt")) {
                    this.azimuthInst = Util.stringToDouble(this.translationParams.getString("azimuth"), 0.0);
                    dm.setQuick(0, this.columnList.size() * 2, this.azimuthInst);
                    columnNames[this.columnList.size() * 2] = "azimuth";
                }
                for (int k = 0; k < this.columnList.size(); ++k) {
                    this.column = (Column)this.columnList.get(k);
                    this.columnName = this.column.name;
                    double multiplier = Util.stringToDouble(this.translationParams.getString("c" + this.columnName), 1.0);
                    double offset = Util.stringToDouble(this.translationParams.getString("d" + this.columnName), 0.0);
                    dm.setQuick(0, k * 2, multiplier);
                    dm.setQuick(0, k * 2 + 1, offset);
                    columnNames[k * 2] = "c" + this.columnName;
                    columnNames[k * 2 + 1] = "d" + this.columnName;
                }
                GenericDataMatrix gdm = new GenericDataMatrix(dm);
                gdm.setColumnNames(columnNames);
                tid = this.sqlDataSource.defaultGetTranslation(this.channel.getCode(), gdm);
                if (tid == 1) {
                    tid = this.sqlDataSource.defaultInsertTranslation(this.channel.getCode(), gdm);
                }
                if (tid == this.sqlDataSource.defaultGetChannelTranslationID(this.channel.getCode())) continue;
                this.sqlDataSource.defaultUpdateChannelTranslationID(this.channel.getCode(), tid);
            }
        }
    }

    @Override
    public void process(String filename) {
        while (true) {
            this.logger.log(Level.INFO, "");
            this.logger.log(Level.INFO, "BEGIN POLLING CYCLE");
            for (int c = 0; c < this.stationList.size(); ++c) {
                this.stationCode = this.stationList.get(c);
                this.channelCode = this.stationChannelMap.get(this.stationCode);
                this.device = this.stationDeviceMap.get(this.stationCode);
                this.connectionParams = this.stationConnectionParamsMap.get(this.stationCode);
                this.timesource = this.stationTimesourceMap.get(this.stationCode);
                this.fieldArray = this.device.getFields().split(",");
                this.fieldMap = new HashMap();
                for (int i = 0; i < this.fieldArray.length; ++i) {
                    this.fieldMap.put(i, this.fieldArray[i].trim());
                }
                if (this.stationLastDataTimeMap.get(this.stationCode) == null) {
                    this.sqlDataSource = (SQLDataSource)this.sqlDataSourceMap.get(this.timesource);
                    this.lastDataTime = this.sqlDataSource.defaultGetLastDataTime(this.channelCode, this.device.getNullfield(), this.device.getPollhist());
                    this.stationLastDataTimeMap.put(this.stationCode, this.lastDataTime);
                }
                this.lastDataTime = this.stationLastDataTimeMap.get(this.stationCode);
                this.dateIn = new SimpleDateFormat(this.device.getTimestamp());
                this.dateIn.setTimeZone(TimeZone.getTimeZone(this.device.getTimezone()));
                int tries = 0;
                int lineNumber = 0;
                String line = "";
                boolean done = false;
                while (tries < this.device.getMaxtries() && !done) {
                    this.logger.log(Level.INFO, "");
                    this.logger.log(Level.INFO, "Polling " + this.stationCode + " [Try " + ++tries + "/" + this.device.getMaxtries() + "] [lastDataTime:" + this.dateOut.format(this.lastDataTime) + "]");
                    try {
                        Class<?> connClass = Class.forName(this.connectionParams.getString("driver"));
                        Constructor<?> cnst = connClass.getConstructor(String.class);
                        this.connection = (Connection)cnst.newInstance(this.stationCode);
                        this.connection.initialize(this.connectionParams);
                    }
                    catch (Exception e) {
                        this.logger.log(Level.SEVERE, "Connection initialization failed", e);
                        continue;
                    }
                    try {
                        this.connection.connect();
                        Thread.sleep(this.postConnectDelay);
                    }
                    catch (Exception e) {
                        this.logger.log(Level.SEVERE, "Station Connection failed", e);
                        if (!this.connection.isOpen()) continue;
                        this.connection.disconnect();
                        continue;
                    }
                    String dataRequest = "";
                    try {
                        dataRequest = this.device.requestData(this.lastDataTime);
                    }
                    catch (Exception e) {
                        this.logger.log(Level.SEVERE, "Device build request failed", e);
                        this.connection.disconnect();
                        continue;
                    }
                    if (dataRequest.length() > 0) {
                        try {
                            this.connection.writeString(dataRequest);
                            this.logger.log(Level.INFO, "dataRequest:" + dataRequest);
                        }
                        catch (Exception e) {
                            this.logger.log(Level.SEVERE, "Connection send data request failed", e);
                            this.connection.disconnect();
                            continue;
                        }
                    }
                    String dataResponse = "";
                    try {
                        this.connection.emptyMsgQueue();
                        dataResponse = this.connection.readString(this.device);
                    }
                    catch (Exception e) {
                        this.logger.log(Level.SEVERE, "Device receive data response failed", e);
                        this.connection.disconnect();
                        continue;
                    }
                    try {
                        this.device.validateMessage(dataResponse, true);
                    }
                    catch (Exception e) {
                        this.logger.log(Level.SEVERE, "Message validation failed", e);
                        this.connection.disconnect();
                        continue;
                    }
                    this.connection.disconnect();
                    String dataMessage = this.device.formatMessage(dataResponse);
                    StringTokenizer st = new StringTokenizer(dataMessage, "\n");
                    lineNumber = 0;
                    while (st.hasMoreTokens()) {
                        ColumnValue columnValue;
                        double value;
                        String name;
                        ++lineNumber;
                        line = st.nextToken();
                        try {
                            this.device.validateLine(line);
                        }
                        catch (Exception e) {
                            this.logger.log(Level.INFO, "invalid:" + line);
                            continue;
                        }
                        line = this.device.formatLine(line);
                        this.logger.log(Level.INFO, line);
                        Pattern p = Pattern.compile(this.device.getDelimiter());
                        String[] valueArray = p.split(line, -1);
                        HashMap<Integer, String> valueMap = new HashMap<Integer, String>();
                        for (int i = 0; i < valueArray.length; ++i) {
                            valueMap.put(i, valueArray[i].trim());
                        }
                        if (this.fieldMap.size() > valueMap.size()) {
                            this.logger.log(Level.SEVERE, "line " + lineNumber + " has too few values:" + line);
                            continue;
                        }
                        HashMap<Integer, ColumnValue> columnValueMap = new HashMap<Integer, ColumnValue>();
                        int count = 0;
                        String tsValue = "";
                        try {
                            for (int i = 0; i < this.fieldMap.size(); ++i) {
                                name = (String)this.fieldMap.get(i);
                                if (name.equals("IGNORE")) continue;
                                if (name.equals("CHANNEL")) {
                                    this.channelCode = (String)valueMap.get(i);
                                    continue;
                                }
                                if (name.equals("TIMESTAMP")) {
                                    tsValue = tsValue + (String)valueMap.get(i) + " ";
                                    continue;
                                }
                                value = ((String)valueMap.get(i)).length() == 0 ? Double.NaN : Double.parseDouble((String)valueMap.get(i));
                                columnValue = new ColumnValue(name, value);
                                columnValueMap.put(count, columnValue);
                                ++count;
                            }
                        }
                        catch (Exception e) {
                            this.logger.log(Level.SEVERE, "line " + lineNumber + " parse error");
                            this.logger.log(Level.SEVERE, e.getMessage());
                            continue;
                        }
                        if (tsValue.length() == 0) {
                            this.logger.log(Level.SEVERE, "line " + lineNumber + " timestamp not found");
                            continue;
                        }
                        try {
                            String timestamp = tsValue.trim();
                            this.date = this.dateIn.parse(timestamp);
                            this.j2ksec = Util.dateToJ2K(this.date);
                        }
                        catch (ParseException e) {
                            this.logger.log(Level.SEVERE, "line " + lineNumber + " timestamp parse error");
                            continue;
                        }
                        ColumnValue tsColumn = new ColumnValue("j2ksec", this.j2ksec);
                        if (Util.j2KToDate(this.j2ksec).after(this.stationLastDataTimeMap.get(this.stationCode))) {
                            this.stationLastDataTimeMap.put(this.stationCode, Util.j2KToDate(this.j2ksec));
                        }
                        for (int i = 0; i < this.dataSourceList.size(); ++i) {
                            this.dataSource = (String)this.dataSourceList.get(i);
                            this.channels = (String)this.dataSourceChannelMap.get(this.dataSource);
                            this.dsChannelArray = this.channels.split(",");
                            boolean channelMemberOfDataSource = false;
                            for (int j = 0; j < this.dsChannelArray.length; ++j) {
                                if (!this.dsChannelArray[j].equals(this.channelCode)) continue;
                                channelMemberOfDataSource = true;
                            }
                            if (!channelMemberOfDataSource) continue;
                            this.sqlDataSource = (SQLDataSource)this.sqlDataSourceMap.get(this.dataSource);
                            if (this.sqlDataSource == null) {
                                this.logger.log(Level.SEVERE, "line " + lineNumber + " data source " + this.dataSource + " not initialized");
                                continue;
                            }
                            if (this.sqlDataSource.getChannelsFlag() && this.sqlDataSource.defaultGetChannel(this.channelCode, this.sqlDataSource.getChannelTypesFlag()) == null) {
                                this.sqlDataSource.defaultCreateChannel(new Channel(0, this.channelCode, this.channelCode, Double.NaN, Double.NaN, Double.NaN, 1), 1, this.sqlDataSource.getChannelsFlag(), this.sqlDataSource.getTranslationsFlag(), this.sqlDataSource.getRanksFlag(), this.sqlDataSource.getColumnsFlag());
                            }
                            this.columns = (String)this.dataSourceColumnMap.get(this.dataSource);
                            this.columnArray = this.columns.split(",");
                            HashMap<Integer, String> dsColumnMap = new HashMap<Integer, String>();
                            for (int j = 0; j < this.columnArray.length; ++j) {
                                dsColumnMap.put(j, this.columnArray[j]);
                            }
                            this.rid = this.sqlDataSource.getRanksFlag() ? (Integer)this.dataSourceRIDMap.get(this.dataSource) : 1;
                            HashMap<Integer, ColumnValue> dataSourceEntryMap = new HashMap<Integer, ColumnValue>();
                            count = 0;
                            dataSourceEntryMap.put(count, tsColumn);
                            ++count;
                            for (int j = 0; j < columnValueMap.size(); ++j) {
                                columnValue = (ColumnValue)columnValueMap.get(j);
                                name = columnValue.columnName;
                                value = columnValue.columnValue;
                                for (int k = 0; k < dsColumnMap.size(); ++k) {
                                    if (!name.equals(dsColumnMap.get(k))) continue;
                                    dataSourceEntryMap.put(count, columnValue);
                                    ++count;
                                }
                            }
                            DoubleMatrix2D dm = DoubleFactory2D.dense.make(1, dataSourceEntryMap.size());
                            String[] columnNames = new String[dataSourceEntryMap.size()];
                            for (int j = 0; j < dataSourceEntryMap.size(); ++j) {
                                columnValue = (ColumnValue)dataSourceEntryMap.get(j);
                                name = columnValue.columnName;
                                value = columnValue.columnValue;
                                columnNames[j] = name;
                                dm.setQuick(0, j, value);
                            }
                            GenericDataMatrix gdm = new GenericDataMatrix(dm);
                            gdm.setColumnNames(columnNames);
                            this.sqlDataSource.defaultInsertData(this.channelCode, gdm, this.sqlDataSource.getTranslationsFlag(), this.sqlDataSource.getRanksFlag(), this.rid);
                        }
                        done = true;
                    }
                }
                if (done) {
                    this.logger.log(Level.INFO, "Polling " + this.stationCode + " Success");
                } else {
                    this.logger.log(Level.INFO, "Polling " + this.stationCode + " Failure");
                }
                try {
                    Thread.sleep(this.betweenPollDelay);
                    continue;
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Thread.sleep(betweenPollDelay) failed.", e);
                }
            }
            this.logger.log(Level.INFO, "");
            this.logger.log(Level.INFO, "END POLLING CYCLE");
            try {
                Thread.sleep(this.betweenCycleDelay);
                continue;
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Thread.sleep(betweenCycleDelay) failed.", e);
                continue;
            }
            break;
        }
    }

    @Override
    public void outputInstructions(String importerClass, String message) {
        if (message != null) {
            System.err.println(message);
        }
        System.err.println(importerClass + " -c configfile");
    }

    public static void main(String[] as) {
        ImportPoll importer = new ImportPoll();
        Arguments args = new Arguments(as, flags, keys);
        if (args.flagged("-h")) {
            importer.outputInstructions(importer.getClass().getName(), null);
            System.exit(-1);
        }
        if (!args.contains("-c")) {
            importer.outputInstructions(importer.getClass().getName(), "Config file required");
            System.exit(-1);
        }
        importer.initialize(importer.getClass().getName(), args.get("-c"), args.flagged("-v"));
        importer.process("");
        System.exit(0);
    }
}

