/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.render.wave;

import gov.usgs.plot.render.AxisRenderer;
import gov.usgs.plot.render.wave.SliceWaveRenderer;
import java.awt.Color;

public class MinuteMarkingWaveRenderer
extends SliceWaveRenderer {
    @Override
    public void update() {
        this.setExtents(this.viewStartTime, this.viewEndTime, this.minY, this.maxY);
        int hTicks = this.graphWidth / 108;
        int vTicks = this.graphHeight / 24;
        this.createAxis(vTicks);
        this.setXAxisToTime(hTicks, false, false);
        this.getAxis().setInnerLeftLabelAsText(this.yLabelText, -46.0f);
        if (this.title != null) {
            this.getAxis().setLeftLabelAsText(this.title, -56.0f);
        }
    }

    public void createAxis(int vTicks) {
        if (this.axis == null) {
            this.axis = new AxisRenderer(this);
        }
        this.axis.createDefault();
        this.createDefaultYAxis(vTicks, this.yTickMarks, this.yTickValues, true);
        int firstTick = (int)(this.getMinXAxis() + (1.0 - this.getMinXAxis() % 60.0));
        int lastTick = (int)(this.getMaxXAxis() - this.getMinXAxis() % 60.0);
        int tickCount = 1 + (lastTick - firstTick) / 60;
        double[] tickList = new double[tickCount];
        for (int i = 0; i < tickCount; ++i) {
            tickList[i] = firstTick + i * 60;
        }
        if (this.xTickMarks) {
            this.axis.createTopTicks(tickList, 5.0, Color.GRAY);
            this.axis.createBottomTicks(tickList, 5.0, Color.GRAY);
        }
        if (this.xTickValues) {
            this.axis.createBottomTickLabels(tickList, null);
        }
    }
}

