/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.net;

import java.util.HashMap;
import java.util.Map;

public class HttpRequest {
    public final String fullRequest;
    private String method;
    private String resource;
    private String version;
    private String request;
    private String[] lines;
    private Map<String, String> headers;
    private String file;
    private String argumentString;
    private Map<String, String> arguments;
    private boolean valid;

    public HttpRequest(String req) {
        this.fullRequest = req;
        this.headers = new HashMap<String, String>();
        this.arguments = new HashMap<String, String>();
        this.parseRequest();
    }

    protected void parseRequest() {
        this.lines = this.fullRequest.split("\r\n");
        this.request = this.lines[0];
        int index = 0;
        String[] line0 = this.lines[index++].split(" ");
        this.valid = false;
        if (line0.length == 3) {
            this.method = line0[0].trim();
            this.resource = line0[1].trim();
            this.version = line0[2].trim();
            this.valid = true;
        }
        if (this.valid) {
            this.parseResource();
        }
        boolean headersComplete = false;
        while (!headersComplete && index < this.lines.length) {
            String line;
            String[] val;
            if ((val = (line = this.lines[index++]).split(":\\s*", 2)).length > 1) {
                this.headers.put(val[0], val[1]);
                continue;
            }
            headersComplete = true;
        }
        if ("application/x-www-form-urlencoded".equals(this.headers.get("Content-Type"))) {
            this.argumentString = this.argumentString == null ? this.lines[this.lines.length - 1] : this.argumentString + '&' + this.lines[this.lines.length - 1];
            this.parseArguments();
        }
    }

    public String getHeader(String header) {
        return this.headers.get(header);
    }

    protected void parseResource() {
        int index = this.resource.indexOf(63);
        if (index == -1) {
            this.file = this.resource;
            this.argumentString = "";
        } else {
            this.file = this.resource.substring(0, index);
            this.argumentString = this.resource.substring(index + 1);
        }
        this.parseArguments();
    }

    protected void parseArguments() {
        if (this.argumentString == null || this.argumentString.length() == 0) {
            return;
        }
        String[] args = this.argumentString.split("&");
        for (int i = 0; i < args.length; ++i) {
            String[] arg = args[i].split("=");
            if (arg.length != 2) continue;
            this.arguments.put(arg[0], arg[1]);
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getMethod() {
        return this.method;
    }

    public String getResource() {
        return this.resource;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    public String getFile() {
        return this.file;
    }

    public String getArgumentString() {
        return this.argumentString;
    }

    public String getRequest() {
        return this.request;
    }
}

