/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.sac;

import edu.sc.seis.seisFile.sac.SacHeader;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class SacIncrementalloader {
    DataInput in;
    SacHeader header;
    int chunkSize;
    int ptsRead = 0;
    String filename;
    public static final int DEFAULT_SIZE = 10000;

    public SacIncrementalloader(String filename) throws IOException {
        this(filename, 10000);
    }

    public SacIncrementalloader(String filename, int chunkSize) throws IOException {
        this.filename = filename;
        this.in = new DataInputStream(new BufferedInputStream(new FileInputStream(filename)));
        this.header = new SacHeader(this.in);
    }

    public SacHeader getHeader() {
        return this.header;
    }

    public float[] next() throws IOException {
        int remaining = this.header.getNpts() - this.ptsRead;
        float[] dataSection = new float[this.chunkSize < remaining ? this.chunkSize : remaining];
        if (this.ptsRead < this.header.getNpts()) {
            SacTimeSeries.readSomeData(this.in, dataSection, this.header.getByteOrder());
            this.ptsRead += dataSection.length;
            return dataSection;
        }
        return new float[0];
    }

    public void skip(int samples) throws IOException {
        int remaining = this.header.getNpts() - this.ptsRead;
        this.in.skipBytes(samples < remaining ? samples : remaining);
        this.ptsRead += samples < remaining ? samples : remaining;
    }

    public int getNumRemaining() {
        return this.header.getNpts() - this.ptsRead;
    }

    public int getNumRead() {
        return this.ptsRead;
    }
}

