/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import edu.sc.seis.seisFile.BuildVersion;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.client.ISOTimeParser;
import edu.sc.seis.seisFile.fdsnws.AbstractFDSNClient;
import edu.sc.seis.seisFile.fdsnws.FDSNDataSelectQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNDataSelectQueryParams;
import edu.sc.seis.seisFile.mseed.DataHeader;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.DataRecordIterator;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Iterator;

public class DataSelectClient
extends AbstractFDSNClient {
    private static final String OUTPUT = "output";
    private static final String USER = "user";
    private static final String PASSWORD = "password";

    public DataSelectClient(String[] args) throws JSAPException {
        super(args);
    }

    @Override
    protected void addParams() throws JSAPException {
        super.addParams();
        this.add((Parameter)ISOTimeParser.createRequiredParam("begin", "The start time", false));
        this.add((Parameter)ISOTimeParser.createRequiredParam("end", "The end time", true));
        this.add((Parameter)this.createListOption("network", 'n', "network", "A comma separated list of networks to search"));
        this.add((Parameter)this.createListOption("station", 's', "station", "A comma separated list of stations to search"));
        this.add((Parameter)this.createListOption("location", 'l', "location", "A comma separated list of locations to search"));
        this.add((Parameter)this.createListOption("channel", 'c', "channel", "A comma separated list of channels to search"));
        this.add((Parameter)new FlaggedOption(OUTPUT, (StringParser)JSAP.STRING_PARSER, null, false, 'o', OUTPUT, "Filename for outputing DataRecords"));
        this.add((Parameter)new FlaggedOption(USER, (StringParser)JSAP.STRING_PARSER, null, false, '\u0000', USER, "username for restricted data access"));
        this.add((Parameter)new FlaggedOption(PASSWORD, (StringParser)JSAP.STRING_PARSER, null, false, '\u0000', PASSWORD, "password for restricted data access"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block14: {
            JSAPResult result = this.getResult();
            if (this.shouldPrintHelp()) {
                System.out.println(this.jsap.getHelp());
                return;
            }
            if (this.shouldPrintVersion()) {
                System.out.println(BuildVersion.getVersion());
                return;
            }
            if (!this.isSuccess()) {
                Iterator errs = result.getErrorMessageIterator();
                while (errs.hasNext()) {
                    System.err.println("Error: " + errs.next());
                }
                System.err.println();
                System.err.println("Usage: java " + this.getClass().getName());
                System.err.println("                " + this.jsap.getUsage());
                System.err.println();
                System.err.println(this.jsap.getHelp());
                return;
            }
            try {
                FDSNDataSelectQueryParams queryParams = this.configureQuery(result);
                if (this.getResult().getBoolean("printurl")) {
                    System.out.println(queryParams.formURI());
                    return;
                }
                FDSNDataSelectQuerier querier = new FDSNDataSelectQuerier(queryParams);
                if (result.contains(USER) && result.contains(PASSWORD)) {
                    querier.enableRestrictedData(result.getString(USER), result.getString(PASSWORD));
                } else if (!result.contains(USER) && result.contains(PASSWORD) || result.contains(USER) && !result.contains(PASSWORD)) {
                    System.err.println("Must specify both --user and --password or neither.");
                    return;
                }
                if (this.getResult().getBoolean("raw")) {
                    querier.outputRaw(System.out);
                    break block14;
                }
                DataRecordIterator it = querier.getDataRecordIterator();
                try {
                    this.handleResults(it);
                }
                finally {
                    it.close();
                }
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public FDSNDataSelectQueryParams configureQuery(JSAPResult result) throws SeisFileException {
        int i;
        String[] vals;
        FDSNDataSelectQueryParams queryParams = new FDSNDataSelectQueryParams();
        if (result.contains("begin")) {
            queryParams.setStartTime((Date)result.getObject("begin"));
        }
        if (result.contains("end")) {
            queryParams.setEndTime((Date)result.getObject("end"));
        }
        if (result.contains("network")) {
            vals = result.getStringArray("network");
            for (i = 0; i < vals.length; ++i) {
                queryParams.appendToNetwork(vals[i]);
            }
        }
        if (result.contains("station")) {
            vals = result.getStringArray("station");
            for (i = 0; i < vals.length; ++i) {
                queryParams.appendToStation(vals[i]);
            }
        }
        if (result.contains("location")) {
            vals = result.getStringArray("location");
            for (i = 0; i < vals.length; ++i) {
                queryParams.appendToLocation(vals[i]);
            }
        }
        if (result.contains("channel")) {
            vals = result.getStringArray("channel");
            for (i = 0; i < vals.length; ++i) {
                queryParams.appendToChannel(vals[i]);
            }
        }
        if (result.contains("host")) {
            queryParams.setHost(result.getString("host"));
        }
        if (result.contains("baseurl")) {
            try {
                queryParams.internalSetBaseURI(new URI(result.getString("baseurl")));
            }
            catch (URISyntaxException e) {
                throw new SeisFileException("Unable to parse URI: " + result.getString("baseurl"), e);
            }
        }
        return queryParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResults(DataRecordIterator drIter) throws IOException, SeedFormatException {
        if (!drIter.hasNext()) {
            System.out.println("No Data");
        }
        FilterOutputStream out = null;
        try {
            if (this.result.contains(OUTPUT)) {
                out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File(this.result.getString(OUTPUT)))));
            }
            while (drIter.hasNext()) {
                DataRecord dr = drIter.next();
                if (out != null) {
                    dr.write((DataOutputStream)out);
                    continue;
                }
                DataHeader dh = dr.getHeader();
                System.out.println(dh);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static void main(String[] args) throws JSAPException {
        new DataSelectClient(args).run();
    }
}

