/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.winston;

import edu.sc.seis.seisFile.winston.WinstonSCNL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class WinstonTable {
    WinstonSCNL database;
    int year;
    int month;
    int day;
    private static final SimpleDateFormat ymdFormat = new SimpleDateFormat("yyyy_MM_dd");

    protected WinstonTable(WinstonSCNL database, String tableName) throws ParseException {
        this.database = database;
        String[] s = tableName.split("\\$\\$");
        if (s[1].startsWith("H")) {
            s[1] = s[1].substring(1);
        }
        int[] dates = this.parseDate(s[1]);
        this.year = dates[0];
        this.month = dates[1] + 1;
        this.day = dates[2];
    }

    protected WinstonTable(WinstonSCNL database, int year, int month, int day) {
        this.database = database;
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public WinstonSCNL getDatabase() {
        return this.database;
    }

    public String getTableName() {
        return this.internalGetTableName(false);
    }

    public String getHeliTableName() {
        return this.internalGetTableName(true);
    }

    protected String internalGetTableName(boolean isHeliTable) {
        String m = "" + this.getMonth();
        if (this.getMonth() < 10) {
            m = "0" + m;
        }
        String d = "" + this.getDay();
        if (this.getDay() < 10) {
            d = "0" + d;
        }
        String heli = isHeliTable ? "H" : "";
        return this.getDatabase().concatSCNL() + "$$" + heli + this.getYear() + "_" + m + "_" + d;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] parseDate(String ymd) throws ParseException {
        SimpleDateFormat simpleDateFormat = ymdFormat;
        synchronized (simpleDateFormat) {
            Date d = ymdFormat.parse(ymd);
            Calendar cal = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"));
            cal.setTime(d);
            int[] nArray = new int[3];
            nArray[0] = cal.get(1);
            nArray[1] = cal.get(2);
            nArray[2] = cal.get(5);
            return nArray;
        }
    }
}

