/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.demo;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.FetchData;
import org.rrd4j.core.FetchRequest;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.RrdSafeFileBackend;
import org.rrd4j.core.Sample;
import org.rrd4j.core.Util;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;

public class Demo {
    static final long SEED = 1909752002L;
    static final Random RANDOM = new Random(1909752002L);
    static final String FILE = "demo";
    static final long START = Util.getTimestamp(2003, 4, 1);
    static final long END = Util.getTimestamp(2003, 5, 1);
    static final int MAX_STEP = 300;
    static final int IMG_WIDTH = 500;
    static final int IMG_HEIGHT = 300;

    public static void main(String[] args) throws IOException {
        Demo.println("== Starting demo");
        long startMillis = System.currentTimeMillis();
        if (args.length > 0) {
            Demo.println("Setting default backend factory to " + args[0]);
            RrdDb.setDefaultFactory(args[0]);
        }
        long start = START;
        long end = END;
        String rrdPath = Util.getRrd4jDemoPath("demo.rrd");
        String xmlPath = Util.getRrd4jDemoPath("demo.xml");
        String rrdRestoredPath = Util.getRrd4jDemoPath("demo_restored.rrd");
        String imgPath = Util.getRrd4jDemoPath("demo.png");
        String logPath = Util.getRrd4jDemoPath("demo.log");
        PrintWriter log = new PrintWriter(new BufferedOutputStream(new FileOutputStream(logPath, false)));
        Demo.println("== Creating RRD file " + rrdPath);
        RrdDef rrdDef = new RrdDef(rrdPath, start - 1L, 300L);
        rrdDef.addDatasource("sun", DsType.GAUGE, 600L, 0.0, Double.NaN);
        rrdDef.addDatasource("shade", DsType.GAUGE, 600L, 0.0, Double.NaN);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 1, 600);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 6, 700);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 24, 775);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 288, 797);
        rrdDef.addArchive(ConsolFun.MAX, 0.5, 1, 600);
        rrdDef.addArchive(ConsolFun.MAX, 0.5, 6, 700);
        rrdDef.addArchive(ConsolFun.MAX, 0.5, 24, 775);
        rrdDef.addArchive(ConsolFun.MAX, 0.5, 288, 797);
        Demo.println(rrdDef.dump());
        log.println(rrdDef.dump());
        Demo.println("Estimated file size: " + rrdDef.getEstimatedSize());
        RrdDb rrdDb = new RrdDb(rrdDef);
        Demo.println("== RRD file created.");
        if (!rrdDb.getRrdDef().equals(rrdDef)) {
            Demo.println("Invalid RRD file created. This is a serious bug, bailing out");
            return;
        }
        Demo.println("Checking RRD file structure... OK");
        rrdDb.close();
        Demo.println("== RRD file closed.");
        GaugeSource sunSource = new GaugeSource(1200.0, 20.0);
        GaugeSource shadeSource = new GaugeSource(300.0, 10.0);
        Demo.println("== Simulating one month of RRD file updates with step not larger than 300 seconds (* denotes 1000 updates)");
        long t = start;
        int n = 0;
        rrdDb = new RrdDb(rrdPath);
        Sample sample = rrdDb.createSample();
        while (t <= end + 86400L) {
            sample.setTime(t);
            sample.setValue("sun", (double)sunSource.getValue());
            sample.setValue("shade", (double)shadeSource.getValue());
            log.println(sample.dump());
            sample.update();
            t = (long)((double)t + (RANDOM.nextDouble() * 300.0 + 1.0));
            if (++n % 1000 != 0) continue;
            System.out.print("*");
        }
        rrdDb.close();
        Demo.println("");
        Demo.println("== Finished. RRD file updated " + n + " times");
        rrdDb = new RrdDb(rrdPath, true);
        Demo.println("File reopen in read-only mode");
        Demo.println("== Last update time was: " + rrdDb.getLastUpdateTime());
        Demo.println("== Last info was: " + rrdDb.getInfo());
        Demo.println("== Fetching data for the whole month");
        FetchRequest request = rrdDb.createFetchRequest(ConsolFun.AVERAGE, start, end);
        Demo.println(request.dump());
        log.println(request.dump());
        FetchData fetchData = request.fetchData();
        Demo.println("== Data fetched. " + fetchData.getRowCount() + " points obtained");
        Demo.println(fetchData.toString());
        Demo.println("== Dumping fetched data to XML format");
        Demo.println(fetchData.exportXml());
        Demo.println("== Fetch completed");
        Demo.println("== Dumping RRD file to XML file " + xmlPath + " (can be restored with RRDTool)");
        rrdDb.exportXml(xmlPath);
        Demo.println("== Creating RRD file " + rrdRestoredPath + " from XML file " + xmlPath);
        RrdDb rrdRestoredDb = new RrdDb(rrdRestoredPath, xmlPath);
        Demo.println("== Closing both RRD files");
        rrdDb.close();
        Demo.println("== First file closed");
        rrdRestoredDb.close();
        Demo.println("== Second file closed");
        Demo.println("Creating graph " + Util.getLapTime());
        Demo.println("== Creating graph from the second file");
        RrdGraphDef gDef = new RrdGraphDef();
        gDef.setWidth(500);
        gDef.setHeight(300);
        gDef.setFilename(imgPath);
        gDef.setStartTime(start);
        gDef.setEndTime(end);
        gDef.setTitle("Temperatures in May 2003");
        gDef.setVerticalLabel("temperature");
        gDef.datasource("sun", rrdRestoredPath, "sun", ConsolFun.AVERAGE);
        gDef.datasource("shade", rrdRestoredPath, "shade", ConsolFun.AVERAGE);
        gDef.datasource("median", "sun,shade,+,2,/");
        gDef.datasource("diff", "sun,shade,-,ABS,-1,*");
        gDef.datasource("sine", "TIME," + start + ",-," + (end - start) + ",/,2,PI,*,*,SIN,1000,*");
        gDef.line("sun", Color.GREEN, "sun temp");
        gDef.line("shade", Color.BLUE, "shade temp");
        gDef.line("median", Color.MAGENTA, "median value");
        gDef.area("diff", Color.YELLOW, "difference\\r");
        gDef.line("diff", Color.RED, null);
        gDef.line("sine", Color.CYAN, "sine function demo\\r");
        gDef.hrule(2568.0, Color.GREEN, "hrule");
        gDef.vrule((start + 2L * end) / 3L, Color.MAGENTA, "vrule\\r");
        gDef.gprint("sun", ConsolFun.MAX, "maxSun = %.3f%s");
        gDef.gprint("sun", ConsolFun.AVERAGE, "avgSun = %.3f%S\\r");
        gDef.gprint("shade", ConsolFun.MAX, "maxShade = %.3f%S");
        gDef.gprint("shade", ConsolFun.AVERAGE, "avgShade = %.3f%S\\r");
        gDef.print("sun", ConsolFun.MAX, "maxSun = %.3f%s");
        gDef.print("sun", ConsolFun.AVERAGE, "avgSun = %.3f%S\\r");
        gDef.print("shade", ConsolFun.MAX, "maxShade = %.3f%S");
        gDef.print("shade", ConsolFun.AVERAGE, "avgShade = %.3f%S\\r");
        gDef.setImageInfo("<img src='%s' width='%d' height = '%d'>");
        gDef.setPoolUsed(false);
        gDef.setImageFormat("png");
        Demo.println("Rendering graph " + Util.getLapTime());
        RrdGraph graph = new RrdGraph(gDef);
        Demo.println(graph.getRrdGraphInfo().dump());
        Demo.println("== Graph created " + Util.getLapTime());
        Demo.println("== Locks info ==");
        Demo.println(RrdSafeFileBackend.getLockInfo());
        log.close();
        Demo.println("== Demo completed in " + (double)(System.currentTimeMillis() - startMillis) / 1000.0 + " sec");
    }

    static void println(String msg) {
        System.out.println(msg);
    }

    static void print(String msg) {
        System.out.print(msg);
    }

    static class GaugeSource {
        private double value;
        private double step;

        GaugeSource(double value, double step) {
            this.value = value;
            this.step = step;
        }

        long getValue() {
            double oldValue = this.value;
            double increment = RANDOM.nextDouble() * this.step;
            if (RANDOM.nextDouble() > 0.5) {
                increment *= -1.0;
            }
            this.value += increment;
            if (this.value <= 0.0) {
                this.value = 0.0;
            }
            return Math.round(oldValue);
        }
    }
}

