/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.tools.pannel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import gov.usgs.util.Time;
import gov.usgs.winston.PlotHelicorder;
import gov.usgs.winston.tools.FilePanel;
import gov.usgs.winston.tools.ScnlPanel;
import gov.usgs.winston.tools.WinstonToolsRunnablePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PlotHelicorderPanel
extends WinstonToolsRunnablePanel {
    private static final long serialVersionUID = 1L;
    private static final Color RED = new Color(16752762);
    private static final int[] chunkValues = new int[]{10, 15, 20, 30, 60, 120, 180, 360};
    private static final int DEFAULT_CHUNK = 30;
    private static final int[] spanValues = new int[]{2, 4, 6, 12, 24, 48, 72, 96, 120, 144, 168, 192, 216, 240, 264, 288, 312, 336};
    private static final int DEFAULT_SPAN = 24;
    private static final int DEFAULT_HEIGHT = 1280;
    private static final int DEFAULT_WIDTH = 1024;
    private static final String DEFAULT_CLIP_VALUE = "auto";
    private static final String DEFAULT_BAR_RANGE = "auto";
    private static final PlotHelicorder.FileType DEFAULT_FILE_TYPE = PlotHelicorder.FileType.PNG;
    private static final String DEFAULT_FILE_NAME = "heli.png";
    private static final String DEFAULT_TIME_ZONE = "UTC";
    private JTextField waveServerF;
    private JTextField portF;
    private ScnlPanel scnlPanel;
    private FilePanel filePanel;
    private JComboBox chunkList;
    private JComboBox spanList;
    private JTextField end;
    private JButton plotB;
    private ButtonGroup fileTypeGroup;
    private JPanel fileTypePanel;
    private JComboBox timeZones;
    private JTextField height;
    private JTextField width;
    private JCheckBox showClip;
    private JPanel showClipPanel;
    private JTextField clipValue;
    private JTextField barRange;

    public PlotHelicorderPanel() {
        super("Plot Helicorder");
    }

    @Override
    protected void createUI() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Plot Helicorder"));
        FormLayout layout = new FormLayout("right:max(40dlu;p), 4dlu, left:max(40dlu;p)", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("Source Wave Server");
        builder.append("Host", (Component)this.waveServerF);
        builder.nextLine();
        builder.append("Port", (Component)this.portF);
        builder.nextLine();
        builder.appendSeparator("Channel");
        builder.append("SCNL", (Component)this.scnlPanel);
        builder.nextLine();
        builder.appendSeparator("Destination File");
        builder.append("File", (Component)this.filePanel);
        builder.nextLine();
        builder.append("File Type", (Component)this.fileTypePanel);
        builder.nextLine();
        builder.append("Height, px", (Component)this.height);
        builder.nextLine();
        builder.append("Width, px", (Component)this.width);
        builder.nextLine();
        builder.append("Show Clip", (Component)this.showClipPanel);
        builder.nextLine();
        builder.append("Bar Range", (Component)this.barRange);
        builder.nextLine();
        builder.appendSeparator("Time Range");
        builder.nextLine();
        builder.append("End", (Component)this.end);
        builder.nextLine();
        builder.append("Time Zone", (Component)this.timeZones);
        builder.nextLine();
        builder.append("X, minutes", (Component)this.chunkList);
        builder.nextLine();
        builder.append("Y, hours", (Component)this.spanList);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append("", (Component)this.plotB);
        this.add((Component)builder.getPanel(), "Center");
    }

    @Override
    protected void createFields() {
        this.waveServerF = new JTextField(15);
        this.portF = new JTextField();
        this.portF.setText("16022");
        this.scnlPanel = new ScnlPanel();
        this.filePanel = new FilePanel(FilePanel.Type.SAVE);
        this.end = new JTextField(15);
        this.end.setText(Time.format("yyyyMMddHHmmss", new Date()));
        this.end.setToolTipText("yyyyMMddHHmmss");
        this.end.getDocument().addDocumentListener(new TimeRangeDocumentListener(this.end));
        this.fileTypePanel = new JPanel();
        this.fileTypeGroup = new ButtonGroup();
        for (PlotHelicorder.FileType ft : PlotHelicorder.FileType.values()) {
            JRadioButton b = new JRadioButton(ft.name());
            b.addActionListener(new FileTypeActionListener());
            b.setActionCommand(ft.getExtension());
            this.fileTypePanel.add(b);
            this.fileTypeGroup.add(b);
            if (ft != DEFAULT_FILE_TYPE) continue;
            b.setSelected(true);
        }
        this.filePanel.setFileName(DEFAULT_FILE_NAME);
        String[] chunks = new String[chunkValues.length];
        for (int i = 0; i < chunks.length; ++i) {
            chunks[i] = "" + chunkValues[i];
        }
        this.chunkList = new JComboBox<String>(chunks);
        this.chunkList.setSelectedItem("30");
        String[] spans = new String[spanValues.length];
        for (int i = 0; i < spans.length; ++i) {
            spans[i] = "" + spanValues[i];
        }
        this.spanList = new JComboBox<String>(spans);
        this.spanList.setSelectedItem("24");
        Object[] tzs = TimeZone.getAvailableIDs();
        Arrays.sort(tzs);
        this.timeZones = new JComboBox<Object>(tzs);
        this.timeZones.setSelectedItem(DEFAULT_TIME_ZONE);
        this.height = new JTextField(6);
        this.height.setText("1280");
        this.width = new JTextField(6);
        this.width.setText("1024");
        this.barRange = new JTextField(6);
        this.barRange.setText("auto");
        this.clipValue = new JTextField(6);
        this.clipValue.setText("auto");
        this.showClip = new JCheckBox();
        this.showClip.setSelected(true);
        this.showClip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotHelicorderPanel.this.clipValue.setEnabled(PlotHelicorderPanel.this.showClip.isSelected());
            }
        });
        this.showClipPanel = new JPanel();
        this.showClipPanel.add(this.showClip);
        this.showClipPanel.add(this.clipValue);
        this.plotB = new JButton("Generate Plot");
        this.plotB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotHelicorderPanel.this.start();
            }
        });
    }

    @Override
    protected void go() {
        this.plotB.setEnabled(false);
        String server = this.waveServerF.getText().trim();
        int port = Integer.parseInt(this.portF.getText().trim());
        String scnl = this.scnlPanel.getSCNLasSCNL('_');
        String timeZone = (String)this.timeZones.getSelectedItem();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = null;
        try {
            date = dateFormat.parse(this.end.getText());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("-wws");
        args.add(server + ":" + port);
        args.add("-s");
        args.add(scnl);
        args.add("-e");
        args.add(this.end.getText());
        args.add("-m");
        args.add(this.chunkList.getSelectedItem().toString());
        args.add("-h");
        args.add(this.spanList.getSelectedItem().toString());
        args.add("-tz");
        args.add(timeZone);
        args.add("-to");
        args.add("" + TimeZone.getTimeZone(timeZone).getOffset(date.getTime()));
        args.add("-x");
        args.add("1000");
        args.add("-y");
        args.add("1000");
        args.add("-lm");
        args.add("70");
        args.add("-rm");
        args.add("70");
        args.add("-o");
        args.add(this.filePanel.getFileName());
        if (!this.clipValue.getText().equalsIgnoreCase("auto")) {
            args.add("-c");
            args.add(this.clipValue.getText());
        }
        args.add("-b");
        args.add(null);
        args.add("-r");
        args.add("" + (this.showClip.isSelected() ? 1 : 0));
        args.add("-ft");
        args.add(this.fileTypeGroup.getSelection().getActionCommand());
        new PlotHelicorder(args.toArray(new String[0]));
        System.out.println("Done.");
        this.plotB.setEnabled(true);
    }

    @Override
    public boolean needsWinston() {
        return false;
    }

    public class TimeRangeDocumentListener
    implements DocumentListener {
        JTextField f;

        public TimeRangeDocumentListener(JTextField f) {
            this.f = f;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.f.setBackground(this.validateTime() ? Color.white : RED);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.f.setBackground(this.validateTime() ? Color.white : RED);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        private boolean validateTime() {
            try {
                Time.parseTimeRange(this.f.getText());
                return true;
            }
            catch (ParseException ex) {
                return false;
            }
        }
    }

    public class FileTypeActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String sn = PlotHelicorderPanel.this.filePanel.getFileName();
            int i = sn.lastIndexOf(46);
            if (i != -1) {
                sn = sn.substring(0, i);
            }
            sn = sn + "." + e.getActionCommand();
            PlotHelicorderPanel.this.filePanel.setFileName(sn);
        }
    }

    public class TimeRangeOption {
        String title;
        String value;

        public TimeRangeOption(String t, String v) {
            this.title = t;
            this.value = v;
        }

        public String toString() {
            return this.title;
        }

        public String getValue() {
            return this.value;
        }
    }
}

