/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server.cmd.http.fdsn.command;

import gov.usgs.net.HttpRequest;
import gov.usgs.net.HttpResponse;
import gov.usgs.net.NetTools;
import gov.usgs.winston.db.WinstonDatabase;
import gov.usgs.winston.server.WWS;
import gov.usgs.winston.server.cmd.http.fdsn.command.FdsnCommand;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public abstract class FdsnWadlCommand
extends FdsnCommand {
    protected String template;

    public FdsnWadlCommand(NetTools nt, WinstonDatabase db, WWS wws) {
        super(nt, db, wws);
    }

    @Override
    protected void sendResponse() {
        HttpRequest req = new HttpRequest(this.cmd);
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(this.template);
        StringBuilder inputStringBuilder = new StringBuilder();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String line = bufferedReader.readLine();
            while (line != null) {
                inputStringBuilder.append(line + "\n");
                line = bufferedReader.readLine();
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            // empty catch block
        }
        String xml = inputStringBuilder.toString();
        xml = xml.replace("%%HOST%%", req.getHeader("Host"));
        HttpResponse response = new HttpResponse("application/xml");
        response.setLength(xml.length());
        this.netTools.writeString(response.getHeaderString(), this.socketChannel);
        this.netTools.writeString(xml, this.socketChannel);
    }
}

