/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.render;

import gov.usgs.plot.render.FrameRenderer;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;

public class RenderedImageDataRenderer
extends FrameRenderer {
    private double dataMinX;
    private double dataMaxX;
    private double dataMinY;
    private double dataMaxY;
    private RenderedImage image;

    public RenderedImageDataRenderer() {
    }

    public RenderedImageDataRenderer(RenderedImage img) {
        this.image = img;
    }

    public void setImage(RenderedImage img) {
        this.image = img;
    }

    public void setDataExtents(double minX, double maxX, double minY, double maxY) {
        this.dataMinX = minX;
        this.dataMaxX = maxX;
        this.dataMinY = minY;
        this.dataMaxY = maxY;
    }

    @Override
    public void render(Graphics2D g) {
        AffineTransform origAT = g.getTransform();
        Shape origClip = g.getClip();
        if (this.axis != null) {
            this.axis.render(g);
        }
        if (this.image != null) {
            g.clip(new Rectangle(this.graphX + 1, this.graphY + 1, this.graphWidth, this.graphHeight));
            AffineTransform at = new AffineTransform();
            int imageWidth = this.image.getWidth();
            int imageHeight = this.image.getHeight();
            double dataWidth = this.dataMaxX - this.dataMinX;
            double ratioWidth = dataWidth / this.getWidth();
            double dataHeight = this.dataMaxY - this.dataMinY;
            double ratioHeight = dataHeight / this.getHeight();
            at.scale(ratioWidth * (double)this.graphWidth / (double)imageWidth, ratioHeight * (double)this.graphHeight / (double)imageHeight);
            g.translate(this.getXPixel(this.dataMinX), this.getYPixel(this.dataMaxY));
            g.drawRenderedImage(this.image, at);
            g.translate(-this.getXPixel(this.dataMinX), -this.getYPixel(this.dataMaxY));
        }
        g.setClip(origClip);
        g.setTransform(origAT);
        if (this.getLegendRenderer() != null) {
            this.getLegendRenderer().render(g);
        }
    }
}

