/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.render;

import gov.usgs.plot.decorate.SmartTick;
import gov.usgs.plot.render.BasicFrameRenderer;
import gov.usgs.plot.render.InvertedAxisRenderer;

public class InvertedFrameRenderer
extends BasicFrameRenderer {
    @Override
    public double getYPixel(double y) {
        return (y - this.minY) * this.getYScale() + (double)this.graphY;
    }

    @Override
    public void createEmptyAxis() {
        this.axis = new InvertedAxisRenderer(this);
    }

    @Override
    public void createDefaultAxis(int hTicks, int vTicks, boolean isHTicks, boolean isVTicks, boolean hExpand, boolean vExpand, boolean isHValues, boolean isVValues) {
        if (this.axis == null) {
            this.axis = new InvertedAxisRenderer(this);
        }
        this.axis.createDefault();
        this.createDefaultYAxis(vTicks, isVTicks, isVValues, vExpand);
        if (hTicks > 0) {
            double[] t = SmartTick.autoTick(this.getMinXAxis(), this.getMaxXAxis(), hTicks, hExpand);
            if (hExpand) {
                this.minX = t[0];
                this.maxX = t[t.length - 1];
            }
            if (isHTicks) {
                this.axis.createTopTicks(t);
                this.axis.createBottomTicks(t);
                this.axis.createVerticalGridLines(t);
            }
            if (isHValues) {
                this.axis.createBottomTickLabels(t, null);
            }
        }
    }

    @Override
    public double[] getDefaultTranslation(int plotHeight) {
        double dx = (this.maxX - this.minX) / (double)this.graphWidth;
        double dy = (this.maxY - this.minY) / (double)this.graphHeight;
        double[] translation = new double[]{dx, this.minX - dx * (double)this.graphX, dy * -1.0, this.maxY + dy * (double)(plotHeight - this.graphHeight - this.graphY), this.minX, this.maxX, this.minY, this.maxY};
        return translation;
    }
}

