/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data;

import gov.usgs.vdx.data.Exportable;
import gov.usgs.vdx.data.hypo.Hypocenter;
import gov.usgs.vdx.data.hypo.HypocenterList;
import java.util.List;

public class HypocenterExporter
implements Exportable {
    protected List<Hypocenter> hypos;
    protected int expIndex;
    protected int count;
    protected boolean exportAll;

    public HypocenterExporter(HypocenterList hypos, boolean exportAll) {
        this.hypos = hypos.getHypocenters();
        this.count = hypos.size();
        this.resetExport();
        this.exportAll = exportAll;
    }

    @Override
    public void resetExport() {
        this.expIndex = 0;
    }

    private Double fixForExport(Double val) {
        if (val == null) {
            return Double.NaN;
        }
        return val;
    }

    private Double fixForExport(Integer val) {
        if (val == null) {
            return Double.NaN;
        }
        return (double)val;
    }

    private Double fixForExport(String val) {
        if (val == null || val.length() == 0) {
            return Double.NaN;
        }
        return val.charAt(0);
    }

    @Override
    public Double[] getNextExportRow() {
        if (this.expIndex >= this.count) {
            return null;
        }
        Double[] row = this.exportAll ? new Double[16] : new Double[5];
        Hypocenter h = this.hypos.get(this.expIndex);
        row[0] = h.j2ksec;
        row[1] = h.lat;
        row[2] = h.lon;
        row[3] = h.depth;
        row[4] = h.prefmag;
        if (this.exportAll) {
            row[5] = this.fixForExport(h.ampmag);
            row[6] = this.fixForExport(h.codamag);
            row[7] = this.fixForExport(h.nphases);
            row[8] = this.fixForExport(h.azgap);
            row[9] = this.fixForExport(h.dmin);
            row[10] = this.fixForExport(h.rms);
            row[11] = this.fixForExport(h.nstimes);
            row[12] = this.fixForExport(h.herr);
            row[13] = this.fixForExport(h.verr);
            row[14] = this.fixForExport(h.magtype);
            row[15] = this.fixForExport(h.rmk);
        }
        ++this.expIndex;
        return row;
    }

    @Override
    public int length() {
        return this.count;
    }
}

