/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.data.file;

import gov.usgs.plot.data.Wave;
import gov.usgs.plot.data.file.FileType;
import gov.usgs.plot.data.file.SacDataFile;
import gov.usgs.plot.data.file.SeedDataFile;
import gov.usgs.plot.data.file.SeisanDataFile;
import gov.usgs.plot.data.file.TextDataFile;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class SeismicDataFile {
    protected final String groupName;
    protected final String fileName;
    protected Map<String, Wave> waves;
    protected String network;
    protected String station;
    protected String channel;
    protected String location;

    protected SeismicDataFile(String fileName, String groupName) {
        this.fileName = fileName;
        this.groupName = groupName;
        this.waves = new HashMap<String, Wave>();
    }

    public abstract void read() throws IOException;

    public abstract void write() throws IOException;

    public void setNetwork(String network) {
        this.network = network;
    }

    public void setStation(String station) {
        this.station = station;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getGroup() {
        return this.groupName + this.fileName;
    }

    public Set<String> getChannels() {
        return this.waves.keySet();
    }

    public Wave getWave(String channel) {
        return this.waves.get(channel);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void putWave(String channel, Wave wave) {
        this.waves.put(channel, wave);
    }

    public static SeismicDataFile getFile(File file, FileType fileType) {
        return SeismicDataFile.getFile(file.getPath(), fileType);
    }

    public static SeismicDataFile getFile(File file) {
        return SeismicDataFile.getFile(file.getPath());
    }

    public static SeismicDataFile getFile(String fileName) {
        return SeismicDataFile.getFile(fileName, FileType.fromFileName(fileName));
    }

    public static SeismicDataFile getFile(String fileName, FileType fileType) {
        switch (fileType) {
            case SAC: {
                return new SacDataFile(fileName);
            }
            case SEED: {
                return new SeedDataFile(fileName);
            }
            case TEXT: {
                return new TextDataFile(fileName);
            }
            case SEISAN: {
                return new SeisanDataFile(fileName);
            }
        }
        return null;
    }
}

