/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.usgsCWB;

import edu.sc.seis.seisFile.StringMSeedQueryReader;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class CWBReader
extends StringMSeedQueryReader {
    private String host;
    private int port;
    protected int timeoutMillis;
    public static final String DEFAULT_HOST = "cwb-pub.cr.usgs.gov";
    public static final int DEFAULT_PORT = 2061;

    public CWBReader() {
        this(DEFAULT_HOST);
    }

    public CWBReader(String host) {
        this(host, 2061);
    }

    public CWBReader(String host, int port) {
        this(host, port, 0);
    }

    public CWBReader(String host, int port, int timeoutMillis) {
        this.host = host;
        this.port = port;
        this.timeoutMillis = timeoutMillis;
    }

    protected String createQuery(String network, String station, String location, String channel) {
        String query = this.leftPad(network.trim(), 2);
        query = query + this.leftPad(station.trim(), 5);
        query = query + this.leftPad(channel.trim(), 3);
        query = query + this.leftPad(location.trim(), 2);
        return query;
    }

    @Override
    public String createQuery(String network, String station, String location, String channel, Date begin, Date end) {
        String query = "'-s' '" + this.createQuery(network, station, location, channel) + "' ";
        SimpleDateFormat longFormat = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
        longFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        query = query + "'-b' '" + longFormat.format(begin) + "' ";
        query = query + "'-d' '" + (int)Math.ceil((float)(end.getTime() - begin.getTime()) / 1000.0f) + "' ";
        query = query + "'-t' 'ms'";
        query = query + "\t";
        return query;
    }

    @Override
    public List<DataRecord> read(String query) throws IOException, SeedFormatException {
        Socket socket = new Socket(this.host, this.port);
        socket.setReceiveBufferSize(512000);
        if (this.timeoutMillis != 0) {
            socket.setSoTimeout(this.timeoutMillis);
        }
        OutputStream outtcp = socket.getOutputStream();
        outtcp.write(query.getBytes());
        outtcp.flush();
        PushbackInputStream bif = new PushbackInputStream(new BufferedInputStream(socket.getInputStream()), 1);
        DataInputStream in = new DataInputStream(bif);
        ArrayList<DataRecord> records = new ArrayList<DataRecord>();
        try {
            int nextByte;
            while ((nextByte = bif.read()) != 60) {
                bif.unread(nextByte);
                SeedRecord sr = SeedRecord.read(in);
                if (sr instanceof DataRecord) {
                    records.add((DataRecord)sr);
                    continue;
                }
                System.err.println("None data record found, skipping...");
            }
        }
        catch (EOFException e) {
            // empty catch block
        }
        in.close();
        outtcp.close();
        socket.close();
        return records;
    }

    protected String leftPad(String in, int length) {
        if (in.length() == length) {
            return in;
        }
        return this.leftPad(in + "-", length);
    }

    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public void setTimeoutMillis(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

