/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import com.martiansoftware.jsap.JSAPException;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StationClient;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.NetworkIterator;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FDSNStationXML {
    XMLEventReader reader;
    String source;
    String sender;
    String module;
    String moduleUri;
    String created;
    String xmlSchemaLocation;
    String schemaVersion;
    NetworkIterator networks;
    private static final Logger logger = LoggerFactory.getLogger(FDSNStationXML.class);

    public FDSNStationXML(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        this.reader = reader;
        StaxUtil.skipToStartElement(reader);
        StartElement startE = StaxUtil.expectStartElement("FDSNStationXML", reader);
        Attribute schemaLocAttr = startE.getAttributeByName(new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation"));
        this.xmlSchemaLocation = schemaLocAttr.getValue();
        this.schemaVersion = StaxUtil.pullAttribute(startE, "schemaVersion");
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("Source")) {
                    this.source = StaxUtil.pullText(reader, "Source");
                    continue;
                }
                if (elName.equals("Sender")) {
                    this.sender = StaxUtil.pullText(reader, "Sender");
                    continue;
                }
                if (elName.equals("Module")) {
                    this.module = StaxUtil.pullText(reader, "Module");
                    continue;
                }
                if (elName.equals("ModuleURI")) {
                    this.moduleUri = StaxUtil.pullText(reader, "ModuleURI");
                    continue;
                }
                if (elName.equals("Created")) {
                    this.created = StaxUtil.pullText(reader, "Created");
                    continue;
                }
                if (elName.equals("Network")) {
                    this.networks = new NetworkIterator(reader);
                    break;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                return;
            }
            e = reader.nextEvent();
        }
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public NetworkIterator getNetworks() {
        if (this.networks == null) {
            this.networks = new NetworkIterator(null){

                @Override
                public boolean hasNext() throws XMLStreamException {
                    return false;
                }

                @Override
                public Network next() throws XMLStreamException, StationXMLException {
                    throw new StationXMLException("No mo networks");
                }
            };
        }
        return this.networks;
    }

    public void closeReader() {
        try {
            this.reader.close();
        }
        catch (XMLStreamException e) {
            logger.warn("problem closing underlying XMLEventReader.", (Throwable)e);
        }
    }

    public String getXmlSchemaLocation() {
        return this.xmlSchemaLocation;
    }

    public void setXmlSchemaLocation(String xmlns) {
        this.xmlSchemaLocation = xmlns;
    }

    public XMLEventReader getReader() {
        return this.reader;
    }

    public String getModuleUri() {
        return this.moduleUri;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public static Logger getLogger() {
        return logger;
    }

    public boolean checkSchemaVersion() {
        if (!this.xmlSchemaLocation.split(" ")[0].equals("http://www.fdsn.org/xml/station/1")) {
            return false;
        }
        return "1.0".equals(this.getSchemaVersion());
    }

    public static FDSNStationXML createEmpty() {
        try {
            URL url = FDSNStationXML.class.getClassLoader().getResource("edu/sc/seis/seisFile/stationxml/empty.stationxml");
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLEventReader r = factory.createXMLEventReader(url.toString(), url.openStream());
            return new FDSNStationXML(r);
        }
        catch (Exception e) {
            throw new RuntimeException("Should not happen", e);
        }
    }

    public static URL loadSchema() {
        return FDSNStationXML.class.getClassLoader().getResource("edu/sc/seis/seisFile/stationxml/fdsn-station-1.0.xsd");
    }

    public static FDSNStationXML loadStationXML(String filename) throws XMLStreamException, IOException, SeisFileException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLEventReader r = factory.createXMLEventReader(filename, new FileInputStream(filename));
        XMLEvent e = r.peek();
        while (!e.isStartElement()) {
            e = r.nextEvent();
            e = r.peek();
        }
        System.out.println("StaMessage");
        FDSNStationXML fdsnStationXML = new FDSNStationXML(r);
        return fdsnStationXML;
    }

    public static void main(String[] args) throws XMLStreamException, IOException, SeisFileException, JSAPException {
        final FDSNStationXML stationXml = FDSNStationXML.loadStationXML(args[0]);
        StationClient sc = new StationClient(new String[0]){

            @Override
            public void run() {
                try {
                    this.handleResults(stationXml);
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
                catch (SeisFileException e) {
                    e.printStackTrace();
                }
            }
        };
        sc.run();
    }
}

