/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws;

import edu.sc.seis.seisFile.fdsnws.AbstractQueryParams;
import java.util.Date;

public class FDSNEventQueryParams
extends AbstractQueryParams
implements Cloneable {
    public static final String STARTTIME = "starttime";
    public static final String ENDTIME = "endtime";
    public static final String MINLATITUDE = "minlatitude";
    public static final String MAXLATITUDE = "maxlatitude";
    public static final String MINLONGITUDE = "minlongitude";
    public static final String MAXLONGITUDE = "maxlongitude";
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String MINRADIUS = "minradius";
    public static final String MAXRADIUS = "maxradius";
    public static final String MINDEPTH = "mindepth";
    public static final String MAXDEPTH = "maxdepth";
    public static final String MINMAGNITUDE = "minmagnitude";
    public static final String MAXMAGNITUDE = "maxmagnitude";
    public static final String MAGNITUDETYPE = "magnitudetype";
    public static final String INCLUDEALLORIGINS = "includeallorigins";
    public static final String INCLUDEALLMAGNITUDES = "includeallmagnitudes";
    public static final String INCLUDEARRIVALS = "includearrivals";
    public static final String EVENTID = "eventid";
    public static final String LIMIT = "limit";
    public static final String OFFSET = "offset";
    public static final String ORDERBY = "orderby";
    public static final String CATALOG = "catalog";
    public static final String CONTRIBUTOR = "contributor";
    public static final String UPDATEDAFTER = "updatedafter";
    public static final String ORDER_TIME = "time";
    public static final String ORDER_TIME_ASC = "time-asc";
    public static final String ORDER_MAGNITUDE = "magnitude";
    public static final String ORDER_MAGNITUDE_ASC = "magnitude-asc";
    public static final String EVENT_SERVICE = "event";

    public FDSNEventQueryParams() {
        this("service.iris.edu");
    }

    public FDSNEventQueryParams(String host) {
        super(host == null ? "service.iris.edu" : host);
    }

    public FDSNEventQueryParams clone() {
        FDSNEventQueryParams out = new FDSNEventQueryParams(this.getHost());
        for (String key : this.params.keySet()) {
            out.setParam(key, (String)this.params.get(key));
        }
        return out;
    }

    public FDSNEventQueryParams setHost(String host) {
        this.host = host;
        return this;
    }

    public FDSNEventQueryParams setStartTime(Date value) {
        this.setParam(STARTTIME, value);
        return this;
    }

    public FDSNEventQueryParams clearStartTime() {
        this.clearParam(STARTTIME);
        return this;
    }

    public FDSNEventQueryParams setEndTime(Date value) {
        this.setParam(ENDTIME, value);
        return this;
    }

    public FDSNEventQueryParams clearEndTime() {
        this.clearParam(ENDTIME);
        return this;
    }

    public FDSNEventQueryParams setMinLatitude(float value) {
        this.setParam(MINLATITUDE, value);
        return this;
    }

    public FDSNEventQueryParams clearMinLatitude() {
        this.clearParam(MINLATITUDE);
        return this;
    }

    public FDSNEventQueryParams setMaxLatitude(float value) {
        this.setParam(MAXLATITUDE, value);
        return this;
    }

    public FDSNEventQueryParams clearMaxLatitude() {
        this.clearParam(MAXLATITUDE);
        return this;
    }

    public FDSNEventQueryParams setMinLongitude(float value) {
        this.setParam(MINLONGITUDE, value);
        return this;
    }

    public FDSNEventQueryParams clearMinLongitude() {
        this.clearParam(MINLONGITUDE);
        return this;
    }

    public FDSNEventQueryParams setMaxLongitude(float value) {
        this.setParam(MAXLONGITUDE, value);
        return this;
    }

    public FDSNEventQueryParams clearMaxLongitude() {
        this.clearParam(MAXLONGITUDE);
        return this;
    }

    public FDSNEventQueryParams setLatitude(float value) {
        this.setParam(LATITUDE, value);
        return this;
    }

    public FDSNEventQueryParams clearLatitude() {
        this.clearParam(LATITUDE);
        return this;
    }

    public FDSNEventQueryParams setLongitude(float value) {
        this.setParam(LONGITUDE, value);
        return this;
    }

    public FDSNEventQueryParams clearLongitude() {
        this.clearParam(LONGITUDE);
        return this;
    }

    public FDSNEventQueryParams setMinRadius(float value) {
        this.setParam(MINRADIUS, value);
        return this;
    }

    public FDSNEventQueryParams clearMinRadius() {
        this.clearParam(MINRADIUS);
        return this;
    }

    public FDSNEventQueryParams setMaxRadius(float value) {
        this.setParam(MAXRADIUS, value);
        return this;
    }

    public FDSNEventQueryParams clearMaxRadius() {
        this.clearParam(MAXRADIUS);
        return this;
    }

    public FDSNEventQueryParams setMinDepth(float value) {
        this.setParam(MINDEPTH, value);
        return this;
    }

    public FDSNEventQueryParams clearMinDepth() {
        this.clearParam(MINDEPTH);
        return this;
    }

    public FDSNEventQueryParams setMaxDepth(float value) {
        this.setParam(MAXDEPTH, value);
        return this;
    }

    public FDSNEventQueryParams clearMaxDepth() {
        this.clearParam(MAXDEPTH);
        return this;
    }

    public FDSNEventQueryParams setMinMagnitude(float value) {
        this.setParam(MINMAGNITUDE, value);
        return this;
    }

    public FDSNEventQueryParams clearMinMagnitude() {
        this.clearParam(MINMAGNITUDE);
        return this;
    }

    public FDSNEventQueryParams setMaxMagnitude(float value) {
        this.setParam(MAXMAGNITUDE, value);
        return this;
    }

    public FDSNEventQueryParams clearMaxMagnitude() {
        this.clearParam(MAXMAGNITUDE);
        return this;
    }

    public FDSNEventQueryParams setMagnitudeType(String value) {
        this.setParam(MAGNITUDETYPE, value);
        return this;
    }

    public FDSNEventQueryParams clearMagnitudeType() {
        this.clearParam(MAGNITUDETYPE);
        return this;
    }

    public FDSNEventQueryParams setIncludeAllOrigins(boolean value) {
        this.setParam(INCLUDEALLORIGINS, value);
        return this;
    }

    public FDSNEventQueryParams clearIncludeAllOrigins() {
        this.clearParam(INCLUDEALLORIGINS);
        return this;
    }

    public FDSNEventQueryParams setIncludeAllMagnitudes(String value) {
        this.setParam(INCLUDEALLMAGNITUDES, value);
        return this;
    }

    public FDSNEventQueryParams setIncludeAllMagnitudes(boolean value) {
        this.setParam(INCLUDEALLMAGNITUDES, value);
        return this;
    }

    public FDSNEventQueryParams clearIncludeAllMagnitudes() {
        this.clearParam(INCLUDEALLMAGNITUDES);
        return this;
    }

    public FDSNEventQueryParams setIncludeArrivals(boolean value) {
        this.setParam(INCLUDEARRIVALS, value);
        return this;
    }

    public FDSNEventQueryParams clearIncludeArrivals() {
        this.clearParam(INCLUDEARRIVALS);
        return this;
    }

    public FDSNEventQueryParams setEventid(String value) {
        this.setParam(EVENTID, value);
        return this;
    }

    public FDSNEventQueryParams clearEventid() {
        this.clearParam(EVENTID);
        return this;
    }

    public FDSNEventQueryParams setLimit(int value) {
        this.setParam(LIMIT, value);
        return this;
    }

    public FDSNEventQueryParams clearLimit() {
        this.clearParam(LIMIT);
        return this;
    }

    public FDSNEventQueryParams setOffset(int value) {
        this.setParam(OFFSET, value);
        return this;
    }

    public FDSNEventQueryParams clearOffset() {
        this.clearParam(OFFSET);
        return this;
    }

    public FDSNEventQueryParams setOrderBy(String value) {
        this.setParam(ORDERBY, value);
        return this;
    }

    public FDSNEventQueryParams clearOrderBy() {
        this.clearParam(ORDERBY);
        return this;
    }

    public FDSNEventQueryParams setCatalog(String value) {
        this.setParam(CATALOG, value);
        return this;
    }

    public FDSNEventQueryParams clearCatalog() {
        this.clearParam(CATALOG);
        return this;
    }

    public FDSNEventQueryParams setContributor(String value) {
        this.setParam(CONTRIBUTOR, value);
        return this;
    }

    public FDSNEventQueryParams clearContributor() {
        this.clearParam(CONTRIBUTOR);
        return this;
    }

    public FDSNEventQueryParams setUpdatedAfter(Date value) {
        this.setParam(UPDATEDAFTER, value);
        return this;
    }

    public FDSNEventQueryParams clearUpdatedAfter() {
        this.clearParam(UPDATEDAFTER);
        return this;
    }

    public FDSNEventQueryParams area(float minLat, float maxLat, float minLon, float maxLon) {
        return this.setMinLatitude(minLat).setMaxLatitude(maxLat).setMinLongitude(minLon).setMaxLongitude(maxLon);
    }

    public FDSNEventQueryParams ring(float lat, float lon, float maxRadius) {
        return this.setLatitude(lat).setLongitude(lon).setMaxRadius(maxRadius);
    }

    public FDSNEventQueryParams donut(float lat, float lon, float minRadius, float maxRadius) {
        return this.ring(lat, lon, maxRadius).setMinRadius(minRadius);
    }

    @Override
    public String getServiceName() {
        return EVENT_SERVICE;
    }
}

