/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile;

import edu.sc.seis.seisFile.fdsnws.AbstractQueryParams;
import java.text.DateFormat;
import java.util.Date;

public class ChannelTimeWindow {
    String network;
    String station;
    String location;
    String channel;
    Date beginTime;
    Date endTime;

    public ChannelTimeWindow(String network, String station, String location, String channel, Date beginTime, Date endTime) {
        this.network = network;
        this.station = station;
        this.location = location;
        this.channel = channel;
        this.beginTime = beginTime;
        this.endTime = endTime;
    }

    public ChannelTimeWindow(String network, String station, String location, String channel, Date beginTime, int durationSeconds) {
        this(network, station, location, channel, beginTime, new Date(beginTime.getTime() + (long)(1000 * durationSeconds)));
    }

    public String getNetwork() {
        return this.network;
    }

    public String getStation() {
        return this.station;
    }

    public String getLocation() {
        return this.location;
    }

    public String getChannel() {
        return this.channel;
    }

    public Date getBeginTime() {
        return this.beginTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String toString() {
        return this.formString(" ", AbstractQueryParams.createDateFormat(), false);
    }

    public String formString(String seperator, DateFormat df, boolean dashifyLocId) {
        String locId = this.location;
        if (dashifyLocId && ("".equals(locId) || "  ".equals(locId))) {
            locId = "--";
        }
        return this.network + seperator + this.station + seperator + locId + seperator + this.channel + seperator + df.format(this.beginTime) + seperator + df.format(this.endTime);
    }
}

