package pickewanalysis.wavesources;

import java.util.ArrayList;
import org.simpleframework.xml.Element;
import pickewanalysis.waveform.WaveFormGroup;

public abstract class WaveSource extends ArrayList<WaveSourceStation> {

    //Serializable variables
    @Element
    String sourceName;

    // Check if an scnl is available within a given time interval
    // returns integer with the status
    public boolean isSCNL(String stat, String chan, String net, String loc,
            long starttime, long endtime) {
        for (WaveSourceStation station : this) {
            //Check station
            if (station.isSCNL(stat, chan, net, loc)) {
                //Check times
                if (station.starttime<endtime&&station.endtime>starttime) {
                    return true;
                }
            }
        }
        return false;
    }
    
    public WaveSourceStation findStation(String stat, String chan, String net, String loc) {
        for (WaveSourceStation station : this) {
            //Check station
            if (station.isSCNL(stat, chan, net, loc)) {
                return station;
            }
        }
        return null;
    }
    
    public void setName(String name) {
        this.sourceName = name;
    }
    
    @Override
    public String toString() {
        return sourceName;
    }
    
    //Abstract methods
    abstract public void update() throws Exception; //Method to update the info on the wave source    
    abstract public WaveFormGroup read(String stat, String chan,
            String net, String loc, long starttime, long endtime) throws Exception;
}
