package pickewanalysis.ewmessages;

public class CodaSCNL extends EWMessage {

    public final int msgType = TYPE_CODA_SCNL;
    public int instID;
    public int modID;
    public int seqNo;
    public String SCNL;
    public double time; //Of launching the CODA message for sequence purposes
    public int[] peaks;
    public int duration;

    /*
     * Construct introducing all data
     */
    public CodaSCNL(String rawMsg) throws Exception {
        parseRawMsg(rawMsg);
    }
    public CodaSCNL(int modID,
            int instID,
            int seqNo,
            String SCNL,
            int[] peaks,
            int duration,
            double time) {
        this.instID = instID;
        this.modID = modID;
        this.seqNo = seqNo;
        this.SCNL = SCNL;
        this.peaks = peaks;
        this.duration = duration;
        this.time = time;
    }

    public int getType() {
        return msgType;
    }

    public String getRawMsg() {
        return getRawMsg(seqNo);
    }
    public String toString() {
        return getRawMsg(seqNo);
    }

    public String getRawMsg(int customSeqNo) {
        return String.valueOf(msgType) + " "
                + String.valueOf(modID) + " "
                + String.valueOf(instID) + " "
                + String.valueOf(customSeqNo) + " "
                + SCNL.replace(' ', '.') + " "
                + String.valueOf(peaks[0]) + " "
                + String.valueOf(peaks[1]) + " "
                + String.valueOf(peaks[2]) + " "
                + String.valueOf(peaks[3]) + " "
                + String.valueOf(peaks[4]) + " "
                + String.valueOf(peaks[5]) + " "
                + String.valueOf(duration);
    }

    public boolean parseRawMsg(String rawMsg) throws Exception {
        String[] parts = rawMsg.split("[\\s]+");
        int candidateType = Integer.valueOf(parts[0]);
        if (candidateType != this.msgType) {
            throw new Exception("Wrong message type.");
        }
        instID = Integer.valueOf(parts[2]);
        modID = Integer.valueOf(parts[1]);
        seqNo = Integer.valueOf(parts[3]);
        SCNL = parts[4].replace('.', ' ');
        peaks = new int[]{Integer.valueOf(parts[5]),
                    Integer.valueOf(parts[6]),
                    Integer.valueOf(parts[7]),
                    Integer.valueOf(parts[8]),
                    Integer.valueOf(parts[9]),
                    Integer.valueOf(parts[10])};
        duration = Integer.valueOf(parts[11]);
        time = 0;
        return true;
    }

    public byte[] getBytes() {
        return getRawMsg().getBytes();
    }
}
