/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.client;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import edu.sc.seis.seedCodec.BuildVersion;
import java.util.ArrayList;
import java.util.List;

public class AbstractClient {
    public static final String HELP = "help";
    public static final String VERSION = "version";
    protected List<Parameter> params = new ArrayList<Parameter>();
    protected JSAPResult result;
    protected JSAP jsap = new JSAP();
    protected String[] args;
    protected String commandName;
    protected String userAgent = DEFAULT_USER_AGENT;
    public static final String DEFAULT_USER_AGENT = "SeisFile-" + BuildVersion.getVersion();

    protected boolean requiresAtLeastOneArg() {
        return true;
    }

    protected FlaggedOption createListOption(String id, char shortFlag, String longFlag, String help) {
        return this.createListOption(id, shortFlag, longFlag, help, null, (StringParser)JSAP.STRING_PARSER);
    }

    protected FlaggedOption createListOption(String id, char shortFlag, String longFlag, String help, String defaultArg) {
        return this.createListOption(id, shortFlag, longFlag, help, defaultArg, (StringParser)JSAP.STRING_PARSER);
    }

    protected FlaggedOption createListOption(String id, char shortFlag, String longFlag, String help, String defaultArg, StringParser parser) {
        FlaggedOption listOption = new FlaggedOption(id, parser, defaultArg, false, shortFlag, longFlag, help);
        listOption.setList(true);
        listOption.setListSeparator(',');
        return listOption;
    }

    protected void addParams() throws JSAPException {
        this.add((Parameter)new Switch(VERSION, 'v', VERSION, "Print version and exit"));
        this.add((Parameter)new Switch(HELP, 'h', HELP, "Print this message."));
        this.add((Parameter)new FlaggedOption("props", (StringParser)JSAP.STRING_PARSER, null, false, 'p', "props", "Use an additional props file"));
    }

    protected void add(Parameter param) throws JSAPException {
        this.jsap.registerParameter(param);
        this.params.add(param);
    }

    protected boolean isSpecified(Parameter p) {
        return this.result.contains(p.getID());
    }

    public String[] getArgs() {
        return this.args;
    }

    public boolean shouldPrintHelp() {
        return this.result.getBoolean(HELP);
    }

    public boolean shouldPrintVersion() {
        return this.result.getBoolean(VERSION);
    }

    public String getHelp() {
        String out = "";
        for (Parameter param : this.getParams()) {
            out = out + param.getHelp() + "\n";
        }
        return out;
    }

    public boolean isSuccess() {
        return this.result.success();
    }

    public List<Parameter> getParams() {
        return this.params;
    }

    public JSAPResult getResult() {
        return this.result;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public AbstractClient(String[] args) throws JSAPException {
        this.args = args;
        this.addParams();
        String[] segs = this.getClass().getName().split("\\.");
        this.commandName = segs[segs.length - 1];
        this.result = this.jsap.parse(args);
        if (this.requiresAtLeastOneArg() && args.length == 0) {
            this.result.addException("Must use at least one option", (Exception)new RuntimeException("Must use at least one option"));
        }
    }
}

