/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seismogramDC;

import edu.iris.Fissures.AuditElement;
import edu.iris.Fissures.AuditInfo;
import edu.iris.Fissures.Error;
import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfParameterMgr.ParameterRef;
import edu.iris.Fissures.IfSeismogramDC.Property;
import edu.iris.Fissures.IfSeismogramDC.SeismogramAttr;
import edu.iris.Fissures.IfTimeSeries.EncodedData;
import edu.iris.Fissures.IfTimeSeries.SequenceOutOfOrder;
import edu.iris.Fissures.IfTimeSeries.TimeSeriesDataSel;
import edu.iris.Fissures.IfTimeSeries.TimeSeriesType;
import edu.iris.Fissures.NotImplemented;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.ExceptionFactory;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitRangeImpl;
import edu.iris.Fissures.seismogramDC.DataAppend;
import edu.iris.Fissures.seismogramDC.SeismogramAttrImpl;
import edu.iris.dmc.seedcodec.Codec;
import edu.iris.dmc.seedcodec.CodecException;
import edu.iris.dmc.seedcodec.DecompressedData;
import edu.iris.dmc.seedcodec.UnsupportedCompressionType;
import java.io.Serializable;
import org.omg.CORBA.NO_IMPLEMENT;

public class LocalSeismogramImpl
extends SeismogramAttrImpl {
    protected transient DecompressedData decomp = null;
    protected static transient Codec codec = new Codec();

    protected LocalSeismogramImpl() {
    }

    public static Serializable createEmpty() {
        return new LocalSeismogramImpl();
    }

    public LocalSeismogramImpl(String id, Time begin_time, int num_points, Sampling sampling, Unit y_unit, ChannelId channel_id, TimeSeriesDataSel data) {
        this(id, new Property[0], begin_time, num_points, sampling, y_unit, channel_id, new ParameterRef[0], new Quantity[0], new Sampling[0], data);
    }

    public LocalSeismogramImpl(String id, Time begin_time, int num_points, Sampling sampling, Unit y_unit, ChannelId channel_id, int[] data) {
        this(id, new Property[0], begin_time, num_points, sampling, y_unit, channel_id, new ParameterRef[0], new Quantity[0], new Sampling[0], new TimeSeriesDataSel());
        this.data.int_values(data);
    }

    public LocalSeismogramImpl(String id, Time begin_time, int num_points, Sampling sampling, Unit y_unit, ChannelId channel_id, float[] data) {
        this(id, new Property[0], begin_time, num_points, sampling, y_unit, channel_id, new ParameterRef[0], new Quantity[0], new Sampling[0], new TimeSeriesDataSel());
        this.data.flt_values(data);
    }

    public LocalSeismogramImpl(String id, Time begin_time, int num_points, Sampling sampling, Unit y_unit, ChannelId channel_id, double[] data) {
        this(id, new Property[0], begin_time, num_points, sampling, y_unit, channel_id, new ParameterRef[0], new Quantity[0], new Sampling[0], new TimeSeriesDataSel());
        this.data.dbl_values(data);
    }

    public LocalSeismogramImpl(String id, Time begin_time, int num_points, Sampling sampling, Unit y_unit, ChannelId channel_id, short[] data) {
        this(id, new Property[0], begin_time, num_points, sampling, y_unit, channel_id, new ParameterRef[0], new Quantity[0], new Sampling[0], new TimeSeriesDataSel());
        this.data.sht_values(data);
    }

    public LocalSeismogramImpl(String id, Property[] properties, Time begin_time, int num_points, Sampling sampling, Unit y_unit, ChannelId channel_id, ParameterRef[] parm_ids, Quantity[] time_corrections, Sampling[] sample_rate_history, TimeSeriesDataSel data) {
        super(id, properties, begin_time, num_points, sampling, y_unit, channel_id, parm_ids, time_corrections, sample_rate_history);
        if (data == null) {
            this.num_points = 0;
        }
        if (y_unit == null) {
            throw new IllegalArgumentException("y_unit must not be null");
        }
        this.data = data;
    }

    public LocalSeismogramImpl(String id, Property[] properties, Time begin_time, int num_points, Sampling sampling, Unit y_unit, ChannelId channel_id, ParameterRef[] parm_ids, Quantity[] time_corrections, Sampling[] sample_rate_history, short[] data) {
        this(id, properties, begin_time, data.length, sampling, y_unit, channel_id, parm_ids, time_corrections, sample_rate_history, new TimeSeriesDataSel());
        this.data.sht_values(data);
    }

    public LocalSeismogramImpl(String id, Property[] properties, Time begin_time, int num_points, Sampling sampling, Unit y_unit, ChannelId channel_id, ParameterRef[] parm_ids, Quantity[] time_corrections, Sampling[] sample_rate_history, int[] data) {
        this(id, properties, begin_time, data.length, sampling, y_unit, channel_id, parm_ids, time_corrections, sample_rate_history, new TimeSeriesDataSel());
        this.data.int_values(data);
    }

    public LocalSeismogramImpl(String id, Property[] properties, Time begin_time, int num_points, Sampling sampling, Unit y_unit, ChannelId channel_id, ParameterRef[] parm_ids, Quantity[] time_corrections, Sampling[] sample_rate_history, float[] data) {
        this(id, properties, begin_time, data.length, sampling, y_unit, channel_id, parm_ids, time_corrections, sample_rate_history, new TimeSeriesDataSel());
        this.data.flt_values(data);
    }

    public LocalSeismogramImpl(String id, Property[] properties, Time begin_time, int num_points, Sampling sampling, Unit y_unit, ChannelId channel_id, ParameterRef[] parm_ids, Quantity[] time_corrections, Sampling[] sample_rate_history, double[] data) {
        this(id, properties, begin_time, data.length, sampling, y_unit, channel_id, parm_ids, time_corrections, sample_rate_history, new TimeSeriesDataSel());
        this.data.dbl_values(data);
    }

    public LocalSeismogramImpl(SeismogramAttr attr, short[] data) {
        this(attr, new TimeSeriesDataSel());
        this.data.sht_values(data);
        this.num_points = data.length;
    }

    public LocalSeismogramImpl(SeismogramAttr attr, int[] data) {
        this(attr, new TimeSeriesDataSel());
        this.data.int_values(data);
        this.num_points = data.length;
    }

    public LocalSeismogramImpl(SeismogramAttr attr, float[] data) {
        this(attr, new TimeSeriesDataSel());
        this.data.flt_values(data);
        this.num_points = data.length;
    }

    public LocalSeismogramImpl(SeismogramAttr attr, double[] data) {
        this(attr, new TimeSeriesDataSel());
        this.data.dbl_values(data);
        this.num_points = data.length;
    }

    public LocalSeismogramImpl(SeismogramAttr attr, TimeSeriesDataSel data) {
        this(attr.get_id(), attr.properties, attr.begin_time, attr.num_points, attr.sampling_info, attr.y_unit, attr.channel_id, attr.parm_ids, attr.time_corrections, attr.sample_rate_history, data);
    }

    public void setAttributes(SeismogramAttr attr) {
        this.begin_time = attr.begin_time;
        this.num_points = attr.num_points;
        this.sampling_info = attr.sampling_info;
        this.y_unit = attr.y_unit;
        this.channel_id = attr.channel_id;
        this.parm_ids = attr.parm_ids;
        this.time_corrections = attr.time_corrections;
        this.sample_rate_history = attr.sample_rate_history;
        this.setProperties(attr.properties);
    }

    public void setData(TimeSeriesDataSel data) {
        this.data = data;
        this.dataChanged();
    }

    public void setData(short[] data) {
        TimeSeriesDataSel d = new TimeSeriesDataSel();
        d.sht_values(data);
        this.setData(d);
    }

    public void setData(int[] data) {
        TimeSeriesDataSel d = new TimeSeriesDataSel();
        d.int_values(data);
        this.setData(d);
    }

    public void setData(float[] data) {
        TimeSeriesDataSel d = new TimeSeriesDataSel();
        d.flt_values(data);
        this.setData(d);
    }

    public void setData(double[] data) {
        TimeSeriesDataSel d = new TimeSeriesDataSel();
        d.dbl_values(data);
        this.setData(d);
    }

    public void setData(EncodedData[] data) {
        TimeSeriesDataSel d = new TimeSeriesDataSel();
        d.encoded_values(data);
        this.setData(d);
    }

    public int getNumPoints() {
        return this.num_points;
    }

    public QuantityImpl getMinValue() throws CodecException {
        return this.getMinValue(0, this.getNumPoints());
    }

    public QuantityImpl getMinValue(int startIndex, int endIndex) throws CodecException {
        double min;
        block9: {
            block11: {
                block10: {
                    block8: {
                        if (startIndex < 0) {
                            throw new IllegalArgumentException("Can't calculate min value for start index < 0, " + startIndex);
                        }
                        if (endIndex > this.getNumPoints()) {
                            throw new IllegalArgumentException("Can't calculate min value for end index > numPoints, " + endIndex + ", numPoints = " + this.getNumPoints());
                        }
                        if (startIndex >= endIndex) {
                            throw new IllegalArgumentException("Can't calculate min value for start index >= end index,  start index = " + startIndex + " endIndex = " + endIndex);
                        }
                        if (this.decomp == null) {
                            this.decodeBits();
                        }
                        min = 3.4028234663852886E38;
                        if (this.decomp.getType() != 3) break block8;
                        int[] iData = this.decomp.getAsInt();
                        for (int i = startIndex; i < iData.length && i < endIndex; ++i) {
                            if (!((double)iData[i] < min)) continue;
                            min = iData[i];
                        }
                        break block9;
                    }
                    if (this.decomp.getType() != 1) break block10;
                    short[] iData = this.decomp.getAsShort();
                    for (int i = startIndex; i < iData.length && i < endIndex; ++i) {
                        if (!((double)iData[i] < min)) continue;
                        min = iData[i];
                    }
                    break block9;
                }
                if (this.decomp.getType() != 4) break block11;
                float[] iData = this.decomp.getAsFloat();
                for (int i = startIndex; i < iData.length && i < endIndex; ++i) {
                    if (!((double)iData[i] < min)) continue;
                    min = iData[i];
                }
                break block9;
            }
            if (this.decomp.getType() != 5) break block9;
            double[] iData = this.decomp.getAsDouble();
            for (int i = startIndex; i < iData.length && i < endIndex; ++i) {
                if (!(iData[i] < min)) continue;
                min = iData[i];
            }
        }
        return new QuantityImpl(min, this.getUnit());
    }

    public QuantityImpl getMaxValue() throws CodecException {
        return this.getMaxValue(0, this.getNumPoints());
    }

    public QuantityImpl getMaxValue(int startIndex, int endIndex) throws CodecException {
        double max;
        block9: {
            block11: {
                block10: {
                    block8: {
                        if (startIndex < 0) {
                            throw new IllegalArgumentException("Can't calculate max value for start index < 0, " + startIndex);
                        }
                        if (endIndex > this.getNumPoints()) {
                            throw new IllegalArgumentException("Can't calculate max value for end index > numPoints, " + endIndex + ", numPoints = " + this.getNumPoints());
                        }
                        if (startIndex >= endIndex) {
                            throw new IllegalArgumentException("Can't calculate max value for start index >= end index,  start index = " + startIndex + " endIndex = " + endIndex);
                        }
                        if (this.decomp == null) {
                            this.decodeBits();
                        }
                        max = -3.4028234663852886E38;
                        if (this.decomp.getType() != 3) break block8;
                        int[] iData = this.decomp.getAsInt();
                        for (int i = startIndex; i < iData.length && i < endIndex; ++i) {
                            if (!((double)iData[i] > max)) continue;
                            max = iData[i];
                        }
                        break block9;
                    }
                    if (this.decomp.getType() != 1) break block10;
                    short[] iData = this.decomp.getAsShort();
                    for (int i = startIndex; i < iData.length && i < endIndex; ++i) {
                        if (!((double)iData[i] > max)) continue;
                        max = iData[i];
                    }
                    break block9;
                }
                if (this.decomp.getType() != 4) break block11;
                float[] iData = this.decomp.getAsFloat();
                for (int i = startIndex; i < iData.length && i < endIndex; ++i) {
                    if (!((double)iData[i] > max)) continue;
                    max = iData[i];
                }
                break block9;
            }
            if (this.decomp.getType() != 5) break block9;
            double[] iData = this.decomp.getAsDouble();
            for (int i = startIndex; i < iData.length && i < endIndex; ++i) {
                if (!(iData[i] > max)) continue;
                max = iData[i];
            }
        }
        return new QuantityImpl(max, this.getUnit());
    }

    public QuantityImpl getMeanValue() throws CodecException {
        return this.getMeanValue(0, this.getNumPoints());
    }

    public QuantityImpl getMeanValue(int startIndex, int endIndex) throws CodecException {
        block9: {
            block11: {
                block10: {
                    block8: {
                        if (startIndex < 0) {
                            throw new IllegalArgumentException("Can't calculate mean value for start index < 0, " + startIndex);
                        }
                        if (endIndex > this.getNumPoints()) {
                            throw new IllegalArgumentException("Can't calculate mean value for end index > numPoints, " + endIndex + ", numPoints = " + this.getNumPoints());
                        }
                        if (startIndex >= endIndex) {
                            throw new IllegalArgumentException("Can't calculate mean value for start index >= end index,  start index = " + startIndex + " endIndex = " + endIndex);
                        }
                        if (this.decomp == null) {
                            this.decodeBits();
                        }
                        double mean = 0.0;
                        if (this.decomp.getType() != 3) break block8;
                        int[] iData = this.decomp.getAsInt();
                        for (int i = startIndex; i < iData.length && i < endIndex; ++i) {
                            mean += (double)iData[i];
                        }
                        break block9;
                    }
                    if (this.decomp.getType() != 1) break block10;
                    short[] iData = this.decomp.getAsShort();
                    for (int i = startIndex; i < iData.length && i < endIndex; ++i) {
                        mean += (double)iData[i];
                    }
                    break block9;
                }
                if (this.decomp.getType() != 4) break block11;
                float[] iData = this.decomp.getAsFloat();
                for (int i = startIndex; i < iData.length && i < endIndex; ++i) {
                    mean += (double)iData[i];
                }
                break block9;
            }
            if (this.decomp.getType() != 5) break block9;
            double[] iData = this.decomp.getAsDouble();
            for (int i = startIndex; i < iData.length && i < endIndex; ++i) {
                mean += iData[i];
            }
        }
        return new QuantityImpl(mean /= (double)(endIndex - startIndex), this.getUnit());
    }

    public QuantityImpl getValueAt(int index) throws CodecException {
        if (this.decomp == null) {
            this.decodeBits();
        }
        if (this.decomp.getType() == 1) {
            return new QuantityImpl(this.decomp.getAsShort()[index], this.getUnit());
        }
        if (this.decomp.getType() == 3) {
            return new QuantityImpl(this.decomp.getAsInt()[index], this.getUnit());
        }
        if (this.decomp.getType() == 4) {
            return new QuantityImpl(this.decomp.getAsFloat()[index], this.getUnit());
        }
        return new QuantityImpl(this.decomp.getAsDouble()[index], this.getUnit());
    }

    public UnitRangeImpl getAmplitudeRange(int beginIndex, int endIndex) throws CodecException {
        QuantityImpl min = this.getMinValue(beginIndex, endIndex);
        QuantityImpl max = this.getMaxValue(beginIndex, endIndex);
        return new UnitRangeImpl(min.getValue(), max.getValue(), min.getUnit());
    }

    public UnitRangeImpl getAmplitudeRange() throws CodecException {
        QuantityImpl min = this.getMinValue();
        QuantityImpl max = this.getMaxValue();
        return new UnitRangeImpl(min.getValue(), max.getValue(), min.getUnit());
    }

    public boolean is_long() {
        TimeSeriesType discrim = this.data.discriminator();
        return discrim.equals(TimeSeriesType.TYPE_LONG);
    }

    public boolean is_float() {
        TimeSeriesType discrim = this.data.discriminator();
        return discrim.equals(TimeSeriesType.TYPE_FLOAT);
    }

    public boolean is_double() {
        TimeSeriesType discrim = this.data.discriminator();
        return discrim.equals(TimeSeriesType.TYPE_DOUBLE);
    }

    public boolean is_short() {
        TimeSeriesType discrim = this.data.discriminator();
        return discrim.equals(TimeSeriesType.TYPE_SHORT);
    }

    public boolean is_encoded() {
        TimeSeriesType discrim = this.data.discriminator();
        return discrim.equals(TimeSeriesType.TYPE_ENCODED);
    }

    public boolean can_convert_to_long() {
        TimeSeriesType discrim;
        block7: {
            discrim = this.data.discriminator();
            if (discrim.equals(TimeSeriesType.TYPE_LONG) || discrim.equals(TimeSeriesType.TYPE_SHORT)) {
                return true;
            }
            if (discrim.equals(TimeSeriesType.TYPE_FLOAT) || discrim.equals(TimeSeriesType.TYPE_DOUBLE)) {
                return false;
            }
            if (!discrim.equals(TimeSeriesType.TYPE_ENCODED)) break block7;
            try {
                block9: {
                    block8: {
                        EncodedData[] ebb = this.data.encoded_values();
                        if (codec.getDecompressedType(ebb[0].compression) == 3) break block8;
                        if (codec.getDecompressedType(ebb[0].compression) != 1) break block9;
                    }
                    return true;
                }
                return false;
            }
            catch (UnsupportedCompressionType e) {
                return false;
            }
        }
        throw new RuntimeException("Can't happen!!! Unknown encoding format: " + discrim.value());
    }

    public boolean can_convert_to_float() {
        TimeSeriesType discrim;
        block7: {
            discrim = this.data.discriminator();
            if (discrim.equals(TimeSeriesType.TYPE_DOUBLE)) {
                return false;
            }
            if (discrim.equals(TimeSeriesType.TYPE_SHORT) || discrim.equals(TimeSeriesType.TYPE_LONG) || discrim.equals(TimeSeriesType.TYPE_FLOAT)) {
                return true;
            }
            if (!discrim.equals(TimeSeriesType.TYPE_ENCODED)) break block7;
            EncodedData[] ebb = this.data.encoded_values();
            try {
                block9: {
                    block8: {
                        if (codec.getDecompressedType(ebb[0].compression) == 3) break block8;
                        if (codec.getDecompressedType(ebb[0].compression) == 1) break block8;
                        if (codec.getDecompressedType(ebb[0].compression) != 4) break block9;
                    }
                    return true;
                }
                return false;
            }
            catch (UnsupportedCompressionType e) {
                return false;
            }
        }
        throw new RuntimeException("Can't happen!!! Unknown encoding format: " + discrim.value());
    }

    public boolean can_convert_to_double() {
        return true;
    }

    public boolean can_convert_to_short() {
        TimeSeriesType discrim = this.data.discriminator();
        if (discrim.equals(TimeSeriesType.TYPE_SHORT)) {
            return true;
        }
        if (discrim.equals(TimeSeriesType.TYPE_LONG) || discrim.equals(TimeSeriesType.TYPE_FLOAT) || discrim.equals(TimeSeriesType.TYPE_DOUBLE)) {
            return false;
        }
        if (discrim.equals(TimeSeriesType.TYPE_ENCODED)) {
            try {
                EncodedData[] ebb = this.data.encoded_values();
                return codec.getDecompressedType(ebb[0].compression) == 1;
            }
            catch (UnsupportedCompressionType e) {
                return false;
            }
        }
        throw new RuntimeException("Can't happen!!! Unknown encoding format: " + discrim.value());
    }

    public TimeSeriesDataSel getData() {
        return this.data;
    }

    protected FissuresException makeFissuresException(CodecException e) {
        FissuresException ee = this.makeFissuresException("Codec Exception: " + e.getMessage());
        ee.initCause(e);
        return ee;
    }

    protected FissuresException makeFissuresException(String e) {
        Error error = new Error();
        error.error_code = 0;
        error.error_description = e;
        return new FissuresException(e, error);
    }

    public int[] get_as_longs() throws FissuresException {
        int[] out;
        if (this.decomp == null) {
            try {
                this.decodeBits();
            }
            catch (CodecException e) {
                throw this.makeFissuresException(e);
            }
        }
        if ((out = this.decomp.getAsInt()) == null) {
            throw this.makeFissuresException("Can't convert to int " + this.decomp.getTypeString());
        }
        return out;
    }

    public short[] get_as_shorts() throws FissuresException {
        short[] out;
        if (this.decomp == null) {
            try {
                this.decodeBits();
            }
            catch (CodecException e) {
                throw this.makeFissuresException(e);
            }
        }
        if ((out = this.decomp.getAsShort()) == null) {
            throw this.makeFissuresException("Can't convert to short " + this.decomp.getTypeString());
        }
        return out;
    }

    public float[] get_as_floats() throws FissuresException {
        float[] out;
        if (this.decomp == null) {
            try {
                this.decodeBits();
            }
            catch (CodecException e) {
                throw this.makeFissuresException(e);
            }
        }
        if ((out = this.decomp.getAsFloat()) == null) {
            throw this.makeFissuresException("Can't convert to float " + this.decomp.getTypeString());
        }
        return out;
    }

    public double[] get_as_doubles() throws FissuresException {
        double[] out;
        if (this.decomp == null) {
            try {
                this.decodeBits();
            }
            catch (CodecException e) {
                throw this.makeFissuresException(e);
            }
        }
        if ((out = this.decomp.getAsDouble()) == null) {
            throw this.makeFissuresException("Can't convert to double " + this.decomp.getTypeString());
        }
        return out;
    }

    public EncodedData[] get_as_encoded() throws FissuresException {
        if (this.is_encoded()) {
            return this.data.encoded_values();
        }
        throw this.makeFissuresException("data is not encoded");
    }

    public void close() {
        throw new NO_IMPLEMENT("not a remote Seismogram");
    }

    public AuditElement[] get_audit_trail() throws NotImplemented {
        throw new NO_IMPLEMENT("not a remote Seismogram");
    }

    public void append_longs(int seq_num, int[] data, AuditInfo[] audit_info) throws SequenceOutOfOrder {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public void append_shorts(int seq_num, short[] data, AuditInfo[] audit_info) throws SequenceOutOfOrder {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public void append_floats(int seq_num, float[] data, AuditInfo[] audit_info) throws SequenceOutOfOrder {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public void append_doubles(int seq_num, double[] data, AuditInfo[] audit_info) throws SequenceOutOfOrder {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public void append_encoded_seq(int seq_num, EncodedData[] data, AuditInfo[] audit_info) throws SequenceOutOfOrder {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public void append_encoded(int seq_num, EncodedData data, AuditInfo[] audit_info) throws SequenceOutOfOrder {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public void append_longs(int[] newData) throws FissuresException {
        if (this.getData() == null) {
            TimeSeriesDataSel tsds = new TimeSeriesDataSel();
            tsds.int_values(newData);
            this.setData(tsds);
        } else {
            DataAppend.append(this.getData(), newData);
        }
        this.dataChanged();
    }

    public void append_shorts(short[] newData) throws FissuresException {
        if (this.getData() == null) {
            TimeSeriesDataSel tsds = new TimeSeriesDataSel();
            tsds.sht_values(newData);
            this.setData(tsds);
        } else {
            DataAppend.append(this.getData(), newData);
        }
        this.dataChanged();
    }

    public void append_floats(float[] newData) throws FissuresException {
        if (this.getData() == null) {
            TimeSeriesDataSel tsds = new TimeSeriesDataSel();
            tsds.flt_values(newData);
            this.setData(tsds);
        } else {
            DataAppend.append(this.getData(), newData);
        }
        this.dataChanged();
    }

    public void append_doubles(double[] newData) throws FissuresException {
        if (this.getData() == null) {
            TimeSeriesDataSel tsds = new TimeSeriesDataSel();
            tsds.dbl_values(newData);
            this.setData(tsds);
        } else {
            DataAppend.append(this.getData(), newData);
        }
        this.dataChanged();
    }

    public void append_encoded_seq(EncodedData[] newData) throws FissuresException {
        if (this.getData() == null) {
            TimeSeriesDataSel tsds = new TimeSeriesDataSel();
            tsds.encoded_values(newData);
            this.setData(tsds);
        } else {
            DataAppend.append(this.getData(), newData);
        }
        this.dataChanged();
    }

    public void append_encoded(EncodedData newData) throws FissuresException {
        EncodedData[] temp = new EncodedData[]{newData};
        this.append_encoded_seq(temp);
    }

    public int calculateNumPoints() {
        switch (this.data.discriminator().value()) {
            case 0: {
                return this.data.sht_values().length;
            }
            case 1: {
                return this.data.int_values().length;
            }
            case 2: {
                return this.data.flt_values().length;
            }
            case 3: {
                return this.data.dbl_values().length;
            }
            case 4: {
                int num = 0;
                EncodedData[] temp = this.data.encoded_values();
                for (int i = 0; i < temp.length; ++i) {
                    num += temp[i].num_points;
                }
                return num;
            }
        }
        throw new RuntimeException("getNumPoints default");
    }

    public float[] getValues(int start, int length) throws CodecException {
        if (this.decomp == null) {
            this.decodeBits();
        }
        float[] out = new float[length];
        System.arraycopy(this.decomp.getAsFloat(), start, out, 0, length);
        return out;
    }

    public TimeSeriesType getDataType() {
        return this.data.discriminator();
    }

    public void append(TimeSeriesDataSel b) throws FissuresException {
        switch (b.discriminator().value()) {
            case 0: {
                this.append_shorts(b.sht_values());
                break;
            }
            case 1: {
                this.append_longs(b.int_values());
                break;
            }
            case 2: {
                this.append_floats(b.flt_values());
                break;
            }
            case 3: {
                this.append_doubles(b.dbl_values());
                break;
            }
            case 4: {
                this.append_encoded_seq(b.encoded_values());
                break;
            }
            default: {
                throw ExceptionFactory.ILLEGAL_CONVERSION("Unknown data type.", "Unknown data type." + b.discriminator().value());
            }
        }
        this.dataChanged();
    }

    public boolean isDataDecodable() {
        try {
            if (this.decomp == null) {
                this.decodeBits();
            }
            return true;
        }
        catch (CodecException e) {
            return false;
        }
    }

    public void dataChanged() {
        this.decomp = null;
        this.num_points = this.calculateNumPoints();
    }

    protected void decodeBits() throws CodecException {
        if (this.data.discriminator().equals(TimeSeriesType.TYPE_LONG)) {
            this.decomp = new DecompressedData(this.data.int_values());
        } else if (this.data.discriminator().equals(TimeSeriesType.TYPE_SHORT)) {
            this.decomp = new DecompressedData(this.data.sht_values());
        } else if (this.data.discriminator().equals(TimeSeriesType.TYPE_FLOAT)) {
            this.decomp = new DecompressedData(this.data.flt_values());
        } else if (this.data.discriminator().equals(TimeSeriesType.TYPE_DOUBLE)) {
            this.decomp = new DecompressedData(this.data.dbl_values());
        } else if (this.data.discriminator().equals(TimeSeriesType.TYPE_ENCODED)) {
            EncodedData[] eData = this.data.encoded_values();
            DecompressedData[] decompBuffer = new DecompressedData[eData.length];
            for (int i = 0; i < eData.length; ++i) {
                decompBuffer[i] = codec.decompress(eData[i].compression, eData[i].values, eData[i].num_points, eData[i].byte_order);
            }
            int type = -1;
            for (int i = 0; i < decompBuffer.length; ++i) {
                if (decompBuffer[i].getType() <= type) continue;
                type = decompBuffer[i].getType();
            }
            int numSoFar = 0;
            switch (type) {
                case 1: {
                    short[] buffer = new short[this.getNumPoints()];
                    for (int i = 0; i < decompBuffer.length; ++i) {
                        short[] temp = decompBuffer[i].getAsShort();
                        System.arraycopy(temp, 0, buffer, numSoFar, temp.length);
                        numSoFar += temp.length;
                    }
                    this.decomp = new DecompressedData(buffer);
                    break;
                }
                case 3: {
                    int[] ibuffer = new int[this.getNumPoints()];
                    for (int i = 0; i < decompBuffer.length; ++i) {
                        int[] temp = decompBuffer[i].getAsInt();
                        System.arraycopy(temp, 0, ibuffer, numSoFar, temp.length);
                        numSoFar += temp.length;
                    }
                    this.decomp = new DecompressedData(ibuffer);
                    break;
                }
                case 4: {
                    float[] fbuffer = new float[this.getNumPoints()];
                    for (int i = 0; i < decompBuffer.length; ++i) {
                        float[] temp = decompBuffer[i].getAsFloat();
                        System.arraycopy(temp, 0, fbuffer, numSoFar, temp.length);
                        numSoFar += temp.length;
                    }
                    this.decomp = new DecompressedData(fbuffer);
                    break;
                }
                case 5: {
                    double[] dbuffer = new double[this.getNumPoints()];
                    for (int i = 0; i < decompBuffer.length; ++i) {
                        double[] temp = decompBuffer[i].getAsDouble();
                        System.arraycopy(temp, 0, dbuffer, numSoFar, temp.length);
                        numSoFar += temp.length;
                    }
                    this.decomp = new DecompressedData(dbuffer);
                    break;
                }
                default: {
                    System.err.println("decompressed primitive type " + type + " is not known");
                }
            }
        }
    }
}

