/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.server;

import gov.usgs.net.NetTools;
import gov.usgs.util.CodeTimer;
import gov.usgs.vdx.ExportConfig;
import gov.usgs.vdx.data.DataSource;
import gov.usgs.vdx.data.DataSourceDescriptor;
import gov.usgs.vdx.data.DataSourceHandler;
import gov.usgs.vdx.server.BaseCommand;
import gov.usgs.vdx.server.RequestResult;
import gov.usgs.vdx.server.ServerHandler;
import gov.usgs.vdx.server.TextResult;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.logging.Level;

public class GetDataCommand
extends BaseCommand {
    public GetDataCommand(ServerHandler sh, NetTools nt) {
        super(sh, nt);
    }

    @Override
    public void doCommand(Object info, SocketChannel channel) {
        RequestResult result;
        String resultType;
        CodeTimer ct = new CodeTimer("send");
        this.parseParams((String)info);
        String source = (String)this.inParams.get("source");
        if (source == null) {
            this.sendError("source not specified", "getdata", channel);
            return;
        }
        DataSourceHandler dsh = this.handler.getDataSourceHandler();
        String action = (String)this.inParams.get("action");
        if (action != null && action.equals("exportinfo")) {
            ExportConfig ec = dsh.getExportConfig(source);
            resultType = action;
            if (ec == null || !ec.isClosed()) {
                int ncl = Integer.parseInt((String)this.inParams.get("numCommentLines"));
                ArrayList<String> args = new ArrayList<String>(ncl + 4);
                args.add((String)this.inParams.get("exportable"));
                args.add((String)this.inParams.get("width.0"));
                args.add((String)this.inParams.get("width.1"));
                for (int i = 1; i <= ncl; ++i) {
                    args.add((String)this.inParams.get("cmt." + i));
                }
                ExportConfig new_ec = new ExportConfig(args);
                if (ec == null) {
                    ec = new_ec;
                    dsh.putExportConfig(source, ec);
                } else {
                    ec.underride(new_ec);
                }
                ec.setClosed();
            }
            result = new TextResult(ec.toStringList());
        } else {
            DataSourceDescriptor dsd = dsh.getDataSourceDescriptor((String)this.inParams.get("source"));
            DataSource ds = dsd.getDataSource();
            result = ds.getData(this.inParams);
            dsd.putDataSource();
            resultType = ds.getType();
        }
        if (result != null) {
            result.set("type", resultType);
            result.prepare();
            result.writeHeader(this.netTools, channel);
            result.writeBody(this.netTools, channel);
            ct.stop();
            this.handler.log(Level.FINE, String.format("%s (%1.2f ms): [%s]", this.inParams.get("source"), ct.getRunTimeMillis(), info), channel);
        } else {
            this.netTools.writeString("error: no data\n", channel);
            this.handler.log(Level.FINE, "[getdata] returned nothing", channel);
        }
    }
}

