/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in.conn;

import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import gov.usgs.vdx.in.conn.Connection;
import gov.usgs.vdx.in.conn.IPConnection;
import java.text.DecimalFormat;

public class FreewaveIPConnection
extends IPConnection
implements Connection {
    protected int callnumber;
    protected int repeater;
    private DecimalFormat radioNumberFormatter;

    public FreewaveIPConnection() {
    }

    public FreewaveIPConnection(String name) {
        super(name);
    }

    @Override
    public void initialize(ConfigFile params) throws Exception {
        super.initialize(params);
        this.callnumber = Util.stringToInt(params.getString("callnumber"));
        this.repeater = Util.stringToInt(params.getString("repeater"));
        this.radioNumberFormatter = new DecimalFormat("#######");
    }

    @Override
    public String toString() {
        String settings = super.toString();
        settings = settings + "callnumber:" + this.callnumber + "/";
        settings = settings + "repeater:" + this.repeater + "/";
        return settings;
    }

    @Override
    public void connect() throws Exception {
        super.connect();
        this.setRepeater(this.repeater);
        this.call(this.callnumber);
    }

    private void call(int radioNumber) throws Exception {
        String cmd = "ATD" + this.radioNumberFormatter.format(radioNumber);
        this.writeString(cmd);
        this.wait4OK(this.timeout);
        this.wait4Connect(this.timeout);
    }

    private void setRepeater(int repeater) throws Exception {
        String cmd = "ATXC" + (char)(48 + repeater);
        this.writeString(cmd);
        this.wait4OK(this.timeout);
    }

    private void wait4OK(int timeout) throws Exception {
        String msg = this.readString(timeout);
        if (0 != msg.indexOf("OK")) {
            throw new Exception("'OK' expected but '" + msg + "' received");
        }
        int idx = msg.indexOf("CONNECT");
        if (-1 != idx) {
            this.msgQueue.add(msg.substring(idx));
        }
    }

    private void wait4Connect(int timeout) throws Exception {
        String msg = this.readString(timeout);
        if (0 != msg.indexOf("CONNECT")) {
            throw new Exception("'CONNECT' expected but '" + msg + "' received");
        }
    }
}

