      SUBROUTINE HYFMC
C--CALLED FROM HYCMD TO INITIALLY READ FILE OF STATION DUR MAG CORRECTIONS AND
C  THEIR EXPIRATION DATES.
      INCLUDE 'common.inc'
      CHARACTER STN*5, SNET*2, SCOMP*3, SLOC*2
      DIMENSION FMC(6),IFEXP(6),ITEXP(6),IYEARI(6)
      KOUNT=0

      IF (JSTA.EQ.0) THEN
        WRITE (6,1001)
1001    FORMAT (' *** ERROR: YOU CANT READ FMAG CORRECTIONS BEFORE',
     2  ' READING THE STATION FILE')
        IRES=-37
        RETURN
      END IF

C--OPTIONALLY SET ALL WEIGHTS TO ZERO IF WE WANT TO USE ONLY STAS WITH
C  KNOWN CORRECTIONS
      IF (.NOT.LNOFMC) THEN
        DO J=1,JSTA
          JFWT(J)=0
        END DO
      END IF

C--OPEN THE STATION FMAG CORRECTION FILE
      CALL OPENR (13,FMCFIL,'F',IOS)
      IF (IOS.NE.0) GOTO 90

C--LOOP TO READ STATION FMAG CORRECTIONS
5     IF (L2000) THEN
        READ (13,1020,END=80) STN, SNET, SLOC, SCOMP,
     2  (FMC(I),IYEARI(I),ITEXP(I),I=1,6)
1020    FORMAT (A5,1X, A2,A2, A3,1X, 6(F5.2,1X,I4,I6,1X))

      ELSE
        READ (13,1000,END=80) STN, SNET, SCOMP,
     2  (FMC(I),IYEARI(I),ITEXP(I),I=1,6)
C--READ 2-DIGIT YEAR, MO, DA, HOUR, AND IGNORE MINUTES IF PRESENT
1000    FORMAT (A5,1X, A2,2X, A3,1X, 6(F5.2,1X,I2,I6,3X))
        SLOC='  '
      END IF

C--SEARCH STATION LIST IN MEMORY FOR A MATCH
      DO J=1,JSTA
        IF (STN(1:NSTLET) .EQ. STANAM(J)(1:NSTLET) .AND.
     2  SNET(1:NETLET) .EQ. JNET(J)(1:NETLET) .AND.
     3  (SLOC(1:NSLOC2) .EQ. JSLOC(J)(1:NSLOC2) .OR.
     3  SLOC(1:NSLOC2) .EQ. JSLOC2(J)(1:NSLOC2)) .AND.
     4  SCOMP(1:NCOMP) .EQ. JCOMP3(J)(1:NCOMP)) THEN

C--GIVE STATION FULL WEIGHT IF WEIGHT IS CONTINGENT ON BEING IN FILE
          IF (.NOT.LNOFMC) JFWT(J)=10

C--MAKE SURE IYEARI IS THE FULL 4-DIGIT YEAR
C--TRUNCATE YEAR TO 2146, THE LARGEST STORABLE IN I*4, STORE WHOLE STATE
          DO I=1,6
            IF (IYEARI(I).LT.100 .AND. IYEARI(I).GT.0) 
     2      IYEARI(I)=IYEARI(I)+ICENT
            IF (IYEARI(I).GT.2146) THEN
              WRITE (6,1200) STN, SNET, SCOMP, IYEARI(I)
1200          FORMAT ('*** FMC EXPIRATION YEAR TOO LARGE,',
     2        ' RESET TO 2146:'/1X,A5,1X,A2,1X,A3,1X,I4)
              IYEARI(I)=2146
            END IF
            IFEXP(I)=IYEARI(I)*1000000 +ITEXP(I)
          END DO

C--IF THE TARGET DATE IS 0, JUST TAKE THE FIRST CORRECTION & EXPIRATION DATE
          IF (IFDATE.EQ.0) THEN
            I=1
          ELSE
C--SEARCH FOR THE FIRST EXPIRATION DATE AFTER THE TARGET DATE
            DO I=1,6
              IF (IFEXP(I).EQ.0 .OR. IFEXP(I).GT.IFDATE) GOTO 10
            END DO
            IFEXP(6)=0
          END IF

C--STORE THE CORRECTION & ITS EXPIRATION DATE
10        JFEXP(J)=IFEXP(I)

C--ADD 10 TO CORRECTION TO GIVE GAIN CORRECTION 0 WEIGHT
C--YOU CAN ADD BOTH 10 AND 5, BUT MUST DO THIS TEST FIRST
          IF (FMC(I).GT.7.45) THEN
            JFGWT(J)=0
            FMC(I)=FMC(I)-10.
          ELSE
            JFGWT(J)=1
          END IF

C--ADD 5 TO CORRECTION TO GIVE IT ZERO WEIGHT
          IF (FMC(I).GT.2.45) THEN
            JFWT(J)=0
            FMC(I)=FMC(I)-5.
          ELSE
            JFWT(J)=10
          END IF

          JFCOR(J)=NINT(FMC(I)*100.)
          KOUNT=KOUNT+1
C          GOTO 5  !COMMENT OUT TO STORE DATA FOR ALL CHANNELS THAT APPLY
        END IF
      END DO
      GOTO 5

C--END OF FILE
80    CLOSE (13)
      WRITE (6,1002) KOUNT
1002  FORMAT (I6,' STATION FMAG CORRECTIONS SET')
      RETURN

C--ERROR FOR NON-EXISTENT FILE
90    WRITE (6,1010)
1010  FORMAT (' *** ERROR: STATION FMAG CORRECTION FILE DOES NOT EXIST')
      IRES=-38
      RETURN
      END
