package pickewanalysis;

import javax.swing.table.AbstractTableModel;
import pickewanalysis.ewpicker.PickEWStation;

public class StationParametersTableModel extends AbstractTableModel {
    //Variables

    private PickEWStation station;
    private String[] columnNames = new String[]{"Parameter", "Value"};
    private String[] parameterNames = new String[]{
        "Itr1", "MinSmallZC", "MinBigZC", "MinPeakSize", "MaxMint",
        "MinCodaLen", "RawDataFilt", "CharFuncFilt", "StaFilt",
        "LtaFilt", "EventThresh", "RmavFilt", "DeadSta", "CodaTerm", "AltCoda",
        "PreEvent", "Erefs", "ClipCount"
    };
    private PickEWAnalysis parent;

    public StationParametersTableModel(PickEWStation station, PickEWAnalysis parent) {
        this.station = station;
        this.parent = parent;
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return parameterNames.length;
    }

    public String getColumnName(int col) {
        return columnNames[col];
    }

    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return parameterNames[row];
        } else {
            if (station == null) {
                return null;
            }
            switch (row) {
                case 0:
                    return String.valueOf(station.Itr1);
                case 1:
                    return String.valueOf(station.MinSmallZC);
                case 2:
                    return String.valueOf(station.MinBigZC);
                case 3:
                    return String.valueOf(station.MinPeakSize);
                case 4:
                    return String.valueOf(station.MaxMint);
                case 5:
                    return String.valueOf(station.MinCodaLen);
                case 6:
                    return String.valueOf(station.RawDataFilt);
                case 7:
                    return String.valueOf(station.CharFuncFilt);
                case 8:
                    return String.valueOf(station.StaFilt);
                case 9:
                    return String.valueOf(station.LtaFilt);
                case 10:
                    return String.valueOf(station.EventThresh);
                case 11:
                    return String.valueOf(station.RmavFilt);
                case 12:
                    return String.valueOf(station.DeadSta);
                case 13:
                    return String.valueOf(station.CodaTerm);
                case 14:
                    return String.valueOf(station.AltCoda);
                case 15:
                    return String.valueOf(station.PreEvent);
                case 16:
                    return String.valueOf(station.Erefs);
                case 17:
                    return String.valueOf(station.ClipCount);
            }
        }
        return null;
    }

    public Class getColumnClass(int c) {
        return String.class;
    }

    public boolean isCellEditable(int row, int col) {
        if (col == 1) {
            return true;
        }
        return false;
    }

    public void setValueAt(Object value, int row, int col) {
        if (station==null) {
            return;
        }
        try {
            switch (row) {
                case 0:
                    station.Itr1 = Integer.valueOf((String) value);
                    break;
                case 1:
                    station.MinSmallZC = Integer.valueOf((String)value);
                    break;
                case 2:
                    station.MinBigZC = Integer.valueOf((String)value);
                    break;
                case 3:
                    station.MinPeakSize = Integer.valueOf((String)value);
                    break;
                case 4:
                    station.MaxMint = Integer.valueOf((String)value);
                    break;
                case 5:
                    station.MinCodaLen = Integer.valueOf((String)value);
                    break;
                case 6:
                    station.RawDataFilt = Double.valueOf((String)value);
                    break;
                case 7:
                    station.CharFuncFilt = Double.valueOf((String)value);
                    break;
                case 8:
                    station.StaFilt = Double.valueOf((String)value);
                    break;
                case 9:
                    station.LtaFilt = Double.valueOf((String)value);
                    break;
                case 10:
                    station.EventThresh = Double.valueOf((String)value);
                    break;
                case 11:
                    station.RmavFilt = Double.valueOf((String)value);
                    break;
                case 12:
                    station.DeadSta = Double.valueOf((String)value);
                    break;
                case 13:
                    station.CodaTerm = Double.valueOf((String)value);
                    break;
                case 14:
                    station.AltCoda = Double.valueOf((String)value);
                    break;
                case 15:
                    station.PreEvent = Double.valueOf((String)value);
                    break;
                case 16:
                    station.Erefs = Double.valueOf((String)value);
                    break;
                case 17:
                    station.ClipCount = Integer.valueOf((String)value);
                    break;
            }
            //Update traces
            parent.updateTracePanel();
        } catch (Exception e) {
            //Invalid input value
            return;
        }
    }
}
