/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.map;

import gov.usgs.plot.render.DataPointRenderer;
import gov.usgs.plot.render.PointRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;

public class GeoLabel {
    public String text;
    public Color color = Color.BLACK;
    public Font font = new Font("Arial", 0, 10);
    public boolean shadow = true;
    public Point2D.Double location;
    public PointRenderer marker;

    public GeoLabel() {
    }

    public GeoLabel(String s) {
        String[] ss = s.split("\t");
        this.text = ss[0];
        this.location = new Point2D.Double(Double.parseDouble(ss[1]), Double.parseDouble(ss[2]));
        this.marker = new DataPointRenderer('t', 6.0f);
        ((DataPointRenderer)this.marker).antiAlias = true;
        ((DataPointRenderer)this.marker).stroke = new BasicStroke(1.0f);
    }

    public GeoLabel(String s, double lon, double lat) {
        this.text = s;
        this.location = new Point2D.Double(lon, lat);
        this.marker = new DataPointRenderer('s', 3.0f);
        ((DataPointRenderer)this.marker).antiAlias = true;
    }

    public static GeoLabel fromString(String s) {
        char pType = 's';
        float pSize = 8.0f;
        Color pColor = Color.BLUE;
        float pStroke = 1.0f;
        Font font = new Font("Arial", 0, 10);
        Color fColor = Color.BLACK;
        GeoLabel gl = new GeoLabel();
        String[] ss = s.split(";");
        String[] options = ss[1].split(",");
        gl.text = ss[0];
        gl.location = new Point2D.Double(Double.parseDouble(options[0].trim()), Double.parseDouble(options[1].trim()));
        if (options.length > 2) {
            pType = options[2].trim().charAt(0);
        }
        if (options.length > 3) {
            pSize = Float.parseFloat(options[3].trim());
            try {
                pColor = (Color)Color.class.getDeclaredField(options[4].trim()).get(null);
                pStroke = Float.parseFloat(options[5].trim());
                font = new Font(options[6].trim(), Font.class.getDeclaredField(options[8].trim()).getInt(null), Integer.parseInt(options[7].trim()));
                fColor = (Color)Color.class.getDeclaredField(options[9].trim()).get(null);
            }
            catch (Exception e) {
                System.err.println("Can't parse geolable string for " + gl.text + " using defaults.");
            }
        }
        DataPointRenderer dr = new DataPointRenderer(pType, pSize);
        dr.color = pColor;
        dr.stroke = new BasicStroke(pStroke);
        dr.antiAlias = true;
        gl.font = font;
        gl.color = fColor;
        gl.shadow = false;
        gl.marker = dr;
        return gl;
    }
}

