/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.BlocketteUnknown;
import java.io.PrintWriter;

public class PartialBlockette
extends BlocketteUnknown {
    int totalBytes;
    int priorBytes;
    int bytesRead;

    public PartialBlockette(int type, byte[] info, boolean swapBytes, int priorBytes, int totalBytes) {
        super(info, type, swapBytes);
        this.bytesRead = info.length;
        this.priorBytes = priorBytes;
        this.totalBytes = totalBytes;
    }

    public static PartialBlockette combine(PartialBlockette first, PartialBlockette second) {
        byte[] tmp = new byte[first.getSize() + second.getSize()];
        System.arraycopy(first.toBytes(), 0, tmp, 0, first.getSize());
        System.arraycopy(second.toBytes(), 0, tmp, first.getSize(), second.getSize());
        return new PartialBlockette(first.getType(), tmp, first.swapBytes, first.getPriorSize(), first.getTotalSize());
    }

    @Override
    public void writeASCII(PrintWriter out) {
        String infoStr = new String(this.info);
        out.println("Partial Blockette " + this.getType() + ", " + this.bytesRead + " with " + this.priorBytes + " prior of " + this.totalBytes + " total bytes: " + infoStr);
    }

    public boolean isBegin() {
        return this.priorBytes == 0;
    }

    public boolean isEnd() {
        return this.priorBytes + this.bytesRead == this.totalBytes;
    }

    public int getTotalSize() {
        return this.totalBytes;
    }

    public int getPriorSize() {
        return this.priorBytes;
    }

    public int getSoFarSize() {
        return this.priorBytes + this.bytesRead;
    }

    public int getBytesRead() {
        return this.bytesRead;
    }
}

