package pickewanalysis.ewmessages;

public abstract class EWMessage {
    /* Module IDs */
    public static final int MOD_WILDCARD = 0;
    /* Instalation IDs */
    public static final int INST_UNKNOWN = 255;
    /* Message Types */
    public static final int TYPE_WILDCARD = 0; // wildcard value - DO NOT CHANGE!!!
    public static final int TYPE_ADBUF = 1; // multiplexed waveforms from DOS adsend
    public static final int TYPE_ERROR = 2; // error public static final int
    public static final int TYPE_HEARTBEAT = 3; // heartbeat public static final int
    public static final int TYPE_TRACE2_COMP_UA = 4; // compressed waveforms from compress_UA, with SCNL
    public static final int TYPE_ACK = 6; // acknowledgment sent by import to export
    public static final int TYPE_PICK_SCNL = 8; // P-wave arrival time (with location code)
    public static final int TYPE_CODA_SCNL = 9; // coda info (plus station/loc code) from pick_ew
    public static final int TYPE_PICK2K = 10; // P-wave arrival time (with 4 digit year)
    public static final int TYPE_CODA2K = 11; // coda info (plus station code) from pick_ew
    public static final int TYPE_HYP2000ARC = 14; // hyp2000 (Y2K hypoinverse) event archive
    public static final int TYPE_H71SUM2K = 15; // hypo71-format hypocenter summary msg
    public static final int TYPE_TRACEBUF2 = 19; // single-channel waveforms with channels
    public static final int TYPE_TRACEBUF = 20; // single-channel waveforms from NT adsend,
    public static final int TYPE_LPTRIG = 21; // single-channel long-period trigger from
    public static final int TYPE_CUBIC = 22; // cubic-format summary msg from cubic_msg
    public static final int TYPE_CARLSTATRIG = 23; // single-channel trigger from carlstatrig
    public static final int TYPE_TRIGLIST2K = 25; // trigger-list msg (with 4-digit year) used
    public static final int TYPE_TRACE_COMP_UA = 26; // compressed waveforms from compress_UA
    public static final int TYPE_MAGNITUDE = 28; // event magnitude: summary plus station info
    public static final int TYPE_STRONGMOTIONII = 29; // event strong motion parameters
    public static final int TYPE_LOC_GLOBAL = 30; // Global location public static final int used by NEIC & localmag
    public static final int TYPE_LPTRIG_SCNL = 31; // single-channel long-period trigger from
    public static final int TYPE_CARLSTATRIG_SCNL = 32; // single-channel trigger from carlstatrig (with loc)
    public static final int TYPE_TRIGLIST_SCNL = 33; // trigger-list msg (with 4-digit year) used
    public static final int TYPE_TD_AMP = 34; // time-domain reduced-rate amplitude summary
    //Abstract functions
    public abstract int getType();
}
