/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import gov.usgs.net.Server;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.util.Util;
import gov.usgs.winston.server.ServerHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;

public class WWS
extends Server {
    private static final String DEFAULT_CONFIG_FILENAME = "WWS.config";
    private static final String DEFAULT_LOG_FILE = "WWS.log";
    private static final int DEFAULT_LOG_NUM_FILES = 9;
    private static final int DEFAULT_LOG_FILE_SIZE = 0x100000;
    protected int handlers;
    protected String winstonDriver;
    protected String winstonURL;
    protected String winstonPrefix;
    protected int winstonStatementCacheCap;
    protected String configFilename = "WWS.config";
    protected String logFile;
    protected int logNumFiles;
    protected int logSize;
    protected int embargo = 0;
    protected int maxDays = 0;
    protected boolean allowHttp;
    protected long idleTime;
    protected int httpMaxSize;
    protected int httpRefreshInterval;
    protected int slowCommandTime;
    public static String JSAP_PROGRAM_NAME = "java gov.usgs.winston.in.ew.ImportWS";
    public static String JSAP_EXPLANATION_PREFACE = "Winston WWS\n\nI am the Winston wave server\n";
    private static final String DEFAULT_JSAP_EXPLANATION = "All output goes to standard error.\nThe command line takes precedence over the config file.\n";
    private static final Parameter[] DEFAULT_JSAP_PARAMETERS = new Parameter[]{new Switch("noInput", 'i', "noinput", "Do not poll keyboard for input."), new Switch("verbose", 'v', "verbose", "Verbose logging."), new UnflaggedOption("configFilename", (StringParser)JSAP.STRING_PARSER, "WWS.config", true, false, "The config file name.")};

    public WWS(String cf) {
        this.name = "WWS";
        this.logger = Log.getLogger("gov.usgs.winston");
        this.logger.info(WWS.getVersion());
        if (cf != null) {
            this.configFilename = cf;
        }
        this.processConfigFile();
        for (int i = 0; i < this.handlers; ++i) {
            this.addCommandHandler(new ServerHandler(this));
        }
    }

    public static String getVersion() {
        String[] v = Util.getVersion("gov.usgs.winston");
        String version = v != null ? "Version: " + v[0] + " Built: " + v[1] : "No version information available.";
        return version;
    }

    public void launch() {
        Thread launchThread = new Thread(new Runnable(){

            @Override
            public void run() {
                WWS.this.startListening();
            }
        });
        launchThread.start();
    }

    public int getEmbargo() {
        return this.embargo;
    }

    public String getWinstonDriver() {
        return this.winstonDriver;
    }

    public String getWinstonURL() {
        return this.winstonURL;
    }

    public String getWinstonPrefix() {
        return this.winstonPrefix;
    }

    public int getWinstonStatementCacheCap() {
        return this.winstonStatementCacheCap;
    }

    public boolean isHttpAllowed() {
        return this.allowHttp;
    }

    public int httpMaxSize() {
        return this.httpMaxSize;
    }

    public int maxDays() {
        return this.maxDays;
    }

    public int getSlowCommandTime() {
        return this.slowCommandTime;
    }

    public int httpRefreshInterval() {
        return this.httpRefreshInterval;
    }

    protected void fatalError(String msg) {
        this.logger.severe(msg);
        System.exit(1);
    }

    public void processConfigFile() {
        boolean k;
        int p;
        String a;
        ConfigFile cf = new ConfigFile(this.configFilename);
        if (!cf.wasSuccessfullyRead()) {
            this.fatalError(this.configFilename + ": could not read config file.");
        }
        if ((a = cf.getString("wws.addr")) != null) {
            try {
                this.serverIP = InetAddress.getByName(a);
            }
            catch (UnknownHostException e) {
                this.logger.info("unknown host " + a);
            }
            this.logger.info("config: wws.addr=" + this.serverIP.getCanonicalHostName() + ".");
        }
        if ((p = Util.stringToInt(cf.getString("wws.port"), -1)) < 0 || p > 65535) {
            this.fatalError(this.configFilename + ": bad or missing 'wws.port' setting.");
        }
        this.serverPort = p;
        this.logger.info("config: wws.port=" + this.serverPort + ".");
        this.keepalive = k = Util.stringToBoolean(cf.getString("wws.keepalive"), false);
        this.logger.info("config: wws.keepalive=" + this.keepalive + ".");
        int h = Util.stringToInt(cf.getString("wws.handlers"), -1);
        if (h < 1 || h > 128) {
            this.fatalError(this.configFilename + ": bad or missing 'wws.handlers' setting.");
        }
        this.handlers = h;
        this.logger.info("config: wws.handlers=" + this.handlers + ".");
        int m = Util.stringToInt(cf.getString("wws.maxConnections"), -1);
        if (m < 0) {
            this.fatalError(this.configFilename + ": bad or missing 'wws.maxConnections' setting.");
        }
        this.connections.setMaxConnections(m);
        this.logger.info("config: wws.maxConnections=" + this.connections.getMaxConnections() + ".");
        long i = 1000 * Util.stringToInt(cf.getString("wws.idleTime"), 7200);
        if (i < 0L) {
            this.fatalError(this.configFilename + ": bad or missing 'wws.idleTime' setting.");
        }
        this.idleTime = i;
        this.logger.info("config: wws.idleTime=" + this.idleTime / 1000L + ".");
        this.embargo = 0;
        this.maxDays = Util.stringToInt(cf.getString("wws.maxDays"), 0);
        this.logger.info("config: wws.maxDays=" + this.maxDays + ".");
        if (cf.getString("wws.allowHttp") == null) {
            this.fatalError(this.configFilename + ": missing 'wws.allowHttp' setting.");
        } else {
            this.allowHttp = Util.stringToBoolean(cf.getString("wws.allowHttp"));
        }
        this.logger.info("config: wws.allowHttp=" + this.allowHttp + ".");
        this.httpMaxSize = Util.stringToInt(cf.getString("wws.httpMaxSize"), 10000000);
        this.logger.info("config: wws.httpMaxSize=" + this.httpMaxSize + ".");
        this.slowCommandTime = Util.stringToInt(cf.getString("wws.slowCommandTime"), 1500);
        this.logger.info("config: wws.slowCommandTime=" + this.slowCommandTime + ".");
        this.httpRefreshInterval = Util.stringToInt(cf.getString("wws.httpRefreshInterval"), 0);
        this.logger.info("config: wws.httpRefreshInterval=" + this.httpRefreshInterval + ".");
        this.winstonDriver = cf.getString("winston.driver");
        this.winstonURL = cf.getString("winston.url");
        this.winstonPrefix = cf.getString("winston.prefix");
        this.winstonStatementCacheCap = Util.stringToInt(cf.getString("winston.statementCacheCap"), 100);
        this.logFile = Util.stringToString(cf.getString("log.name"), DEFAULT_LOG_FILE);
        this.logNumFiles = Util.stringToInt(cf.getString("log.numFiles"), 9);
        this.logSize = Util.stringToInt(cf.getString("log.maxSize"), 0x100000);
        if (this.logNumFiles > 0) {
            Log.attachFileLogger(this.logger, this.logFile, this.logSize, this.logNumFiles, true);
        }
    }

    public void setLogLevel(Level level) {
        Log.getLogger("gov.usgs").setLevel(level);
        this.logger.severe("Logging set to " + level);
    }

    public static JSAPResult getArguments(String[] args) {
        JSAPResult config = null;
        try {
            SimpleJSAP jsap = new SimpleJSAP(JSAP_PROGRAM_NAME, JSAP_EXPLANATION_PREFACE + DEFAULT_JSAP_EXPLANATION, DEFAULT_JSAP_PARAMETERS);
            config = jsap.parse(args);
            if (jsap.messagePrinted()) {
                if (!config.getBoolean("help")) {
                    System.err.println("Try using the --help flag.");
                }
                System.exit(1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        return config;
    }

    public static void printKeys() {
        StringBuffer sb = new StringBuffer();
        sb.append(WWS.getVersion() + "\n");
        sb.append("Keys:\n");
        sb.append(" 0-3: logging level\n");
        sb.append("        d: drop idle connections\n");
        sb.append("        q: quit\n");
        sb.append("        ?: display keys\n");
        sb.append("        m: print running commands\n");
        sb.append(" t<index>: toggle tracing of a connection\n");
        sb.append("        c: print connections sorted by bytes transmited\n");
        sb.append("       cA: print connections sorted by address\n");
        sb.append("       cC: print connections sorted by connect time\n");
        sb.append("       cL: print connections sorted by last request time\n");
        sb.append("       cR: print connections sorted by bytes received\n");
        sb.append("       cT: print connections sorted by bytes transmited\n");
        sb.append("       cI: print connections sorted by index\n");
        sb.append("         : append '-' to sort in descending order.\n");
        System.out.println(sb);
    }

    public static void main(String[] args) throws IOException {
        boolean acceptCommands;
        JSAPResult config = WWS.getArguments(args);
        WWS wws = new WWS(config.getString("configFilename"));
        if (config.getBoolean("verbose")) {
            wws.setLogLevel(Level.ALL);
        } else {
            wws.setLogLevel(Level.FINE);
        }
        wws.launch();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        boolean bl = acceptCommands = !config.getBoolean("noInput");
        if (acceptCommands) {
            wws.logger.info("Enter ? for console commands.");
        }
        while (acceptCommands) {
            String s = in.readLine();
            if (s == null) continue;
            if ((s = s.toLowerCase().trim()).equals("q")) {
                System.exit(0);
                continue;
            }
            if (s.startsWith("c")) {
                wws.printConnections(s);
                continue;
            }
            if (s.startsWith("m")) {
                wws.printCommands(s);
                continue;
            }
            if (s.equals("d")) {
                wws.dropConnections(wws.idleTime);
                continue;
            }
            if (s.startsWith("t")) {
                wws.toggleTrace(s);
                continue;
            }
            if (s.equals("0")) {
                wws.setLogLevel(Level.SEVERE);
                continue;
            }
            if (s.equals("1")) {
                wws.setLogLevel(Level.FINE);
                continue;
            }
            if (s.equals("2")) {
                wws.setLogLevel(Level.FINER);
                continue;
            }
            if (s.equals("3")) {
                wws.setLogLevel(Level.ALL);
                continue;
            }
            if (s.equals("?")) {
                WWS.printKeys();
                continue;
            }
            WWS.printKeys();
        }
    }

    public int getMaxDays() {
        return this.maxDays;
    }
}

