/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.in.ew;

import gov.usgs.earthworm.message.TraceBuf;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.winston.in.ew.Options;
import gov.usgs.winston.in.ew.TraceBufFilter;
import java.util.regex.Pattern;

public class SCNLFilter
extends TraceBufFilter {
    private String station;
    private String channel;
    private String network;
    private String location;

    public SCNLFilter() {
        this.station = "*";
        this.channel = "*";
        this.network = "*";
        this.location = "*";
    }

    public SCNLFilter(String scnl) {
        this.setFilter(scnl);
    }

    public SCNLFilter(String s, String c, String n, String l) {
        this.keepRejects = false;
        this.station = s;
        this.channel = c;
        this.network = n;
        this.location = l;
    }

    public void setFilter(String scnl) {
        String[] ss = scnl.split(" ");
        if (ss.length != 4) {
            Log.getLogger("gov.usgs.winston.in.ew").warning("SCNLFilter: scnl must have four space-separated fields.");
            return;
        }
        this.station = ss[0];
        this.channel = ss[1];
        this.network = ss[2];
        this.location = ss[3];
    }

    @Override
    public void configure(ConfigFile cf) {
        super.configure(cf);
        if (cf == null) {
            return;
        }
        String scnl = cf.getString("scnl");
        if (scnl == null) {
            return;
        }
        this.setFilter(scnl);
    }

    private boolean test(String crit, String val) {
        if (crit == null || crit.equals("*") || crit.equals(val)) {
            return true;
        }
        return Pattern.matches(crit, val);
    }

    @Override
    public boolean match(TraceBuf tb, Options options) {
        if (!this.test(this.station, tb.station())) {
            return false;
        }
        if (!this.test(this.channel, tb.channel())) {
            return false;
        }
        if (!this.test(this.network, tb.network())) {
            return false;
        }
        return this.test(this.location, tb.location());
    }

    public String toString() {
        return String.format("SCNLFilter [%s: %s %s %s %s]", this.accept ? "accept" : "reject", this.station, this.channel, this.network, this.location);
    }
}

