/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.db;

import gov.usgs.util.ConfigFile;
import gov.usgs.winston.Channel;
import gov.usgs.winston.db.Channels;
import gov.usgs.winston.db.Input;
import gov.usgs.winston.db.WinstonDatabase;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class Admin {
    public static final String WILDCARD = "%";
    private WinstonDatabase winston;
    private Channels channels;
    private Input input;

    public Admin(WinstonDatabase w) {
        this.winston = w;
        this.channels = new Channels(this.winston);
        this.input = new Input(this.winston);
    }

    public Admin(String driver, String url, String db) {
        this(new WinstonDatabase(driver, url, db));
    }

    public void calculateTableSpans() {
        try {
            List<Channel> st = this.channels.getChannels();
            Iterator<Channel> it = st.iterator();
            while (it.hasNext()) {
                String code = it.next().getCode();
                System.out.print(code + "...");
                this.input.calculateSpan(code);
                System.out.println("done.");
            }
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Error during calculateTableSpans().", e);
        }
    }

    public void listChannels(boolean times) {
        List<Channel> st = this.channels.getChannels();
        for (Channel ch : st) {
            String code = ch.getCode();
            System.out.print(code);
            if (times) {
                System.out.print("\t" + ch.getMinTime() + "\t" + ch.getMaxTime());
            }
            System.out.println();
        }
    }

    private void doDeleteChannel(String ch) throws SQLException {
        this.winston.getStatement().execute("DELETE FROM channels WHERE code='" + ch + "'");
        this.winston.getStatement().execute("DROP DATABASE `" + this.winston.databasePrefix + "_" + ch + "`");
    }

    public void deleteChannel(String ch) {
        try {
            this.winston.useRootDatabase();
            this.doDeleteChannel(ch);
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Error during deleteChannel().", e);
        }
    }

    public void deleteChannels(String chx, long delay) {
        String ch = chx;
        try {
            List<String> channelList = this.channels.getChannelCodes(chx);
            if (channelList == null || channelList.size() == 0) {
                this.winston.getLogger().info("deleteChannels: no channels found (" + chx + ")");
            } else {
                for (int i = 0; i < channelList.size(); ++i) {
                    ch = channelList.get(i);
                    if (i != 0 && delay != 0L) {
                        Thread.sleep(delay);
                    }
                    this.doDeleteChannel(ch);
                    this.winston.getLogger().info("Deleted channel: " + ch);
                }
                ch = chx;
            }
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Error during deleteChannels(" + ch + ")", e);
        }
    }

    public boolean isChannelExpressionValid(String chx) {
        boolean valid = true;
        String[] ca = chx.split("\\$");
        switch (ca.length) {
            case 3: {
                int index;
                if (ca[0].indexOf(WILDCARD) < 0 && ((index = ca[2].indexOf(WILDCARD)) < 0 || index > 1)) break;
                valid = true;
                break;
            }
            case 4: {
                if (ca[0].indexOf(WILDCARD) < 0 && ca[2].indexOf(WILDCARD) < 0) break;
                valid = true;
                break;
            }
            default: {
                valid = true;
            }
        }
        return valid;
    }

    public void purge(String channel, int days) {
        this.input.purgeTables(channel, days, this);
    }

    public void purgeChannels(String chx, int days, long delay) {
        String ch = chx;
        try {
            List<String> channelList = this.channels.getChannelCodes(chx);
            if (channelList == null || channelList.size() == 0) {
                this.winston.getLogger().info("purgeChannels: no channels found (" + chx + ")");
            } else {
                for (int i = 0; i < channelList.size(); ++i) {
                    ch = channelList.get(i);
                    if (i != 0 && delay != 0L) {
                        Thread.sleep(delay);
                    }
                    this.purge(ch, days);
                    this.winston.getLogger().info("Purged channel: " + ch);
                }
            }
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Error during purgeChannels(" + ch + ")", e);
        }
    }

    public boolean repairChannel(String day, String ch) {
        try {
            this.winston.useDatabase(ch);
            boolean fix = false;
            Statement st = this.winston.getStatement();
            this.winston.getLogger().info("Checking: " + ch + " " + day);
            ResultSet rs = st.executeQuery("CHECK TABLE `" + ch + "$$" + day + "` FAST QUICK");
            rs.next();
            String s = rs.getString("Msg_text");
            if (s.endsWith("doesn't exist")) {
                this.winston.getLogger().info(ch + " wave table doesn't exist.");
                return true;
            }
            if (!s.equals("Table is already up to date")) {
                fix = true;
            }
            rs = st.executeQuery("CHECK TABLE `" + ch + "$$H" + day + "` FAST QUICK");
            rs.next();
            s = rs.getString("Msg_text");
            if (s.endsWith("doesn't exist")) {
                this.winston.getLogger().info(ch + " helicorder table doesn't exist.");
                return true;
            }
            if (!rs.getString("Msg_text").equals("Table is already up to date")) {
                fix = true;
            }
            if (fix) {
                this.winston.getLogger().info("Repairing: " + ch);
                this.winston.getStatement().execute("REPAIR TABLE `" + ch + "$$" + day + "`");
                this.winston.getStatement().execute("REPAIR TABLE `" + ch + "$$H" + day + "`");
            }
            return true;
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Failed to repair: " + ch);
            return false;
        }
    }

    public void repair(String day, String chString) {
        if (chString == null) {
            List<Channel> chs = this.channels.getChannels();
            for (Channel ch : chs) {
                this.repairChannel(day, ch.getCode());
            }
        } else {
            this.repairChannel(day, chString);
        }
    }

    public boolean checkTable(String database, String table) throws SQLException {
        ResultSet rs = this.winston.getStatement().executeQuery("CHECK TABLE `" + table + "` FAST QUICK");
        rs.next();
        String s = rs.getString("Msg_text");
        if (s.endsWith("doesn't exist")) {
            this.winston.getLogger().info(table + " doesn't exist.");
            return false;
        }
        return s.equals("Table is already up to date");
    }

    public boolean repairTable(String database, String table) {
        try {
            this.winston.useDatabase(database);
            this.winston.getLogger().info("Checking table: " + table);
            boolean ct = this.checkTable(database, table);
            if (ct) {
                return true;
            }
            this.winston.getLogger().info("Repairing table: " + table);
            this.winston.getStatement().execute("REPAIR TABLE `" + table + "` QUICK");
            ct = this.checkTable(database, table);
            if (ct) {
                return true;
            }
            this.winston.getLogger().info("Still broken, attempting further repair: " + table);
            this.winston.getStatement().execute("REPAIR TABLE `" + table + "` QUICK USE_FRM");
            return this.checkTable(database, table);
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Failed to repair: " + table);
            return false;
        }
    }

    public void deleteWinston() {
        try {
            List<Channel> chs = this.channels.getChannels();
            for (Channel ch : chs) {
                this.deleteChannel(ch.getCode());
            }
            this.winston.getStatement().execute("DROP DATABASE `" + this.winston.databasePrefix + "_ROOT`");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void printUsage(int status, String cmd) {
        if (status == 2) {
            System.err.println("Missing or invalid command arguments for command (" + cmd + ")");
        }
        System.out.println("Winston Admin\n\nA collection of commands for administering a Winston database.\nInformation about connecting to the Winston database must be present\nin Winston.config in the current directory.\n\nUsage:\n  java gov.usgs.winston.db.Admin [options] command [command arguments]\n\nValid options:\n  --delay seconds                 the delay between each channel for commands\n                                  for multiple channels\n\nValid commands:\n  --list                          lists all channels\n  --list times                    lists all channels with time span\n  --delete channel                delete the specified channel\n  --deletex SSSS$CCC$NN[$LL]      delete the specified channels where:\n                                  SSSS is the station,\n                                  CCC is the channel which may contain\n                                  a wild card (%),\n                                  SSSS is the station,\n                                  NN is the network,\n                                  LL is the optional location which may contain\n                                  a wild card (%)\n  --span                          recalculate table spans\n  --purge channel days            purge the specified channel for the\n                                  specified number of days\n  --purgex channel days           purge the specified channel for the\n                                  specified number of days where the channel\n                                  may contain a wild card (%) anywhere\n  --repair YYYY_MM_DD [channel]   repair all tables on given day\n                                  optionally, just repair the specified channel\n");
        if (status != 0) {
            System.exit(status);
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            Admin.printUsage(-1, null);
        }
        int argIndex = 0;
        String cmd = null;
        int status = 0;
        ConfigFile cf = new ConfigFile("Winston.config");
        String driver = cf.getString("winston.driver");
        String url = cf.getString("winston.url");
        String db = cf.getString("winston.prefix");
        Admin admin = new Admin(driver, url, db);
        long delay = 0L;
        while (argIndex < args.length && status == 0) {
            String arg;
            if ((arg = args[argIndex++]).equals("--delay")) {
                try {
                    arg = args[argIndex++];
                    delay = (long)Integer.parseInt(arg) * 1000L;
                }
                catch (Exception e) {
                    status = 2;
                }
                continue;
            }
            if (cmd != null || (cmd = arg).length() == 0) {
                status = 2;
                continue;
            }
            if (cmd.equals("--span")) {
                admin.calculateTableSpans();
                continue;
            }
            if (cmd.equals("--list")) {
                boolean times = false;
                if (argIndex < args.length) {
                    if ((arg = args[argIndex++]).equals("times")) {
                        times = true;
                    } else {
                        status = 2;
                    }
                }
                if (status != 0) continue;
                admin.listChannels(times);
                continue;
            }
            if (cmd.equals("--delete") || cmd.equals("--deletex")) {
                if (argIndex < args.length) {
                    arg = args[argIndex++];
                    if (cmd.equals("--deletex")) {
                        if (admin.isChannelExpressionValid(arg)) {
                            admin.deleteChannels(arg, delay);
                            continue;
                        }
                        status = 3;
                        System.err.println("channel expresion may not have wild card for network or station (" + arg + ")");
                        continue;
                    }
                    admin.deleteChannel(arg);
                    continue;
                }
                status = 2;
                continue;
            }
            if (cmd.equals("--purge") || cmd.equals("--purgex")) {
                String channel = null;
                int days = 0;
                try {
                    channel = arg = args[argIndex++];
                    arg = args[argIndex++];
                    days = Integer.parseInt(arg);
                    if (days <= 0) {
                        status = 2;
                    }
                }
                catch (Exception e) {
                    status = 2;
                }
                if (status != 0) continue;
                if (cmd.equals("--purgex")) {
                    admin.purgeChannels(channel, days, delay);
                    continue;
                }
                admin.purge(channel, days);
                continue;
            }
            if (cmd.equals("--repair")) {
                if (argIndex < args.length) {
                    String day = args[argIndex++];
                    String ch = argIndex < args.length ? args[argIndex++] : null;
                    admin.repair(day, ch);
                    continue;
                }
                status = 2;
                continue;
            }
            System.err.println("Invalid argument(" + argIndex + "): '" + arg + "'");
            status = 1;
        }
        if (status != 0) {
            Admin.printUsage(status, cmd);
        }
    }
}

