/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.data;

import gov.usgs.plot.decorate.SmartTick;
import gov.usgs.plot.transform.Transformer;
import gov.usgs.proj.GeoRange;
import gov.usgs.proj.Projection;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class LineData {
    private List<Point2D.Double> points;
    public Color color = Color.BLACK;
    public Stroke stroke = new BasicStroke(1.0f);

    public LineData() {
        this.points = new ArrayList<Point2D.Double>();
    }

    public LineData(String fn) {
        this();
        this.readLineDataFile(fn);
    }

    public LineData(double[] x, double[] y) {
        this(x, y, true);
    }

    public LineData(double[] x, double[] y, boolean edge) {
        this();
        int j;
        int i;
        if (x != null) {
            for (i = edge ? 0 : 1; i < x.length - (edge ? 0 : 1); ++i) {
                if (y != null) {
                    for (j = 0; j < y.length; ++j) {
                        this.points.add(new Point2D.Double(x[i], y[j]));
                    }
                }
                this.points.add(new Point2D.Double(Double.NaN, Double.NaN));
            }
        }
        if (y != null) {
            for (i = edge ? 0 : 1; i < y.length - (edge ? 0 : 1); ++i) {
                if (x != null) {
                    for (j = 0; j < x.length; ++j) {
                        this.points.add(new Point2D.Double(x[j], y[i]));
                    }
                }
                this.points.add(new Point2D.Double(Double.NaN, Double.NaN));
            }
        }
    }

    public LineData(double x, double y, double width, double height, int pts) {
        this();
        int i;
        this.points.add(new Point2D.Double(x, y));
        for (i = 0; i <= pts; ++i) {
            this.points.add(new Point2D.Double(x + (double)i * width / (double)pts, y));
        }
        for (i = 0; i <= pts; ++i) {
            this.points.add(new Point2D.Double(x + width, y + (double)i * height / (double)pts));
        }
        for (i = pts; i >= 0; --i) {
            this.points.add(new Point2D.Double(x + (double)i * width / (double)pts, y + height));
        }
        for (i = pts; i >= 0; --i) {
            this.points.add(new Point2D.Double(x, y + (double)i * height / (double)pts));
        }
    }

    public static LineData createLonLatGrid(GeoRange range, int pts) {
        double[] x = SmartTick.autoTick(range.getWest(), range.getEast(), pts, false);
        double[] y = SmartTick.autoTick(range.getSouth(), range.getNorth(), pts, false);
        return new LineData(x, y);
    }

    public void toMathematica(PrintWriter out, double minX, double maxX, double minY, double maxY, double zVal) {
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Point2D.Double pt1 = this.points.get(i);
            if (Double.isNaN(pt1.x) || Double.isNaN(pt1.y)) continue;
            Point2D.Double pt2 = this.points.get(i + 1);
            if (Double.isNaN(pt2.x) || Double.isNaN(pt2.y) || !(pt1.x > minX) || !(pt1.x < maxX) || !(pt2.x > minX) || !(pt2.x < maxX) || !(pt1.y > minY) || !(pt1.y < maxY) || !(pt2.y > minY) || !(pt2.y < maxY)) continue;
            out.println("Line[{{" + pt1.x + "," + pt1.y + "," + zVal + "},{" + pt2.x + "," + pt2.y + "," + zVal + "}}],");
        }
    }

    public void readLineDataFile(String fn) {
        try {
            String s;
            File file = new File(fn);
            if (!file.exists()) {
                return;
            }
            this.points.clear();
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((s = in.readLine()) != null) {
                if (s.trim().length() == 0 || s.startsWith("#")) continue;
                if (s.toUpperCase().startsWith("COLOR")) {
                    this.color = (Color)Color.class.getDeclaredField(s.split("=")[1].toUpperCase()).get(null);
                    continue;
                }
                if (s.toUpperCase().startsWith("STROKE")) {
                    this.stroke = new BasicStroke(Float.parseFloat(s.split("=")[1]));
                    continue;
                }
                Point2D.Double pt = new Point2D.Double();
                if (s.startsWith(">") || s.indexOf("NaN") != -1) {
                    pt.x = Double.NaN;
                    pt.y = Double.NaN;
                } else {
                    StringTokenizer st = new StringTokenizer(s, " ,\t");
                    pt.x = Double.parseDouble(st.nextToken());
                    pt.y = Double.parseDouble(st.nextToken());
                    if (pt.x > 180.0) {
                        pt.x = -(360.0 - pt.x);
                    }
                }
                this.points.add(pt);
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public GeneralPath getPolygon(Transformer xform) {
        GeneralPath gp = new GeneralPath();
        boolean first = true;
        for (Point2D.Double pt : this.points) {
            if (Double.isNaN(pt.x) || Double.isNaN(pt.y)) {
                first = true;
                gp.closePath();
                continue;
            }
            if (first) {
                first = false;
                gp.moveTo((float)xform.getXPixel(pt.x) + 1.0f, (float)xform.getYPixel(pt.y) + 1.0f);
                continue;
            }
            gp.lineTo((float)xform.getXPixel(pt.x) + 1.0f, (float)xform.getYPixel(pt.y) + 1.0f);
        }
        return gp;
    }

    public void applyProjection(Projection proj) {
        ArrayList<Point2D.Double> newPoints = new ArrayList<Point2D.Double>(this.points.size());
        for (Point2D.Double pt : this.points) {
            newPoints.add(proj.forward(pt));
        }
        this.points = newPoints;
    }

    public List<Point2D.Double> getPoints() {
        return this.points;
    }
}

