package pickewanalysis.waveform;

import java.text.SimpleDateFormat;
import java.util.Locale;

public class WaveForm {

    //Constants
    SimpleDateFormat humanDate = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS");
    //Variables
    protected long starttime, endtime;
    protected int nsamp;
    protected double samprate, average;
    protected double[] samples;
    protected String stat, chan, net, loc;
    private int addSamplePos = 0;

    //Construct
    public WaveForm(String stat, String chan, String net, String loc,
            long starttime, double samprate, double[] samples) {
        this.stat = stat;
        this.chan = chan;
        this.net = net;
        this.loc = loc;
        this.starttime = starttime;
        this.samprate = samprate;
        this.samples = samples;
        this.nsamp = samples.length;
        this.endtime = starttime + (long) ((double) (nsamp - 1) * 1000.0 / samprate);
        this.average = 0;
        for (int i = 0; i < nsamp; i++) {
            this.average += samples[i];
        }
        this.average /= (double) nsamp;
    }

    protected WaveForm() {
        //Do nothing
    }

    public long getStartTime() {
        return starttime;
    }

    public long getEndTime() {
        return endtime;
    }

    public double[] getSamples() {
        return samples;
    }
    
    public int getIntSample(int i) {
        return (int)samples[i];
    }
    
    public void addSample(double sample) {
        samples[addSamplePos++]=sample;
        if (addSamplePos==samples.length) {
            addSamplePos = 0;
        }
    }

    public double[] removeAverage() {
        return removeAverage(average);
    }

    public double[] removeAverage(double newaverage) {
        double[] output = new double[nsamp];
        for (int i = 0; i < nsamp; i++) {
            output[i] = samples[i] - newaverage;
        }
        return output;
    }

    public double getSamplingRate() {
        return samprate;
    }

    public int getSampleCount() {
        return nsamp;
    }

    public boolean isSCNL(String stat, String chan, String net, String loc) {
        if (this.stat.equals(stat)
                && this.chan.equals(chan)
                && this.net.equals(net)
                && this.loc.equals(loc)) {
            return true;
        }
        return false;
    }

    public String getStation() {
        return stat;
    }

    public String getChannel() {
        return chan;
    }

    public String getNetwork() {
        return net;
    }

    public String getLocation() {
        return loc;
    }

    @Override
    public String toString() {
        return String.format(Locale.UK, "%5s.%3s.%2s.%2s %23s %23s %5d",
                stat, chan, net, loc,
                humanDate.format(starttime), humanDate.format(endtime), nsamp);
    }
}
