/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.gps;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.plot.data.BinaryDataSet;
import gov.usgs.util.Log;
import gov.usgs.vdx.data.gps.DataPoint;
import gov.usgs.vdx.data.gps.GPS;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class GPSData
implements BinaryDataSet {
    protected static final Logger logger = Log.getLogger("gov.usgs.vdx.data.gps.GPSData");
    private static final DoubleFactory2D DENSE = DoubleFactory2D.dense;
    private static final DoubleFactory2D SPARSE = DoubleFactory2D.sparse;
    private static final DoubleMatrix2D I3X3 = DENSE.identity(3);
    private static final DoubleMatrix2D ZERO3X3 = DENSE.make(3, 3);
    private static final double SECONDSPERYEAR = 3.15576E7;
    private DoubleMatrix2D tData;
    private DoubleMatrix2D rData;
    private DoubleMatrix2D xyzData;
    private DoubleMatrix2D covData;
    private DoubleMatrix2D lenData;

    public GPSData() {
    }

    public GPSData(List pts) {
        this.setToList(pts);
    }

    public void setToList(List pts) {
        int rows = pts.size();
        DataPoint origin = (DataPoint)pts.get(0);
        boolean hasLen = !Double.isNaN(origin.len);
        this.tData = DENSE.make(rows, 1);
        this.rData = DENSE.make(rows, 1);
        this.xyzData = DENSE.make(rows, 3);
        this.covData = DENSE.make(rows, 6);
        this.lenData = DENSE.make(rows, 1);
        for (int i = 0; i < rows; ++i) {
            DataPoint dp = (DataPoint)pts.get(i);
            this.tData.setQuick(i, 0, dp.t);
            this.rData.setQuick(i, 0, dp.r);
            this.xyzData.setQuick(i, 0, dp.x);
            this.xyzData.setQuick(i, 1, dp.y);
            this.xyzData.setQuick(i, 2, dp.z);
            this.covData.setQuick(i, 0, dp.sxx);
            this.covData.setQuick(i, 1, dp.syy);
            this.covData.setQuick(i, 2, dp.szz);
            this.covData.setQuick(i, 3, dp.sxy);
            this.covData.setQuick(i, 4, dp.sxz);
            this.covData.setQuick(i, 5, dp.syz);
            if (hasLen) {
                this.lenData.setQuick(i, 0, dp.len);
                continue;
            }
            double dx = dp.x - origin.x;
            double dy = dp.y - origin.y;
            double dz = dp.z - origin.z;
            this.lenData.setQuick(i, 0, Math.sqrt(dx * dx + dy * dy + dz * dz));
        }
    }

    @Override
    public ByteBuffer toBinary() {
        int rows = this.observations();
        ByteBuffer bb = ByteBuffer.allocate(4 + rows * 12 * 8);
        bb.putInt(rows);
        for (int i = 0; i < rows; ++i) {
            int j;
            bb.putDouble(this.tData.getQuick(i, 0));
            bb.putDouble(this.rData.getQuick(i, 0));
            for (j = 0; j < 3; ++j) {
                bb.putDouble(this.xyzData.getQuick(i, j));
            }
            for (j = 0; j < 6; ++j) {
                bb.putDouble(this.covData.getQuick(i, j));
            }
            bb.putDouble(this.lenData.getQuick(i, 0));
        }
        return bb;
    }

    @Override
    public void fromBinary(ByteBuffer bb) {
        int rows = bb.getInt();
        this.tData = DENSE.make(rows, 1);
        this.rData = DENSE.make(rows, 1);
        this.xyzData = DENSE.make(rows, 3);
        this.covData = DENSE.make(rows, 6);
        this.lenData = DENSE.make(rows, 1);
        DataPoint dp = new DataPoint();
        for (int i = 0; i < rows; ++i) {
            dp.fromBinary(bb);
            this.tData.setQuick(i, 0, dp.t);
            this.rData.setQuick(i, 0, dp.r);
            this.xyzData.setQuick(i, 0, dp.x);
            this.xyzData.setQuick(i, 1, dp.y);
            this.xyzData.setQuick(i, 2, dp.z);
            this.covData.setQuick(i, 0, dp.sxx);
            this.covData.setQuick(i, 1, dp.syy);
            this.covData.setQuick(i, 2, dp.szz);
            this.covData.setQuick(i, 3, dp.sxy);
            this.covData.setQuick(i, 4, dp.sxz);
            this.covData.setQuick(i, 5, dp.syz);
        }
    }

    public void setData(DoubleMatrix2D t, DoubleMatrix2D r, DoubleMatrix2D xyz, DoubleMatrix2D cov) {
        this.tData = t;
        this.rData = r;
        this.xyzData = xyz;
        this.covData = cov;
    }

    public int observations() {
        return this.tData.rows();
    }

    public void adjustTime(double adj) {
        for (int i = 0; i < this.tData.rows(); ++i) {
            this.tData.setQuick(i, 0, this.tData.getQuick(i, 0) + adj);
        }
    }

    public DoubleMatrix2D getTimes() {
        return this.tData;
    }

    public DoubleMatrix2D getRanks() {
        return this.rData;
    }

    public DoubleMatrix2D getXYZ() {
        return this.xyzData;
    }

    public DoubleMatrix2D getCovariance() {
        return this.covData;
    }

    public double[] getOrigin() {
        return new double[]{this.xyzData.get(0, 0), this.xyzData.get(0, 1), this.xyzData.get(0, 2)};
    }

    public void applyBaseline(GPSData baseline) {
        int k = 0;
        ArrayList<DataPoint> data = new ArrayList<DataPoint>(this.observations());
        if (Double.isNaN(this.tData.getQuick(0, 0)) || Double.isNaN(baseline.tData.getQuick(0, 0))) {
            DataPoint dp = new DataPoint();
            dp.t = Double.NaN;
            dp.r = Double.NaN;
            dp.x = Double.NaN;
            dp.y = Double.NaN;
            dp.z = Double.NaN;
            dp.sxx = Double.NaN;
            dp.syy = Double.NaN;
            dp.szz = Double.NaN;
            dp.sxy = Double.NaN;
            dp.sxz = Double.NaN;
            dp.syz = Double.NaN;
            data.add(dp);
        } else {
            int i;
            for (i = 0; i < baseline.observations(); ++i) {
                if (this.tData.getQuick(0, 0) != baseline.tData.getQuick(i, 0)) continue;
                k = i;
            }
            block1: for (i = 0; i < this.observations(); ++i) {
                for (int j = k; j < baseline.observations(); ++j) {
                    if (this.tData.getQuick(i, 0) != baseline.tData.getQuick(j, 0)) continue;
                    DataPoint dp = new DataPoint();
                    dp.t = this.tData.getQuick(i, 0);
                    dp.x = this.xyzData.getQuick(i, 0) - baseline.xyzData.getQuick(j, 0);
                    dp.y = this.xyzData.getQuick(i, 1) - baseline.xyzData.getQuick(j, 1);
                    dp.z = this.xyzData.getQuick(i, 2) - baseline.xyzData.getQuick(j, 2);
                    dp.sxx = this.covData.getQuick(i, 0) + baseline.covData.getQuick(j, 0);
                    dp.syy = this.covData.getQuick(i, 1) + baseline.covData.getQuick(j, 1);
                    dp.szz = this.covData.getQuick(i, 2) + baseline.covData.getQuick(j, 2);
                    dp.sxy = this.covData.getQuick(i, 3) + baseline.covData.getQuick(j, 3);
                    dp.sxz = this.covData.getQuick(i, 4) + baseline.covData.getQuick(j, 4);
                    dp.syz = this.covData.getQuick(i, 5) + baseline.covData.getQuick(j, 5);
                    dp.len = Math.sqrt(dp.x * dp.x + dp.y * dp.y + dp.z * dp.z);
                    data.add(dp);
                    k = j + 1;
                    continue block1;
                }
            }
        }
        this.setToList(data);
    }

    public void toENU(double lon, double lat) {
        double s1 = Math.sin(Math.toRadians(lon));
        double c1 = Math.cos(Math.toRadians(lon));
        double s2 = Math.sin(Math.toRadians(lat));
        double c2 = Math.cos(Math.toRadians(lat));
        for (int i = 0; i < this.observations(); ++i) {
            double x = this.xyzData.getQuick(i, 0);
            double y = this.xyzData.getQuick(i, 1);
            double z = this.xyzData.getQuick(i, 2);
            this.xyzData.setQuick(i, 0, -s1 * x + c1 * y);
            this.xyzData.setQuick(i, 1, -s2 * (c1 * x + s1 * y) + c2 * z);
            this.xyzData.setQuick(i, 2, c2 * (c1 * x + s1 * y) + s2 * z);
            double sxx = this.covData.getQuick(i, 0);
            double syy = this.covData.getQuick(i, 1);
            double szz = this.covData.getQuick(i, 2);
            double sxy = this.covData.getQuick(i, 3);
            double sxz = this.covData.getQuick(i, 4);
            double syz = this.covData.getQuick(i, 5);
            this.covData.setQuick(i, 0, s1 * s1 * sxx - 2.0 * c1 * s1 * sxy + c1 * c1 * syy);
            this.covData.setQuick(i, 1, s2 * (c1 * c1 * s2 * sxx + 2.0 * c1 * s2 * s1 * sxy - 2.0 * c2 * c1 * sxz + s2 * s1 * s1 * syy - 2.0 * c2 * s1 * syz) + c2 * c2 * szz);
            this.covData.setQuick(i, 2, c2 * (c2 * (c1 * c1 * sxx + 2.0 * c1 * s1 * sxy + s1 * s1 * syy) + 2.0 * s2 * (c1 * sxz + s1 * syz)) + s2 * s2 * szz);
            this.covData.setQuick(i, 3, -c1 * c1 * s2 * sxy + s1 * (s2 * s1 * sxy - c2 * sxz) + c1 * s2 * s1 * (sxx - syy) + c2 * c1 * syz);
            this.covData.setQuick(i, 4, -s1 * (c2 * c1 * sxx + c2 * s1 * sxy + s2 * sxz) + c1 * (c2 * c1 * sxy + c2 * s1 * syy + s2 * syz));
            this.covData.setQuick(i, 5, -c1 * s2 * (c2 * c1 * sxx + c2 * s1 * sxy + s2 * sxz) - s2 * s1 * (c2 * c1 * sxy + c2 * s1 * syy + s2 * syz) + c2 * (c2 * c1 * sxz + c2 * s1 * syz + s2 * szz));
        }
    }

    public DoubleMatrix2D toTimeSeries(GPSData baseline) {
        double[] origin = this.getOrigin();
        double[] originLLH = GPS.xyz2LLH(origin[0], origin[1], origin[2]);
        if (baseline != null) {
            this.applyBaseline(baseline);
        }
        this.toENU(originLLH[0], originLLH[1]);
        DoubleMatrix2D bigMatrix = DoubleFactory2D.dense.compose((DoubleMatrix2D[][])new DoubleMatrix2D[][]{{this.tData, this.rData, this.xyzData, this.lenData}});
        return bigMatrix;
    }

    public DoubleMatrix2D createVelocityKernel() {
        double t0 = this.tData.getQuick(0, 0);
        DoubleMatrix2D[][] g = new DoubleMatrix2D[this.observations()][2];
        for (int i = 0; i < this.observations(); ++i) {
            double ta = (this.tData.getQuick(i, 0) - t0) / 3.15576E7;
            DoubleMatrix2D temp = DENSE.make(3, 3);
            temp.setQuick(0, 0, ta);
            temp.setQuick(1, 1, ta);
            temp.setQuick(2, 2, ta);
            g[i][0] = temp;
            g[i][1] = I3X3;
        }
        return SPARSE.compose(g);
    }

    public DoubleMatrix2D createDisplacementKernel(double dt) {
        DoubleMatrix2D[][] g = new DoubleMatrix2D[this.observations()][2];
        for (int i = 0; i < this.observations(); ++i) {
            if (this.tData.getQuick(i, 0) == dt) {
                g[i][0] = ZERO3X3;
                g[i][1] = ZERO3X3;
                continue;
            }
            g[i][0] = this.tData.getQuick(i, 0) < dt ? ZERO3X3 : I3X3;
            g[i][1] = I3X3;
        }
        return SPARSE.compose(g);
    }

    public DoubleMatrix2D createDetrendedDisplacementKernel(double dt) {
        double t0 = this.tData.getQuick(0, 0);
        DoubleMatrix2D[][] g = new DoubleMatrix2D[this.observations()][3];
        for (int i = 0; i < this.observations(); ++i) {
            g[i][0] = this.tData.getQuick(i, 0) < dt ? ZERO3X3 : I3X3;
            double ta = (this.tData.getQuick(i, 0) - t0) / 3.15576E7;
            DoubleMatrix2D temp = DENSE.make(3, 3);
            temp.setQuick(0, 0, ta);
            temp.setQuick(1, 1, ta);
            temp.setQuick(2, 2, ta);
            g[i][1] = temp;
            g[i][2] = I3X3;
        }
        return SPARSE.compose(g);
    }

    public DataPoint getFirstObservation() {
        if (this.observations() <= 0) {
            return null;
        }
        DataPoint dp = new DataPoint();
        dp.t = this.tData.getQuick(0, 0);
        dp.r = this.rData.getQuick(0, 0);
        dp.x = this.xyzData.getQuick(0, 0);
        dp.y = this.xyzData.getQuick(0, 1);
        dp.z = this.xyzData.getQuick(0, 2);
        dp.len = this.lenData.getQuick(0, 0);
        dp.sxx = this.covData.getQuick(0, 0);
        dp.syy = this.covData.getQuick(0, 1);
        dp.szz = this.covData.getQuick(0, 2);
        dp.sxy = this.covData.getQuick(0, 3);
        dp.sxz = this.covData.getQuick(0, 4);
        dp.syz = this.covData.getQuick(0, 5);
        return dp;
    }

    public void output() {
        for (int i = 0; i < this.observations(); ++i) {
            logger.fine(new Double(this.tData.getQuick(i, 0)).toString());
            logger.fine(new Double(this.rData.getQuick(i, 0)).toString());
            logger.fine("\t" + this.xyzData.getQuick(i, 0) + " " + this.xyzData.getQuick(i, 1) + " " + this.xyzData.getQuick(i, 2) + " " + this.lenData.getQuick(i, 0));
            logger.fine("\t\t" + this.covData.getQuick(i, 0) + " " + this.covData.getQuick(i, 1) + " " + this.covData.getQuick(i, 2) + " ");
            logger.fine("\t\t" + this.covData.getQuick(i, 1) + " " + this.covData.getQuick(i, 3) + " " + this.covData.getQuick(i, 4) + " ");
            logger.fine("\t\t" + this.covData.getQuick(i, 2) + " " + this.covData.getQuick(i, 4) + " " + this.covData.getQuick(i, 5) + " ");
        }
    }

    public void outputRawData(String fn, String extra) {
    }
}

