/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.util;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.StringTokenizer;

public class GridBagHelper {
    private GridBagHelper() {
    }

    private static void parseCommand(GridBagConstraints c, String cmd) {
        String key = cmd.substring(0, cmd.indexOf("="));
        String value = cmd.substring(cmd.indexOf("=") + 1);
        if (key.equals("x")) {
            c.gridx = Integer.parseInt(value);
        } else if (key.equals("y")) {
            c.gridy = Integer.parseInt(value);
        } else if (key.equals("w")) {
            c.gridwidth = Integer.parseInt(value);
        } else if (key.equals("h")) {
            c.gridheight = Integer.parseInt(value);
        } else if (key.equals("wx")) {
            c.weightx = Double.parseDouble(value);
        } else if (key.equals("wy")) {
            c.weighty = Double.parseDouble(value);
        } else if (key.equals("ix")) {
            c.ipadx = Integer.parseInt(value);
        } else if (key.equals("iy")) {
            c.ipady = Integer.parseInt(value);
        } else if (key.equals("i")) {
            StringTokenizer st2 = new StringTokenizer(value, ",");
            int i1 = Integer.parseInt(st2.nextToken());
            int i2 = Integer.parseInt(st2.nextToken());
            int i3 = Integer.parseInt(st2.nextToken());
            int i4 = Integer.parseInt(st2.nextToken());
            c.insets = new Insets(i1, i2, i3, i4);
        } else if (key.equals("f")) {
            if (value.equals("b")) {
                c.fill = 1;
            } else if (value.equals("h")) {
                c.fill = 2;
            } else if (value.equals("v")) {
                c.fill = 3;
            } else if (value.equals("n")) {
                c.fill = 0;
            }
        } else if (key.equals("a")) {
            if (value.equals("n")) {
                c.anchor = 11;
            } else if (value.equals("e")) {
                c.anchor = 13;
            } else if (value.equals("s")) {
                c.anchor = 15;
            } else if (value.equals("w")) {
                c.anchor = 17;
            } else if (value.equals("ne")) {
                c.anchor = 12;
            } else if (value.equals("nw")) {
                c.anchor = 18;
            } else if (value.equals("se")) {
                c.anchor = 14;
            } else if (value.equals("sw")) {
                c.anchor = 16;
            } else if (value.equals("c")) {
                c.anchor = 10;
            }
        }
    }

    public static GridBagConstraints set(GridBagConstraints c, String s) {
        StringTokenizer st = new StringTokenizer(s, ";");
        while (st.hasMoreTokens()) {
            String cmd = st.nextToken();
            GridBagHelper.parseCommand(c, cmd);
        }
        return c;
    }
}

