/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.util.Set;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.FetchData;
import org.rrd4j.core.RrdDb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchRequest {
    private RrdDb parentDb;
    private ConsolFun consolFun;
    private long fetchStart;
    private long fetchEnd;
    private long resolution;
    private String[] filter;

    FetchRequest(RrdDb parentDb, ConsolFun consolFun, long fetchStart, long fetchEnd, long resolution) {
        if (consolFun == null) {
            throw new IllegalArgumentException("Null consolidation function in fetch request");
        }
        if (fetchStart < 0L) {
            throw new IllegalArgumentException("Invalid start time in fetch request: " + fetchStart);
        }
        if (fetchEnd < 0L) {
            throw new IllegalArgumentException("Invalid end time in fetch request: " + fetchEnd);
        }
        if (fetchStart > fetchEnd) {
            throw new IllegalArgumentException("Invalid start/end time in fetch request: " + fetchStart + " > " + fetchEnd);
        }
        if (resolution <= 0L) {
            throw new IllegalArgumentException("Invalid resolution in fetch request: " + resolution);
        }
        this.parentDb = parentDb;
        this.consolFun = consolFun;
        this.fetchStart = fetchStart;
        this.fetchEnd = fetchEnd;
        this.resolution = resolution;
    }

    public void setFilter(String ... filter) {
        this.filter = filter;
    }

    public void setFilter(Set<String> filter) {
        this.filter = filter.toArray(new String[0]);
    }

    public void setFilter(String filter) {
        String[] stringArray;
        if (filter == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = filter;
        }
        this.filter = stringArray;
    }

    public String[] getFilter() {
        return this.filter;
    }

    public ConsolFun getConsolFun() {
        return this.consolFun;
    }

    public long getFetchStart() {
        return this.fetchStart;
    }

    public long getFetchEnd() {
        return this.fetchEnd;
    }

    public long getResolution() {
        return this.resolution;
    }

    public String dump() {
        return "fetch \"" + this.parentDb.getRrdBackend().getPath() + "\" " + (Object)((Object)this.consolFun) + " --start " + this.fetchStart + " --end " + this.fetchEnd + (this.resolution > 1L ? " --resolution " + this.resolution : "");
    }

    String getRrdToolCommand() {
        return this.dump();
    }

    public FetchData fetchData() throws IOException {
        return this.parentDb.fetchData(this);
    }

    public RrdDb getParentDb() {
        return this.parentDb;
    }
}

