/**EWQuakeAlert generates email messages when receiving HYP2000ARC
 * messages from Earthworm.
 * Copyright (C) 2009 Ruben S. Luis
 * This program is free software: you ca redistribute it an/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be usefull,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with EWQuakeAlert. If not, see <http://www.gnu.org/licenses/>.
 **/

package ewquakealert;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Timer;
import java.util.TimerTask;

/**
 *
 * @author RL197718
 */
public class ImportClient extends Thread{
    sendAlive keepAliveTimer;

    ImportClient() {
        //Construct... do nothing
    }


    
    public void run() {
        boolean live = true;
        while(live) {
            try {
                Thread.sleep(1000);
            }
            catch (Exception e) {
                System.err.println(e);
            }
            
            switch (Configuration.clientStatus) {
                case 0:
                    //Disconected
                    //Do nothing unless automated reconect is active
                    if (Configuration.automaticReconnect)
                        Configuration.clientStatus = 3; //Order connect
                    break;
                case 1:
                    //Connected
                    //Check for incoming messages
                    String rawmsg = readEWMsg();
                    if (rawmsg.equals("SOCKET_EXCEPTION")) {
                        Configuration.clientStatus = 2; //Order disconect
                        break;
                    }
                    if (!rawmsg.equals("FAILED_TO_COMMUNICATE")) {
                        //Process message
                        EWMessage msg = new EWMessage(rawmsg);
                        if (msg.messageType==14) {
                            EWQuakeAlertView.println("Earthquake Notification ID: " + msg.eventID +
                                    " - Magnitude: " + msg.hypMag);
                            if (Configuration.useWaveServer) {
                                //Open phases
                                EWQuakeAlertView.println("Retrieving waveforms from the waveserver " +
                                        Configuration.waveserverIP + ": " + Configuration.waveserverPort);
                                msg.openPhases();
                            }
                            //Send email
                            msg.sendEWMsgEmail();

                            if (Configuration.sendSMS)
                                msg.sendEWSMS();
                        }
                    }
                    break;
                case 2:
                    //Order a client disconnect
                    clientDisconnect();
                    Configuration.clientStatus = 0;
                    break;
                case 3:
                    //Order a client connect
                    if (clientConnect()) Configuration.clientStatus = 1;
                    break;
                case 99:
                    //Terminate
                    live = false;
            }
        }
    } //end run


    private boolean clientConnect() {
        boolean output = false;
        try {
            //Connect
            Configuration.socket = new Socket(Configuration.serverIP, Configuration.serverPort);
            //Set timeout
            Configuration.socket.setSoTimeout(5000);
            //get input and output streams
            Configuration.Sinput = new DataInputStream(Configuration.socket.getInputStream());
            Configuration.Soutput = new DataOutputStream(Configuration.socket.getOutputStream());
            //Start keep alive timer
            keepAliveTimer = new sendAlive();
            output = true;
            EWQuakeAlertView.println("Connection to " +
                    Configuration.serverIP + ": " + Configuration.serverPort +
                    " established.");
            if ((Configuration.alertWhenRestore)&&(Configuration.alreadyAlerted)){
                String[] destination = new String[1];
                destination[0] = Configuration.destEmail[0];
                sendEmail x = new sendEmail(destination,
                "EWQuakeAlert Communications Restored Notification",
                "EWQuakeAlert has restored communications to Earthworm.");
                x.start();
            }

            Configuration.alreadyAlerted = false; //Reset for the case of failed comms
        }
        catch (Exception e) {
            EWQuakeAlertView.println("Connection to " +
                    Configuration.serverIP + ": " + Configuration.serverPort +
                    " refused.");
        }
        return output;
    } //end of clientConnect method

    private boolean clientDisconnect() {
        boolean output = false;
        try {
            keepAliveTimer.stopAlive();
            Configuration.Sinput.close();
            Configuration.Soutput.close();
            Configuration.socket.close();
            output = true;
            EWQuakeAlertView.println("Disconnected from " +
                    Configuration.serverIP + ": " + Configuration.serverPort);
        }
        catch (Exception e) {
            EWQuakeAlertView.println("Unable to disconnect from " +
                    Configuration.serverIP + ": " + Configuration.serverPort);
        }
        return output;
    }


    private String readEWMsg() {
        byte b;
        String rawmsg = "";
        try {
            b = Configuration.Sinput.readByte();
            if (b==2) {
                //begining of message
                while (b!=3) {
                    b = Configuration.Sinput.readByte();
                    if (b!=3) {
                        byte[] aux ={b};
                        rawmsg = rawmsg.concat(new String(aux));
                    }
                }
            }
        }
        catch (SocketException e) {
        //System.err.println("Lost communication to server.");
            rawmsg="SOCKET_EXCEPTION";
            EWQuakeAlertView.println("Lost communications with " +
                    Configuration.serverIP + ": " + Configuration.serverPort);

            //Send alert
            if ((Configuration.alertWhenFail)&&(!Configuration.alreadyAlerted)) {
                String[] destination = new String[1];
                destination[0] = Configuration.destEmail[0];
                sendEmail x = new sendEmail(destination,
                "EWQuakeAlert Communications Failure Alert",
                "EWQuakeAlert has lost communications to Earthworm.");
                x.start();
                Configuration.alreadyAlerted = true;
            }
        }
        catch (IOException e) {
            rawmsg="FAILED_TO_COMMUNICATE";
        }
        return rawmsg;
    } //End of readEWmsg method




    class sendAlive {
        Timer timer;
        DataOutputStream Soutput;

        public sendAlive() {
            timer = new Timer();
            Soutput = Configuration.Soutput;
            timer.scheduleAtFixedRate(new RemindTask(), 0,
                    Configuration.sendAliveInt * 1000);
        } //End of sendAlive method

        public void stopAlive() {
            timer.cancel();
        } //End of stopAlive method


        class RemindTask extends TimerTask {
            public void run() {
                //System.out.println("Sending keep-alive message.");
                try{
                    //Send keep alive message
                    String EWInstalationID = "255";
                    String EWModuleID = " 0";
                    String sendAliveText = Configuration.sendAliveText;
                    String keepAliveMsg = (char)(byte)(2) +
                            EWInstalationID + " " +
                            EWModuleID + "  3" +
                            sendAliveText + (char)(byte)(3);
                    Soutput.writeBytes(keepAliveMsg);
                    Soutput.flush();
                }
                catch (Exception e){
                    return;
                }
            } //End of run method
        } //End of RemindTask class
    } //End of sendAlive class
} //end ImportClient
