
DROP TABLE IF EXISTS `ew_arc_summary`;
CREATE TABLE `ew_arc_summary` (
    `id`                    BIGINT   NOT NULL AUTO_INCREMENT  COMMENT 'Unique incremental id',
    `fk_module`               BIGINT   NOT NULL COMMENT 'Foreign key to ew_module',
    `fk_sqkseq`               BIGINT   NOT NULL COMMENT 'Foreign key to ew_sqkseq',
    `ot_dt`                 DATETIME NOT NULL COMMENT 'Origin Time - datetime part',
    `ot_usec`               INT      NOT NULL COMMENT 'Origin Time - useconds',
    `lat`                   DOUBLE            COMMENT 'latitude (North=positive)',
    `lon`                   DOUBLE            COMMENT 'longitude(East=positive)',
    `z`                     DOUBLE            COMMENT 'depth (down=positive)',
    `nph`                   INT               COMMENT '# phases (P&S) w/ weight >0.1',
    `nphS`                  INT               COMMENT '# S phases w/ weight >0.1',
    `nphtot`                INT               COMMENT '# phases (P&S) w/ weight >0.0',
    `nPfm`                  INT               COMMENT '# P first motions',
    `gap`                   INT               COMMENT 'maximum azimuthal gap',
    `dmin`                  INT               COMMENT 'distance (km) to nearest station',
    `rms`                   DOUBLE            COMMENT 'RMS travel time residual',
    `e0az`                  INT               COMMENT 'azimuth of largest principal error',
    `e0dp`                  INT               COMMENT 'dip of largest principal error',
    `e0`                    DOUBLE            COMMENT 'magnitude (km) of largest principal error',
    `e1az`                  INT               COMMENT 'azimuth of intermediate principal error',
    `e1dp`                  INT               COMMENT 'dip of intermediate principal error',
    `e1`                    DOUBLE            COMMENT 'magnitude (km) of intermed principal error',
    `e2`                    DOUBLE            COMMENT 'magnitude (km) of smallest principal error',
    `erh`                   DOUBLE            COMMENT 'horizontal error (km)',
    `erz`                   DOUBLE            COMMENT 'vertical error (km)',
    `Md`                    DOUBLE            COMMENT 'duration magnitude',
    `reg`                   CHAR(4)           COMMENT 'location region',
    `labelpref`             CHAR              COMMENT 'character describing preferred magnitude',
    `Mpref`                 DOUBLE            COMMENT 'preferred magnitude',
    `wtpref`                DOUBLE            COMMENT 'weight (~ # readings) of preferred Mag',
    `mdtype`                CHAR              COMMENT 'Coda duration magnitude type code',
    `mdmad`                 DOUBLE            COMMENT 'Median-absolute-difference of duration mags',
    `mdwt`                  DOUBLE            COMMENT 'weight (~ # readings) of Md',
    `version`               BIGINT  NOT NULL  COMMENT 'version number of the origin',
    `quality`               CHAR(2)           COMMENT 'INGV quality code of the location (computed by ew2moledb)',
    `modified`              TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Last Review',            
    PRIMARY KEY (`id`),
    UNIQUE (`fk_module`, `fk_sqkseq`, `version`),
    FOREIGN KEY (`fk_module`) REFERENCES ew_module(`id`) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (`fk_sqkseq`) REFERENCES ew_sqkseq(`id`) ON DELETE CASCADE ON UPDATE CASCADE,
    INDEX (`ot_dt`),
    INDEX (`modified`)
)
ENGINE = InnoDB COMMENT 'Automatic arc summary from EW arc messages';

