package pickewanalysis;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import pickewanalysis.wavesources.WaveSource;

public class SourcesListTableModel extends AbstractTableModel {
    //Variables

    private List<WaveSource> sources;
    private String[] columnNames = new String[]{"Sources"};

    public SourcesListTableModel(List<WaveSource> sources) {
        this.sources = new ArrayList<WaveSource>(sources.size());
        for (WaveSource source:sources) {
            this.sources.add(source);
        }
    }

    public List<WaveSource> getSources() {
        return sources;
    }

    public int getColumnCount() {
        return 1;
    }

    public int getRowCount() {
        return sources.size();
    }

    public String getColumnName(int col) {
        return columnNames[col];
    }

    public Object getValueAt(int row, int col) {
        if (sources.isEmpty()) {
            return null;
        }
        return sources.get(row);
    }

    public Class getColumnClass(int c) {
        return WaveSource.class;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }
}
