package pickewanalysis;

import java.text.SimpleDateFormat;
import javax.swing.table.AbstractTableModel;
import pickewanalysis.wavesources.WaveSource;
import pickewanalysis.wavesources.WaveSourceStation;

public class ConfigStationsListTableModel extends AbstractTableModel {

    //Variables
    private WaveSource source;
    private String[] columnNames = new String[]{"Station", "Start", "End"};
    private final SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");

    public ConfigStationsListTableModel(WaveSource source) {
        this.source = source;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public int getRowCount() {
        if (source == null) {
            return 0;
        }
        return source.size();
    }

    public String getColumnName(int col) {
        return columnNames[col];
    }

    public Object getValueAt(int row, int col) {
        if (source.isEmpty()) {
            return null;
        }
        switch (col) {
            case 0:
                return source.get(row).getStation() + "."
                        + source.get(row).getChannel() + "."
                        + source.get(row).getNetwork() + "."
                        + source.get(row).getLocation();
            case 1:
                return df.format(source.get(row).getStartTime());
            case 2:
                return df.format(source.get(row).getEndTime());
        }
        return null;
    }

    public Class getColumnClass(int c) {
        return WaveSourceStation.class;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }
}
