/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import edu.sc.seis.seisFile.fdsnws.stationxml.Unit;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public abstract class BaseFilterType {
    private String resourceId;
    private String name;
    private String description;
    protected Unit inputUnits;
    protected Unit outputUnits;

    void parseAttributes(StartElement startE) throws StationXMLException {
        this.resourceId = StaxUtil.pullAttributeIfExists(startE, "resourceId");
        this.name = StaxUtil.pullAttributeIfExists(startE, "Name");
    }

    boolean parseSubElement(String elName, XMLEventReader reader) throws StationXMLException, XMLStreamException {
        if (elName.equals("Description")) {
            this.description = StaxUtil.pullText(reader, "Description");
            return true;
        }
        if (elName.equals("InputUnits")) {
            this.inputUnits = new Unit(reader, "InputUnits");
            return true;
        }
        if (elName.equals("OutputUnits")) {
            this.outputUnits = new Unit(reader, "OutputUnits");
            return true;
        }
        return false;
    }

    public Unit getInputUnits() {
        return this.inputUnits;
    }

    public Unit getOutputUnits() {
        return this.outputUnits;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }
}

