/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.InputStream;
import com.ooc.CORBA.OutputStream;
import com.ooc.OB.Assert;
import com.ooc.OB.CodeConverters;
import com.ooc.OB.CodeSetDatabase;
import com.ooc.OB.CodeSetUtil;
import com.ooc.OB.CoreTraceLevels;
import com.ooc.OB.GIOPIncomingMessage;
import com.ooc.OB.GIOPOutgoingMessage;
import com.ooc.OB.GIOPServerStarter;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.OAInterface;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.Upcall;
import com.ooc.OB.UpcallReturn;
import com.ooc.OB.Util;
import com.ooc.OCI.Buffer;
import com.ooc.OCI.ProfileInfo;
import com.ooc.OCI.Transport;
import com.ooc.OCI.TransportInfo;
import java.util.Properties;
import java.util.Vector;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CONV_FRAME.CodeSetContextHolder;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.GIOP.LocateStatusType_1_2;
import org.omg.GIOP.MsgType_1_1;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.GIOP.TargetAddressHolder;
import org.omg.GIOP.Version;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.IORHolder;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.ServiceContextListHolder;

abstract class GIOPServerWorker
implements UpcallReturn {
    protected ORBInstance orbInstance_;
    protected GIOPServerStarter starter_;
    protected Transport transport_;
    protected OAInterface oaInterface_;
    protected Buffer buf_;
    protected GIOPIncomingMessage incoming_;
    protected CodeConverters codeConverters_;
    protected Vector unsent_ = new Vector();
    protected int upcallCount_;
    protected byte minor_;
    protected boolean closeLogged_;
    protected boolean closeConnection_;
    protected int shutdownTimeout_;
    protected int acmTimeout_;
    protected long timestamp_;
    public static final int StateActive = 0;
    public static final int StateHolding = 1;
    public static final int StateClosing = 2;
    public static final int StateError = 3;
    public static final int StateClosed = 4;
    protected int state_;

    protected void logCloseConnection() {
        if (!this.closeLogged_) {
            CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
            if (coreTraceLevels.traceConnections() > 0) {
                TransportInfo transportInfo = this.transport_.get_info();
                String string = "closing connection\n";
                string = String.valueOf(string) + transportInfo.describe();
                if (this.minor_ >= 2 && !this.closeConnection_) {
                    string = String.valueOf(string) + "\nclient disconnected without sending a `CloseConnection' message";
                }
                this.orbInstance_.getLogger().trace("incoming", string);
            }
            this.closeLogged_ = true;
        }
    }

    protected void addCloseConnection() {
        this.closeConnection_ = true;
        Buffer buffer = new Buffer(12);
        OutputStream outputStream = new OutputStream(buffer);
        ProfileInfo profileInfo = new ProfileInfo();
        profileInfo.major = 1;
        profileInfo.minor = this.minor_;
        GIOPOutgoingMessage gIOPOutgoingMessage = new GIOPOutgoingMessage(this.orbInstance_, outputStream, profileInfo);
        gIOPOutgoingMessage.writeMessageHeader(MsgType_1_1.CloseConnection, false, 0);
        this.add(buffer);
    }

    protected void addMessageError() {
        Buffer buffer = new Buffer(12);
        OutputStream outputStream = new OutputStream(buffer);
        ProfileInfo profileInfo = new ProfileInfo();
        profileInfo.major = 1;
        profileInfo.minor = this.minor_;
        GIOPOutgoingMessage gIOPOutgoingMessage = new GIOPOutgoingMessage(this.orbInstance_, outputStream, profileInfo);
        gIOPOutgoingMessage.writeMessageHeader(MsgType_1_1.MessageError, false, 0);
        this.add(buffer);
    }

    protected void add(Buffer buffer) {
        this.updateTimestamp();
        if (this.state_ == 3 || this.state_ == 4) {
            return;
        }
        buffer.pos(0);
        this.unsent_.addElement(buffer);
    }

    protected void addUpcall(Upcall upcall) {
        OutputStream outputStream = upcall.output();
        ProfileInfo profileInfo = upcall.profileInfo();
        GIOPOutgoingMessage gIOPOutgoingMessage = new GIOPOutgoingMessage(this.orbInstance_, outputStream, profileInfo);
        int n = outputStream._OB_pos();
        outputStream._OB_pos(0);
        try {
            gIOPOutgoingMessage.writeMessageHeader(MsgType_1_1.Reply, false, n - 12);
        }
        catch (SystemException systemException) {
            Assert.assert(false);
        }
        Buffer buffer = new Buffer();
        buffer.consume(outputStream._OB_buffer());
        this.add(buffer);
        Assert.assert(this.upcallCount_ > 0);
        --this.upcallCount_;
        if (this.upcallCount_ == 0 && this.state_ == 2) {
            this.addCloseConnection();
        }
    }

    protected void getCodeConverters(ServiceContext[] serviceContextArray) {
        if (this.codeConverters_ == null) {
            int n = 0;
            while (n < serviceContextArray.length) {
                if (serviceContextArray[n].context_id == 1) {
                    CodeSetContextHolder codeSetContextHolder = new CodeSetContextHolder();
                    CodeSetUtil.extractCodeSetContext(serviceContextArray[n], codeSetContextHolder);
                    CodeSetContext codeSetContext = codeSetContextHolder.value;
                    this.codeConverters_ = new CodeConverters();
                    this.codeConverters_.inputCharConverter = CodeSetDatabase.instance().getConverter(CodeSetUtil.native_cs(), codeSetContext.char_data);
                    this.codeConverters_.outputCharConverter = CodeSetDatabase.instance().getConverter(codeSetContext.char_data, CodeSetUtil.native_cs());
                    this.codeConverters_.wcharConverter = CodeSetDatabase.instance().getConverter(codeSetContext.wchar_data, CodeSetUtil.native_wcs());
                    CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
                    if (coreTraceLevels.traceConnections() < 2) break;
                    String string = "receiving transmission code sets";
                    string = String.valueOf(string) + "\nchar code set: ";
                    string = this.codeConverters_.inputCharConverter != null ? String.valueOf(string) + this.codeConverters_.inputCharConverter.getFrom().description : String.valueOf(string) + "none";
                    string = String.valueOf(string) + "\nwchar code set: ";
                    string = this.codeConverters_.wcharConverter != null ? String.valueOf(string) + this.codeConverters_.wcharConverter.getTo().description : String.valueOf(string) + "none";
                    this.orbInstance_.getLogger().trace("incoming", string);
                    return;
                }
                ++n;
            }
        }
    }

    protected void exception(int n, SystemException systemException) {
        String string = "communications error with client\n";
        string = String.valueOf(string) + systemException.getMessage();
        this.orbInstance_.getLogger().warning(string);
        this.setStateNoSync(n);
    }

    protected boolean setStateNoSync(int n) {
        if (this.state_ == n) {
            return false;
        }
        if (this.state_ != 1 && n < this.state_) {
            return false;
        }
        switch (n) {
            case 2: {
                if (this.upcallCount_ == 0) {
                    this.addCloseConnection();
                }
                this.starter_.removeWorker(this);
                break;
            }
            case 3: {
                this.addMessageError();
                this.starter_.removeWorker(this);
                break;
            }
            case 4: {
                this.logCloseConnection();
                this.transport_.close();
                this.starter_.removeWorker(this);
                break;
            }
        }
        this.state_ = n;
        return true;
    }

    protected Upcall execute() {
        boolean bl;
        Assert.assert(this.state_ == 0 || this.state_ == 2);
        this.updateTimestamp();
        try {
            Buffer buffer = this.buf_;
            this.buf_ = null;
            bl = this.incoming_.consumeBuffer(buffer);
        }
        catch (SystemException systemException) {
            this.exception(3, systemException);
            return null;
        }
        byte by = this.incoming_.version().minor;
        if (by > this.minor_) {
            this.minor_ = by;
        }
        if (!bl) {
            return null;
        }
        Upcall upcall = null;
        switch (this.incoming_.type().value()) {
            case 0: {
                if (this.state_ != 0) break;
                upcall = this.executeRequest();
                break;
            }
            case 3: {
                if (this.state_ != 0) break;
                this.executeLocate();
                break;
            }
            case 1: 
            case 4: {
                this.exception(3, new COMM_FAILURE(MinorCodes.describeCommFailure(1330577427), 1330577427, CompletionStatus.COMPLETED_MAYBE));
                break;
            }
            case 5: {
                if (this.incoming_.version().minor < 2) {
                    this.exception(4, new COMM_FAILURE(String.valueOf(MinorCodes.describeCommFailure(1330577427)) + ": invalid version for CloseConnection", 1330577427, CompletionStatus.COMPLETED_MAYBE));
                    break;
                }
                this.closeConnection_ = true;
                this.setStateNoSync(4);
                break;
            }
            case 6: {
                this.exception(3, new COMM_FAILURE(MinorCodes.describeCommFailure(1330577429), 1330577429, CompletionStatus.COMPLETED_MAYBE));
                break;
            }
            case 7: {
                Assert.assert(false);
                break;
            }
        }
        return upcall;
    }

    protected Upcall executeRequest() {
        int n;
        Assert.assert(this.state_ == 0);
        BooleanHolder booleanHolder = new BooleanHolder();
        StringHolder stringHolder = new StringHolder();
        ServiceContextListHolder serviceContextListHolder = new ServiceContextListHolder();
        TargetAddressHolder targetAddressHolder = new TargetAddressHolder();
        try {
            n = this.incoming_.readRequestHeader(booleanHolder, targetAddressHolder, stringHolder, serviceContextListHolder);
            Assert.assert(targetAddressHolder.value.discriminator() == 0);
        }
        catch (SystemException systemException) {
            this.exception(3, systemException);
            return null;
        }
        Version version = this.incoming_.version();
        ProfileInfo profileInfo = new ProfileInfo();
        profileInfo.major = version.major;
        profileInfo.minor = version.minor;
        profileInfo.key = targetAddressHolder.value.object_key();
        InputStream inputStream = this.incoming_.input();
        this.getCodeConverters(serviceContextListHolder.value);
        if (this.codeConverters_ != null) {
            inputStream._OB_codeConverters(this.codeConverters_, version.major == 1 && version.minor < 2);
        }
        if (booleanHolder.value) {
            ++this.upcallCount_;
        }
        return this.oaInterface_.createUpcall(booleanHolder.value ? this : null, profileInfo, this.transport_.get_info(), n, stringHolder.value, inputStream, serviceContextListHolder.value);
    }

    protected void executeLocate() {
        Assert.assert(this.state_ == 0);
        try {
            TargetAddressHolder targetAddressHolder = new TargetAddressHolder();
            int n = this.incoming_.readLocateRequestHeader(targetAddressHolder);
            Assert.assert(targetAddressHolder.value.discriminator() == 0);
            byte[] byArray = targetAddressHolder.value.object_key();
            IORHolder iORHolder = new IORHolder();
            int n2 = this.oaInterface_.findByKey(byArray, iORHolder);
            LocateStatusType_1_2 locateStatusType_1_2 = LocateStatusType_1_2.from_int(n2);
            Buffer buffer = new Buffer(12);
            buffer.pos(12);
            OutputStream outputStream = new OutputStream(buffer);
            ProfileInfo profileInfo = new ProfileInfo();
            profileInfo.major = this.incoming_.version().major;
            profileInfo.minor = this.incoming_.version().minor;
            GIOPOutgoingMessage gIOPOutgoingMessage = new GIOPOutgoingMessage(this.orbInstance_, outputStream, profileInfo);
            gIOPOutgoingMessage.writeLocateReplyHeader(n, locateStatusType_1_2);
            if (locateStatusType_1_2 == LocateStatusType_1_2.OBJECT_FORWARD || locateStatusType_1_2 == LocateStatusType_1_2.OBJECT_FORWARD_PERM) {
                IORHelper.write(outputStream, iORHolder.value);
            }
            int n3 = outputStream._OB_pos();
            outputStream._OB_pos(0);
            gIOPOutgoingMessage.writeMessageHeader(MsgType_1_1.LocateReply, false, n3 - 12);
            outputStream._OB_pos(n3);
            Buffer buffer2 = new Buffer();
            buffer2.consume(outputStream._OB_buffer());
            this.add(buffer2);
            return;
        }
        catch (SystemException systemException) {
            this.exception(3, systemException);
            return;
        }
    }

    protected void updateTimestamp() {
        if (this.acmTimeout_ > 0) {
            this.timestamp_ = System.currentTimeMillis() / 1000L;
        }
    }

    protected void finalize() throws Throwable {
        Assert.assert(this.state_ == 4);
        super.finalize();
    }

    GIOPServerWorker(ORBInstance oRBInstance, GIOPServerStarter gIOPServerStarter, Transport transport, OAInterface oAInterface) {
        this.orbInstance_ = oRBInstance;
        this.starter_ = gIOPServerStarter;
        this.transport_ = transport;
        this.oaInterface_ = oAInterface;
        this.incoming_ = new GIOPIncomingMessage(this.orbInstance_);
        this.codeConverters_ = null;
        this.upcallCount_ = 0;
        this.minor_ = 0;
        this.closeLogged_ = false;
        this.closeConnection_ = false;
        this.state_ = 1;
        Properties properties = this.orbInstance_.getProperties();
        String string = properties.getProperty("ooc.orb.server_shutdown_timeout");
        this.shutdownTimeout_ = string != null ? Integer.parseInt(string) : 2;
        string = properties.getProperty("ooc.orb.server_timeout");
        if (string != null) {
            this.acmTimeout_ = Integer.parseInt(string);
            this.updateTimestamp();
        } else {
            this.acmTimeout_ = 0;
            this.timestamp_ = 0L;
        }
        CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
        if (coreTraceLevels.traceConnections() > 0) {
            TransportInfo transportInfo = this.transport_.get_info();
            String string2 = "new connection\n";
            string2 = String.valueOf(string2) + transportInfo.describe();
            this.orbInstance_.getLogger().trace("incoming", string2);
        }
    }

    public abstract boolean setState(int var1);

    public void upcallBeginReply(Upcall upcall, ServiceContext[] serviceContextArray) {
        upcall.createOutputStream(12);
        OutputStream outputStream = upcall.output();
        ProfileInfo profileInfo = upcall.profileInfo();
        GIOPOutgoingMessage gIOPOutgoingMessage = new GIOPOutgoingMessage(this.orbInstance_, outputStream, profileInfo);
        int n = upcall.requestId();
        try {
            gIOPOutgoingMessage.writeReplyHeader(n, ReplyStatusType_1_2.NO_EXCEPTION, serviceContextArray);
            return;
        }
        catch (SystemException systemException) {
            Assert.assert(false);
            return;
        }
    }

    public void upcallBeginUserException(Upcall upcall, ServiceContext[] serviceContextArray) {
        upcall.createOutputStream(12);
        OutputStream outputStream = upcall.output();
        ProfileInfo profileInfo = upcall.profileInfo();
        GIOPOutgoingMessage gIOPOutgoingMessage = new GIOPOutgoingMessage(this.orbInstance_, outputStream, profileInfo);
        int n = upcall.requestId();
        try {
            gIOPOutgoingMessage.writeReplyHeader(n, ReplyStatusType_1_2.USER_EXCEPTION, serviceContextArray);
            return;
        }
        catch (SystemException systemException) {
            Assert.assert(false);
            return;
        }
    }

    public void upcallEndUserException(Upcall upcall) {
        this.upcallEndReply(upcall);
    }

    public void upcallUserException(Upcall upcall, UserException userException, ServiceContext[] serviceContextArray) {
        upcall.createOutputStream(12);
        OutputStream outputStream = upcall.output();
        ProfileInfo profileInfo = upcall.profileInfo();
        GIOPOutgoingMessage gIOPOutgoingMessage = new GIOPOutgoingMessage(this.orbInstance_, outputStream, profileInfo);
        int n = upcall.requestId();
        try {
            gIOPOutgoingMessage.writeReplyHeader(n, ReplyStatusType_1_2.USER_EXCEPTION, serviceContextArray);
            Assert.assert(false);
        }
        catch (SystemException systemException) {
            Assert.assert(false);
        }
        this.upcallEndReply(upcall);
    }

    public void upcallSystemException(Upcall upcall, SystemException systemException, ServiceContext[] serviceContextArray) {
        upcall.createOutputStream(12);
        OutputStream outputStream = upcall.output();
        ProfileInfo profileInfo = upcall.profileInfo();
        GIOPOutgoingMessage gIOPOutgoingMessage = new GIOPOutgoingMessage(this.orbInstance_, outputStream, profileInfo);
        int n = upcall.requestId();
        try {
            gIOPOutgoingMessage.writeReplyHeader(n, ReplyStatusType_1_2.SYSTEM_EXCEPTION, serviceContextArray);
            Util.marshalSystemException(outputStream, systemException);
        }
        catch (SystemException systemException2) {
            Assert.assert(false);
        }
        this.upcallEndReply(upcall);
    }

    public void upcallForward(Upcall upcall, IOR iOR, boolean bl, ServiceContext[] serviceContextArray) {
        upcall.createOutputStream(12);
        OutputStream outputStream = upcall.output();
        ProfileInfo profileInfo = upcall.profileInfo();
        GIOPOutgoingMessage gIOPOutgoingMessage = new GIOPOutgoingMessage(this.orbInstance_, outputStream, profileInfo);
        int n = upcall.requestId();
        ReplyStatusType_1_2 replyStatusType_1_2 = bl ? ReplyStatusType_1_2.LOCATION_FORWARD_PERM : ReplyStatusType_1_2.LOCATION_FORWARD;
        try {
            gIOPOutgoingMessage.writeReplyHeader(n, replyStatusType_1_2, serviceContextArray);
            IORHelper.write(outputStream, iOR);
        }
        catch (SystemException systemException) {
            Assert.assert(false);
        }
        this.upcallEndReply(upcall);
    }

    public abstract void upcallEndReply(Upcall var1);
}

