/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.InputStream;
import com.ooc.CORBA.OutputStream;
import com.ooc.OB.Assert;
import com.ooc.OB.Downcall;
import com.ooc.OB.LocationForward;
import com.ooc.OB.OAInterface;
import com.ooc.OB.Server;
import com.ooc.OB.Upcall;
import com.ooc.OB.UpcallReturn;
import com.ooc.OCI.Buffer;
import com.ooc.OCI.ProfileInfo;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UserException;
import org.omg.IOP.IOR;
import org.omg.IOP.ServiceContext;

public final class CollocatedServer
extends Server
implements UpcallReturn {
    private int nextRequestId_ = 0;
    private Object nextRequestIdMutex_ = new Object();
    private Hashtable callMap_ = new Hashtable(13);
    private boolean destroy_ = false;
    private boolean hold_ = true;
    private OAInterface oaInterface_;

    public CollocatedServer(OAInterface oAInterface, int n) {
        super(n);
        this.oaInterface_ = oAInterface;
    }

    public synchronized void destroy() {
        if (this.destroy_) {
            return;
        }
        this.destroy_ = true;
        Enumeration enumeration = this.callMap_.keys();
        while (enumeration.hasMoreElements()) {
            Downcall downcall = (Downcall)this.callMap_.get(enumeration.nextElement());
            Assert.assert(downcall != null);
            Assert.assert(downcall.pending());
            downcall.setFailureException(new INITIALIZE("ORB has been destroyed", 1330577409, CompletionStatus.COMPLETED_NO));
        }
        this.callMap_.clear();
        this.notifyAll();
    }

    public synchronized void hold() {
        Assert.assert(!this.destroy_);
        this.hold_ = true;
        this.notifyAll();
    }

    public synchronized void activate() {
        Assert.assert(!this.destroy_);
        this.hold_ = false;
        this.notifyAll();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean send(Downcall downcall, boolean bl) {
        Upcall upcall;
        downcall.initStateMonitor();
        CollocatedServer collocatedServer = this;
        synchronized (collocatedServer) {
            while (true) {
                if (!this.hold_ || this.destroy_) {
                    if (!this.destroy_) break;
                    downcall.setFailureException(new TRANSIENT("Collocated server has already been destroyed", 0, CompletionStatus.COMPLETED_NO));
                    return true;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            ProfileInfo profileInfo = downcall.profileInfo();
            int n = downcall.requestId();
            String string = downcall.operation();
            OutputStream outputStream = downcall.output();
            Buffer buffer = new Buffer();
            buffer.consume(outputStream._OB_buffer());
            ServiceContext[] serviceContextArray = downcall.getRequestSCL();
            if (downcall.responseExpected()) {
                this.callMap_.put(new Integer(n), downcall);
                downcall.setPending();
                upcall = this.oaInterface_.createUpcall(this, profileInfo, null, n, string, new InputStream(buffer, 0, false), serviceContextArray);
            } else {
                downcall.setNoException(null);
                upcall = this.oaInterface_.createUpcall(null, profileInfo, null, n, string, new InputStream(buffer, 0, false), serviceContextArray);
            }
        }
        upcall.invoke();
        if (!downcall.responseExpected()) {
            return true;
        }
        try {
            return downcall.waitUntilSent(false);
        }
        catch (SystemException systemException) {
            Assert.assert(false);
            return false;
        }
    }

    public boolean receive(Downcall downcall, boolean bl) {
        try {
            return downcall.waitUntilCompleted(bl);
        }
        catch (SystemException systemException) {
            CollocatedServer collocatedServer = this;
            synchronized (collocatedServer) {
                this.callMap_.remove(new Integer(downcall.requestId()));
                downcall.setFailureException(systemException);
                boolean bl2 = true;
                Object var6_6 = null;
                return bl2;
            }
        }
    }

    public boolean sendReceive(Downcall downcall) {
        this.send(downcall, true);
        return this.receive(downcall, true);
    }

    public int requestId() {
        Object object = this.nextRequestIdMutex_;
        synchronized (object) {
            int n = this.nextRequestId_++;
            Object var3_3 = null;
            return n;
        }
    }

    public ProfileInfo[] getUsableProfiles(IOR iOR, Policy[] policyArray) {
        return this.oaInterface_.getUsableProfiles(iOR, policyArray);
    }

    public void upcallBeginReply(Upcall upcall, ServiceContext[] serviceContextArray) {
        upcall.createOutputStream(0);
        if (serviceContextArray.length > 0) {
            CollocatedServer collocatedServer = this;
            synchronized (collocatedServer) {
                Downcall downcall = (Downcall)this.callMap_.get(new Integer(upcall.requestId()));
                if (downcall != null) {
                    downcall.setReplySCL(serviceContextArray);
                }
                return;
            }
        }
    }

    public synchronized void upcallEndReply(Upcall upcall) {
        Downcall downcall = (Downcall)this.callMap_.get(new Integer(upcall.requestId()));
        if (downcall != null) {
            OutputStream outputStream = upcall.output();
            Buffer buffer = new Buffer();
            buffer.consume(outputStream._OB_buffer());
            InputStream inputStream = new InputStream(buffer, 0, false);
            downcall.setNoException(inputStream);
            this.callMap_.remove(new Integer(downcall.requestId()));
        }
    }

    public void upcallBeginUserException(Upcall upcall, ServiceContext[] serviceContextArray) {
        upcall.createOutputStream(0);
        if (serviceContextArray.length > 0) {
            CollocatedServer collocatedServer = this;
            synchronized (collocatedServer) {
                Downcall downcall = (Downcall)this.callMap_.get(new Integer(upcall.requestId()));
                if (downcall != null) {
                    downcall.setReplySCL(serviceContextArray);
                }
                return;
            }
        }
    }

    public synchronized void upcallEndUserException(Upcall upcall) {
        Downcall downcall = (Downcall)this.callMap_.get(new Integer(upcall.requestId()));
        if (downcall != null) {
            OutputStream outputStream = upcall.output();
            Buffer buffer = new Buffer();
            buffer.consume(outputStream._OB_buffer());
            InputStream inputStream = new InputStream(buffer, 0, false);
            downcall.setUserException(inputStream);
            this.callMap_.remove(new Integer(downcall.requestId()));
        }
    }

    public void upcallUserException(Upcall upcall, UserException userException, ServiceContext[] serviceContextArray) {
        this.upcallBeginUserException(upcall, serviceContextArray);
        upcall.output();
        try {
            Assert.assert(false);
        }
        catch (SystemException systemException) {
            try {
                upcall.marshalEx(systemException);
            }
            catch (LocationForward locationForward) {
                Assert.assert(false);
            }
        }
        this.upcallEndUserException(upcall);
    }

    public synchronized void upcallSystemException(Upcall upcall, SystemException systemException, ServiceContext[] serviceContextArray) {
        Downcall downcall = (Downcall)this.callMap_.get(new Integer(upcall.requestId()));
        if (downcall != null) {
            if (serviceContextArray.length > 0) {
                downcall.setReplySCL(serviceContextArray);
            }
            downcall.setSystemException(systemException);
            this.callMap_.remove(new Integer(downcall.requestId()));
        }
    }

    public synchronized void upcallForward(Upcall upcall, IOR iOR, boolean bl, ServiceContext[] serviceContextArray) {
        Downcall downcall = (Downcall)this.callMap_.get(new Integer(upcall.requestId()));
        if (downcall != null) {
            if (serviceContextArray.length > 0) {
                downcall.setReplySCL(serviceContextArray);
            }
            downcall.setLocationForward(iOR, bl);
            this.callMap_.remove(new Integer(downcall.requestId()));
        }
    }
}

