package edu.iris.Fissures.seed.director;

import edu.iris.Fissures.seed.exception.*;
import com.isti.shape.javaseed.*;
import java.io.*;

/**
 * Extension of RespImportDirector to facilitate use in JavaSeed
 * RespImportDirector is a part of SHAPE which is produced by ISTI.
 * www.isti.com
 * Used with permission provided credit is attributed to ISTI.
 *
 * @author Robert Casey
 * @version 11/11/2005
 */

public class ExtRespImportDirector extends RespImportDirector {
    
    /**
     * Instantiate without assigning a Builder or Container to it.
     */
    public ExtRespImportDirector () {
        super();
    }
    
    // make a HAT file for the listed resp file and return the HAT filename created
    public String makeHatForResp(String respFile) throws IOException {
        String hatFileName = "tempHATFile";
        // make a temporary HAT file for SHAPE to read the specified RESP file
        File hatFile = new File(hatFileName);
        PrintWriter launchWriter =
            new PrintWriter(new BufferedWriter(new FileWriter(hatFile)));
        launchWriter.println("<SHAPEFILE>");
        launchWriter.println("<station>");
        launchWriter.println("<channel>");
        launchWriter.println("<respfile>" + respFile + "</respfile>");
        launchWriter.println("</channel>");
        launchWriter.println("</station>");
        launchWriter.println("</SHAPEFILE>");
        launchWriter.close();
        return hatFileName;
    }
    
    // read the indicated HAT file in order to read the RESP file listed in it.
    public void readHat(String hatFile) throws BuilderException {
        try {
            builder.incrementVolume();
            processHATFile(hatFile);
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuilderException ("Exception encountered in readHat(): " + e);
        }
    }
    
}
