/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.cmd;

import java.io.IOException;
import org.rrd4j.DsType;
import org.rrd4j.cmd.ColonSplitter;
import org.rrd4j.cmd.RrdToolCmd;
import org.rrd4j.core.Datasource;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.Util;

class RrdTuneCmd
extends RrdToolCmd {
    RrdTuneCmd() {
    }

    String getCmdType() {
        return "tune";
    }

    Object execute() throws IOException {
        String[] heartbeats = this.getMultipleOptionValues("h", "heartbeat");
        String[] minimums = this.getMultipleOptionValues("i", "minimum");
        String[] maximums = this.getMultipleOptionValues("a", "maximum");
        String[] dsTypes = this.getMultipleOptionValues("d", "data-source-type");
        String[] dsNames = this.getMultipleOptionValues("r", "data-source-rename");
        String[] words = this.getRemainingWords();
        if (words.length < 2) {
            throw new IllegalArgumentException("File name not specified");
        }
        if (words.length > 2) {
            throw new IllegalArgumentException("Unexpected token encountered: " + words[2]);
        }
        String path = words[1];
        RrdDb rrd = RrdTuneCmd.getRrdDbReference(path);
        try {
            String[] stringArray = heartbeats;
            int n = heartbeats.length;
            int n2 = 0;
            while (n2 < n) {
                String heartbeat = stringArray[n2];
                this.tuneHeartbeat(rrd, heartbeat);
                ++n2;
            }
            stringArray = minimums;
            n = minimums.length;
            n2 = 0;
            while (n2 < n) {
                String minimum = stringArray[n2];
                this.tuneMinimum(rrd, minimum);
                ++n2;
            }
            stringArray = maximums;
            n = maximums.length;
            n2 = 0;
            while (n2 < n) {
                String maximum = stringArray[n2];
                this.tuneMaximum(rrd, maximum);
                ++n2;
            }
            stringArray = dsNames;
            n = dsNames.length;
            n2 = 0;
            while (n2 < n) {
                String dsName = stringArray[n2];
                this.tuneName(rrd, dsName);
                ++n2;
            }
            stringArray = dsTypes;
            n = dsTypes.length;
            n2 = 0;
            while (n2 < n) {
                String dsType = stringArray[n2];
                this.tuneType(rrd, dsType);
                ++n2;
            }
            if (heartbeats.length == 0 && minimums.length == 0 && maximums.length == 0 && dsTypes.length == 0 && dsNames.length == 0) {
                this.dump(rrd);
            }
        }
        finally {
            RrdTuneCmd.releaseRrdDbReference(rrd);
        }
        return path;
    }

    private void tuneHeartbeat(RrdDb rrd, String heartbeatStr) throws IOException {
        String[] tokens = new ColonSplitter(heartbeatStr).split();
        if (tokens.length != 2) {
            throw new IllegalArgumentException("Invalid suntax in: " + heartbeatStr);
        }
        String dsName = tokens[0];
        long heartbeat = Long.parseLong(tokens[1]);
        Datasource ds = rrd.getDatasource(dsName);
        ds.setHeartbeat(heartbeat);
    }

    private void tuneMinimum(RrdDb rrd, String minimumStr) throws IOException {
        String[] tokens = new ColonSplitter(minimumStr).split();
        if (tokens.length != 2) {
            throw new IllegalArgumentException("Invalid suntax in: " + minimumStr);
        }
        String dsName = tokens[0];
        double minValue = Util.parseDouble(tokens[1]);
        Datasource ds = rrd.getDatasource(dsName);
        ds.setMinValue(minValue, false);
    }

    private void tuneMaximum(RrdDb rrd, String maximumStr) throws IOException {
        String[] tokens = new ColonSplitter(maximumStr).split();
        if (tokens.length != 2) {
            throw new IllegalArgumentException("Invalid suntax in: " + maximumStr);
        }
        String dsName = tokens[0];
        double maxValue = Util.parseDouble(tokens[1]);
        Datasource ds = rrd.getDatasource(dsName);
        ds.setMaxValue(maxValue, false);
    }

    private void tuneName(RrdDb rrd, String nameStr) throws IOException {
        String[] tokens = new ColonSplitter(nameStr).split();
        if (tokens.length != 2) {
            throw new IllegalArgumentException("Invalid suntax in: " + nameStr);
        }
        String oldName = tokens[0];
        String newName = tokens[1];
        Datasource ds = rrd.getDatasource(oldName);
        ds.setDsName(newName);
    }

    private void tuneType(RrdDb rrd, String typeStr) throws IOException {
        String[] tokens = new ColonSplitter(typeStr).split();
        if (tokens.length != 2) {
            throw new IllegalArgumentException("Invalid suntax in: " + typeStr);
        }
        String dsName = tokens[0];
        DsType dsType = DsType.valueOf(tokens[1]);
        Datasource ds = rrd.getDatasource(dsName);
        ds.setDsType(dsType);
    }

    private void dump(RrdDb rrd) throws IOException {
        StringBuilder line = new StringBuilder();
        int n = rrd.getDsCount();
        int i = 0;
        while (i < n) {
            Datasource ds = rrd.getDatasource(i);
            line.append("DS[");
            line.append(ds.getDsName());
            line.append("] typ: ");
            line.append((Object)ds.getDsType());
            while (line.length() < 24) {
                line.append(' ');
            }
            line.append("hbt: ");
            line.append(ds.getHeartbeat());
            while (line.length() < 40) {
                line.append(' ');
            }
            line.append("min: ");
            line.append(String.format("%-11f", ds.getMinValue()));
            line.append("max: ");
            line.append(String.format("%-11f", ds.getMaxValue()));
            RrdTuneCmd.println(line.toString());
            line.setLength(0);
            ++i;
        }
    }
}

