package pickewanalysis.wavesources;

import java.util.List;
import pickewanalysis.waveform.WaveForm;
import pickewanalysis.waveform.WaveFormGroup;

public class TankFile extends WaveSource {
    
    List<WaveFormGroup> groups; //To store all the data

    public TankFile() {
        //do nothing
    }

    public void update() throws Exception {
        this.clear(); //Clear current list
        groups = WaveFormGroup.parseTankFile(sourceName).splitStations();
        for (WaveFormGroup group : groups) {
            WaveSourceStation station = new WaveSourceStation(
                    group.get(0).getStation(), group.get(0).getChannel(),
                    group.get(0).getNetwork(), group.get(0).getLocation(),
                    group.get(0).getStartTime(), group.get(group.size() - 1).getEndTime());
            this.add(station);
        }
    }

    @Override
    public WaveFormGroup read(String stat, String chan, String net, String loc,
            long starttime, long endtime) throws Exception {
        if (groups==null) {
            this.clear();
            groups = WaveFormGroup.parseTankFile(sourceName).splitStations();
        }
        //Find group for the correct station
        for (WaveFormGroup group : groups) {
            if (group.containsStation(stat, chan, net, loc)) {
                //Select waveforms with the proper time interval
                WaveFormGroup output = new WaveFormGroup();
                for (WaveForm wave:group) {
                    if (wave.getStartTime()<endtime&&wave.getEndTime()>starttime) {
                        output.add(wave);
                    }
                }
                return output;
            }
        }
        return null;
    }
}
